/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.Exe;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class PE {
    public static final String NL = System.getProperty("line.separator", "\n");
    RandomAccessFile rfile;
    String filename;
    Exe.ExeHeader exeHeader;
    DOSHeader dosHeader;
    Coff.FileHeader fileHeader;
    Coff.OptionalHeader optionalHeader;
    NTOptionalHeader ntHeader;
    ImageDataDirectory[] dataDirectories;
    Coff.SectionHeader[] scnhdrs;
    Coff.Symbol[] symbolTable;
    byte[] stringTable;

    public PE(String filename) throws IOException {
        this(filename, 0L);
    }

    public PE(String filename, long pos) throws IOException {
        this(filename, pos, true);
    }

    public PE(String filename, long pos, boolean filter) throws IOException {
        block10: {
            try {
                this.rfile = new RandomAccessFile(filename, "r");
                this.filename = filename;
                this.rfile.seek(pos);
                try {
                    this.exeHeader = new Exe.ExeHeader(this.rfile);
                    this.dosHeader = new DOSHeader(this.rfile);
                    this.rfile.seek(this.dosHeader.e_lfanew);
                    byte[] sig = new byte[4];
                    this.rfile.readFully(sig);
                    if (sig[0] != 80 || sig[1] != 69 || sig[2] != 0 || sig[3] != 0) {
                        throw new IOException("Not a PE format");
                    }
                }
                catch (IOException iOException) {
                    this.rfile.seek(pos);
                }
                this.fileHeader = new Coff.FileHeader(this.rfile, this.rfile.getFilePointer());
                switch (this.fileHeader.f_magic) {
                    case 332: 
                    case 354: 
                    case 358: 
                    case 360: 
                    case 388: 
                    case 418: 
                    case 422: 
                    case 448: 
                    case 450: 
                    case 496: 
                    case 512: 
                    case 614: 
                    case 616: 
                    case 644: 
                    case 870: 
                    case 1126: {
                        break;
                    }
                    default: {
                        throw new IOException("Unknow machine/format");
                    }
                }
                if (this.fileHeader.f_opthdr > 0) {
                    this.optionalHeader = new Coff.OptionalHeader(this.rfile, this.rfile.getFilePointer());
                    this.ntHeader = new NTOptionalHeader(this.rfile, this.rfile.getFilePointer());
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.rfile != null) {
                    this.rfile.close();
                    this.rfile = null;
                }
                throw throwable;
            }
            Object var6_7 = null;
            if (this.rfile == null) break block10;
            this.rfile.close();
            this.rfile = null;
        }
    }

    public Attribute getAttribute() {
        Attribute attrib = new Attribute();
        Coff.FileHeader filhdr = this.getFileHeader();
        switch (filhdr.f_magic) {
            case 0: {
                attrib.cpu = "none";
                break;
            }
            case 388: {
                attrib.cpu = "alpha";
                break;
            }
            case 448: {
                attrib.cpu = "arm";
                break;
            }
            case 644: {
                attrib.cpu = "arm64";
                break;
            }
            case 332: {
                attrib.cpu = "x86";
                break;
            }
            case 512: {
                attrib.cpu = "ia64";
                break;
            }
            case 616: {
                attrib.cpu = "m68k";
                break;
            }
            case 614: {
                attrib.cpu = "mips16";
                break;
            }
            case 870: {
                attrib.cpu = "mipsfpu";
                break;
            }
            case 1126: {
                attrib.cpu = "mipsfpu16";
                break;
            }
            case 496: {
                attrib.cpu = "powerpc";
                break;
            }
            case 354: {
                attrib.cpu = "r3000";
                break;
            }
            case 358: {
                attrib.cpu = "r4000";
                break;
            }
            case 360: {
                attrib.cpu = "r10000";
                break;
            }
            case 418: {
                attrib.cpu = "sh3";
                break;
            }
            case 422: {
                attrib.cpu = "sh4";
                break;
            }
            case 450: {
                attrib.cpu = "thumb";
            }
        }
        attrib.type = (filhdr.f_flags & 0x2000) != 0 ? 2 : ((filhdr.f_flags & 2) != 0 ? 1 : 3);
        attrib.isle = true;
        if ((filhdr.f_flags & 0x80) != 0) {
            attrib.isle = true;
        }
        if ((filhdr.f_flags & 0x8000) != 0) {
            attrib.isle = false;
        }
        attrib.bDebug = (filhdr.f_flags & 0x200) == 0;
        if ((filhdr.f_flags & 0x40) != 0) {
            attrib.word = 16;
        }
        if ((filhdr.f_flags & 0x100) != 0) {
            attrib.word = 32;
        }
        return attrib;
    }

    public void dispose() throws IOException {
        if (this.rfile != null) {
            this.rfile.close();
            this.rfile = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        Object var1_3 = null;
        super.finalize();
    }

    public Exe.ExeHeader getExeHeader() {
        return this.exeHeader;
    }

    public DOSHeader getDOSHeader() {
        return this.dosHeader;
    }

    public Coff.FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public Coff.OptionalHeader getOptionalHeader() {
        return this.optionalHeader;
    }

    public NTOptionalHeader getNTOptionalHeader() {
        return this.ntHeader;
    }

    public ImageDataDirectory[] getImageDataDirectories() throws IOException {
        if (this.dataDirectories == null) {
            RandomAccessFile accessFile = this.getRandomAccessFile();
            long offset = 0L;
            if (this.dosHeader != null) {
                offset = this.dosHeader.e_lfanew + 4;
            }
            accessFile.seek(offset += 116L);
            this.dataDirectories = new ImageDataDirectory[16];
            byte[] data = new byte[this.dataDirectories.length * 8];
            accessFile.readFully(data);
            ReadMemoryAccess memory = new ReadMemoryAccess(data, true);
            int i = 0;
            while (i < this.dataDirectories.length) {
                int rva = memory.getInt();
                int size = memory.getInt();
                this.dataDirectories[i] = new ImageDataDirectory(rva, size);
                ++i;
            }
            this.dispose();
        }
        return this.dataDirectories;
    }

    public Coff.SectionHeader[] getSectionHeaders() throws IOException {
        if (this.scnhdrs == null) {
            RandomAccessFile accessFile = this.getRandomAccessFile();
            this.scnhdrs = new Coff.SectionHeader[this.fileHeader.f_nscns];
            long offset = 0L;
            if (this.dosHeader != null) {
                offset = this.dosHeader.e_lfanew + 4;
            }
            offset += (long)(20 + this.fileHeader.f_opthdr);
            int i = 0;
            while (i < this.scnhdrs.length) {
                this.scnhdrs[i] = new Coff.SectionHeader(accessFile, offset);
                ++i;
                offset += 40L;
            }
            this.dispose();
        }
        return this.scnhdrs;
    }

    public Coff.Symbol[] getSymbols() throws IOException {
        if (this.symbolTable == null) {
            RandomAccessFile accessFile = this.getRandomAccessFile();
            long offset = this.fileHeader.f_symptr;
            this.symbolTable = new Coff.Symbol[this.fileHeader.f_nsyms];
            int i = 0;
            while (i < this.symbolTable.length) {
                this.symbolTable[i] = new Coff.Symbol(accessFile, offset);
                ++i;
                offset += 18L;
            }
            this.dispose();
        }
        return this.symbolTable;
    }

    public byte[] getStringTable() throws IOException {
        if (this.stringTable == null) {
            if (this.fileHeader.f_nsyms > 0) {
                RandomAccessFile accessFile = this.getRandomAccessFile();
                long symbolsize = 18 * this.fileHeader.f_nsyms;
                long offset = (long)this.fileHeader.f_symptr + symbolsize;
                accessFile.seek(offset);
                byte[] bytes = new byte[4];
                accessFile.readFully(bytes);
                int str_len = ReadMemoryAccess.getIntLE(bytes);
                if (str_len > 4) {
                    this.stringTable = new byte[str_len -= 4];
                    accessFile.seek(offset + 4L);
                    accessFile.readFully(this.stringTable);
                } else {
                    this.stringTable = new byte[0];
                }
                this.dispose();
            } else {
                this.stringTable = new byte[0];
            }
        }
        return this.stringTable;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        if (this.exeHeader != null) {
            buffer.append(this.exeHeader);
        }
        if (this.dosHeader != null) {
            buffer.append(this.dosHeader);
        }
        buffer.append(this.fileHeader);
        if (this.optionalHeader != null) {
            buffer.append(this.optionalHeader);
        }
        if (this.ntHeader != null) {
            buffer.append(this.ntHeader);
        }
        try {
            ImageDataDirectory[] dirs = this.getImageDataDirectories();
            i = 0;
            while (i < dirs.length) {
                buffer.append("Entry ").append(i);
                buffer.append(" ").append(dirs[i]);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Coff.SectionHeader[] sections = this.getSectionHeaders();
            i = 0;
            while (i < sections.length) {
                buffer.append(sections[i]);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Coff.Symbol[] symbols = this.getSymbols();
            i = 0;
            while (i < symbols.length) {
                buffer.append(symbols[i]);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            byte[] bytes = this.getStringTable();
            String[] strings = Coff.getStringTable(bytes);
            int i2 = 0;
            while (i2 < strings.length) {
                buffer.append(strings[i2]);
                ++i2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.rfile == null) {
            this.rfile = new RandomAccessFile(this.filename, "r");
        }
        return this.rfile;
    }

    public static void main(String[] args) {
        try {
            PE pe = new PE(args[0]);
            System.out.println(pe);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class Attribute {
        public static final int PE_TYPE_EXE = 1;
        public static final int PE_TYPE_SHLIB = 2;
        public static final int PE_TYPE_OBJ = 3;
        public static final int PE_TYPE_CORE = 4;
        String cpu;
        int type;
        int word;
        boolean bDebug;
        boolean isle;

        public String getCPU() {
            return this.cpu;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasDebug() {
            return this.bDebug;
        }

        public boolean isLittleEndian() {
            return this.isle;
        }

        public int getWord() {
            return this.word;
        }
    }

    public static class DOSHeader {
        static final int DOSHDRSZ = 100;
        byte[] e_res = new byte[8];
        byte[] e_oemid = new byte[2];
        byte[] e_oeminfo = new byte[2];
        byte[] e_res2 = new byte[20];
        int e_lfanew;
        byte[] dos_message = new byte[64];

        public DOSHeader(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer());
        }

        public DOSHeader(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] hdr = new byte[100];
            file.readFully(hdr);
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, true);
            memory.getBytes(this.e_res);
            memory.getBytes(this.e_oemid);
            memory.getBytes(this.e_oeminfo);
            memory.getBytes(this.e_res2);
            this.e_lfanew = memory.getInt();
            memory.getBytes(this.dos_message);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("DOS STUB VALUES").append(NL);
            buffer.append("e_lfanew = ").append(this.e_lfanew).append(NL);
            buffer.append(new String(this.dos_message)).append(NL);
            return buffer.toString();
        }
    }

    public static class NTOptionalHeader {
        public static final int NTHDRSZ = 68;
        public int ImageBase;
        public int SectionAlignment;
        public int FileAlignment;
        public short MajorOperatingSystemVersion;
        public short MinorOperatingSystemVersion;
        public short MajorImageVersion;
        public short MinorImageVersion;
        public short MajorSubsystemVersion;
        public short MinorSubsystemVersion;
        public byte[] Reserved = new byte[4];
        public int SizeOfImage;
        public int SizeOfHeaders;
        public int CheckSum;
        public short Subsystem;
        public short DLLCharacteristics;
        public int SizeOfStackReserve;
        public int SizeOfStackCommit;
        public int SizeOfHeapReserve;
        public int SizeOfHeapCommit;
        public int LoaderFlags;
        public int NumberOfRvaAndSizes;

        public NTOptionalHeader(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer());
        }

        public NTOptionalHeader(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] hdr = new byte[68];
            file.readFully(hdr);
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, true);
            this.ImageBase = memory.getInt();
            this.SectionAlignment = memory.getInt();
            this.FileAlignment = memory.getInt();
            this.MajorOperatingSystemVersion = memory.getShort();
            this.MinorOperatingSystemVersion = memory.getShort();
            this.MajorImageVersion = memory.getShort();
            this.MinorImageVersion = memory.getShort();
            this.MajorSubsystemVersion = memory.getShort();
            this.MinorSubsystemVersion = memory.getShort();
            memory.getBytes(this.Reserved);
            this.SizeOfImage = memory.getInt();
            this.SizeOfHeaders = memory.getInt();
            this.CheckSum = memory.getInt();
            this.Subsystem = memory.getShort();
            this.DLLCharacteristics = memory.getShort();
            this.SizeOfStackReserve = memory.getInt();
            this.SizeOfStackCommit = memory.getInt();
            this.SizeOfHeapReserve = memory.getInt();
            this.SizeOfHeapCommit = memory.getInt();
            this.LoaderFlags = memory.getInt();
            this.NumberOfRvaAndSizes = memory.getInt();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("NT OPTIONAL HEADER VALUES").append(NL);
            buffer.append("ImageBase = ").append(this.ImageBase).append(NL);
            buffer.append("SexctionAlignement = ").append(this.SectionAlignment).append(NL);
            buffer.append("FileAlignment = ").append(this.FileAlignment).append(NL);
            buffer.append("MajorOSVersion = ").append(this.MajorOperatingSystemVersion).append(NL);
            buffer.append("MinorOSVersion = ").append(this.MinorOperatingSystemVersion).append(NL);
            buffer.append("MajorImageVersion = ").append(this.MajorImageVersion).append(NL);
            buffer.append("MinorImageVersion = ").append(this.MinorImageVersion).append(NL);
            buffer.append("MajorSubVersion = ").append(this.MajorSubsystemVersion).append(NL);
            buffer.append("MinorSubVersion = ").append(this.MinorSubsystemVersion).append(NL);
            buffer.append("Reserved = ").append(this.Reserved).append(NL);
            buffer.append("SizeOfImage = ").append(this.SizeOfImage).append(NL);
            buffer.append("SizeOfHeaders = ").append(this.SizeOfHeaders).append(NL);
            buffer.append("CheckSum = ").append(this.CheckSum).append(NL);
            buffer.append("Subsystem = ").append(this.Subsystem).append(NL);
            buffer.append("DLL = ").append(this.DLLCharacteristics).append(NL);
            buffer.append("StackReserve = ").append(this.SizeOfStackReserve).append(NL);
            buffer.append("StackCommit = ").append(this.SizeOfStackCommit).append(NL);
            buffer.append("HeapReserve = ").append(this.SizeOfHeapReserve).append(NL);
            buffer.append("HeapCommit = ").append(this.SizeOfHeapCommit).append(NL);
            buffer.append("LoaderFlags = ").append(this.LoaderFlags).append(NL);
            buffer.append("#Rva size = ").append(this.NumberOfRvaAndSizes).append(NL);
            return buffer.toString();
        }
    }

    public class ImageDataDirectory {
        public int rva;
        public int size;

        public ImageDataDirectory(int r, int s) {
            this.rva = r;
            this.size = s;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("rva = ").append(this.rva).append(" ");
            buffer.append("size = ").append(this.size).append(NL);
            return buffer.toString();
        }
    }

    public class ImportDirectoryEntry {
        public static final int ENTRYSZ = 20;
        public int rva;
        public int timestamp;
        public int forwarder;
        public int name;
        public int thunk;

        public ImportDirectoryEntry(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer());
        }

        public ImportDirectoryEntry(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] bytes = new byte[20];
            file.readFully(bytes);
            ReadMemoryAccess memory = new ReadMemoryAccess(bytes, true);
            this.rva = memory.getInt();
            this.timestamp = memory.getInt();
            this.forwarder = memory.getInt();
            this.name = memory.getInt();
            this.thunk = memory.getInt();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("rva = ").append(this.rva);
            buffer.append(" timestamp = ").append(this.timestamp);
            buffer.append(" forwarder = ").append(this.forwarder);
            buffer.append(" name = ").append(this.name);
            buffer.append(" thunk = ").append(this.thunk).append(NL);
            return buffer.toString();
        }
    }
}

