/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.launch.internal.ui.AbstractCDebuggerTab;
import org.eclipse.cdt.launch.ui.ICDTLaunchHelpContextIds;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class CorefileDebuggerTab
extends AbstractCDebuggerTab {
    protected Combo fDCombo;
    private boolean initializingComboBox = false;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)ICDTLaunchHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_DEBBUGER_TAB);
        GridLayout topLayout = new GridLayout(2, false);
        comp.setLayout((Layout)topLayout);
        Label dlabel = new Label(comp, 0);
        dlabel.setText("Debugger:");
        this.fDCombo = new Combo(comp, 12);
        this.fDCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CorefileDebuggerTab.this.handleDebuggerChanged();
            }
        });
        Group debuggerGroup = new Group(comp, 16);
        debuggerGroup.setText("Debugger Options");
        this.setDynamicTabHolder((Composite)debuggerGroup);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)tabHolderLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.getDynamicTabHolder().setLayoutData((Object)gd);
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration config, String selection) {
        if (this.initializingComboBox) {
            return;
        }
        this.initializingComboBox = true;
        String configPlatform = this.getPlatform(config);
        ICElement ce = this.getContext(config, null);
        String projectPlatform = "*";
        String projectCPU = "*";
        if (ce != null) {
            try {
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(ce.getCProject().getProject());
                projectPlatform = descriptor.getPlatform();
                IBinary bin = (IBinary)ce;
                projectCPU = bin.getCPU();
            }
            catch (Exception exception) {}
        }
        this.fDCombo.removeAll();
        ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getDebugConfigurations();
        int x = 0;
        int selndx = -1;
        int i = 0;
        while (i < debugConfigs.length) {
            if (debugConfigs[i].supportsMode("core")) {
                String debuggerPlatform = debugConfigs[i].getPlatform();
                boolean platformMatch = configPlatform.equals(projectPlatform);
                if ((debuggerPlatform.equalsIgnoreCase(projectPlatform) || platformMatch && projectPlatform.equals("*")) && debugConfigs[i].supportsCPU(projectCPU)) {
                    this.fDCombo.add(debugConfigs[i].getName());
                    this.fDCombo.setData(Integer.toString(x), (Object)debugConfigs[i]);
                    if (selndx == -1 && debuggerPlatform.equalsIgnoreCase(projectPlatform) || selection.equals(debugConfigs[i].getID())) {
                        selndx = x;
                    }
                    ++x;
                }
            }
            ++i;
        }
        this.setInitializeDefault(selection.equals(""));
        this.fDCombo.select(selndx == -1 ? 0 : selndx);
        this.handleDebuggerChanged();
        this.fDCombo.getParent().layout(true);
        this.initializingComboBox = false;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        try {
            String id = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "");
            if (this.getDebugConfig() == null || !this.getDebugConfig().getID().equals(id)) {
                this.loadDebuggerComboBox(config, id);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "core");
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (!this.validateDebuggerConfig(config)) {
            this.setErrorMessage("No debugger available");
            return false;
        }
        return super.isValid(config);
    }

    private boolean validateDebuggerConfig(ILaunchConfiguration config) {
        ICDebugConfiguration debugConfig;
        String platform = this.getPlatform(config);
        ICElement ce = this.getContext(config, null);
        String projectPlatform = "*";
        String projectCPU = "*";
        if (ce != null) {
            try {
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(ce.getCProject().getProject());
                projectPlatform = descriptor.getPlatform();
                IBinary bin = (IBinary)ce;
                projectCPU = bin.getCPU();
            }
            catch (Exception exception) {}
        }
        if ((debugConfig = this.getDebugConfig()) == null) {
            return false;
        }
        String debuggerPlatform = debugConfig.getPlatform();
        boolean platformMatch = platform.equals(projectPlatform);
        if ((debuggerPlatform.equalsIgnoreCase(projectPlatform) || platformMatch && projectPlatform.equals("*")) && debugConfig.supportsCPU(projectCPU)) {
            return true;
        }
        this.setDebugConfig(null);
        return false;
    }

    protected ICDebugConfiguration getConfigForCurrentDebugger() {
        int selectedIndex = this.fDCombo.getSelectionIndex();
        return (ICDebugConfiguration)this.fDCombo.getData(Integer.toString(selectedIndex));
    }

    protected void handleDebuggerChanged() {
        super.handleDebuggerChanged();
    }
}

