/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model.type;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIDerivedType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.IncompleteType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.Type;

public abstract class DerivedType
extends Type
implements ICDIDerivedType {
    ICDIType derivedType;

    public DerivedType(ICDITarget target, String typename) {
        super(target, typename);
    }

    public void setComponentType(ICDIType dtype) {
        this.derivedType = dtype;
    }

    public void setComponentType(String name) {
        ICDITarget target = this.getTarget();
        Session session = (Session)target.getSession();
        SourceManager sourceMgr = (SourceManager)session.getSourceManager();
        try {
            this.derivedType = sourceMgr.getType(target, name);
        }
        catch (CDIException cDIException) {
            try {
                String ptype = sourceMgr.getDetailTypeName(name);
                this.derivedType = sourceMgr.getType(target, ptype);
            }
            catch (CDIException cDIException2) {}
        }
        if (this.derivedType == null) {
            this.derivedType = new IncompleteType(this.getTarget(), name);
        }
    }

    public abstract ICDIType getComponentType();
}

