/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command;

import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.command.MICommand;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;

public class MIDataReadMemory
extends MICommand {
    public MIDataReadMemory(long offset, String address, int wordFormat, int wordSize, int rows, int cols, Character asChar) {
        super("-data-read-memory");
        if (offset != 0L) {
            this.setOptions(new String[]{"-o", Long.toString(offset)});
        }
        String format = "x";
        switch (wordFormat) {
            case 15: {
                format = "u";
                break;
            }
            case 10: {
                format = "f";
                break;
            }
            case 11: {
                format = "a";
                break;
            }
            case 12: {
                format = "i";
                break;
            }
            case 13: {
                format = "c";
                break;
            }
            case 14: {
                format = "s";
                break;
            }
            case 3: {
                format = "d";
                break;
            }
            case 2: {
                format = "t";
                break;
            }
            case 1: {
                format = "o";
                break;
            }
            default: {
                format = "x";
            }
        }
        if (asChar == null) {
            this.setParameters(new String[]{address, format, Integer.toString(wordSize), Integer.toString(rows), Integer.toString(cols)});
        } else {
            this.setParameters(new String[]{address, format, Integer.toString(wordSize), Integer.toString(rows), Integer.toString(cols), asChar.toString()});
        }
    }

    public MIDataReadMemoryInfo getMIDataReadMemoryInfo() throws MIException {
        return (MIDataReadMemoryInfo)this.getMIInfo();
    }

    public MIInfo getMIInfo() throws MIException {
        MIDataReadMemoryInfo info = null;
        MIOutput out = this.getMIOutput();
        if (out != null && (info = new MIDataReadMemoryInfo(out)).isError()) {
            this.throwMIException(info, out);
        }
        return info;
    }
}

