/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.internal.core.parser.util.ASTUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class BasicSearchResultCollector
implements ICSearchResultCollector {
    private Set results;

    public void aboutToStart() {
        this.results = new HashSet();
    }

    public void done() {
    }

    public IProgressMonitor getProgressMonitor() {
        return null;
    }

    public IMatch createMatch(Object fileResource, int start, int end, ISourceElementCallbackDelegate node) throws CoreException {
        BasicSearchMatch result = new BasicSearchMatch();
        return this.createMatch(result, fileResource, start, end, node);
    }

    public IMatch createMatch(BasicSearchMatch result, Object fileResource, int start, int end, ISourceElementCallbackDelegate node) throws CoreException {
        if (fileResource instanceof IResource) {
            result.resource = (IResource)fileResource;
        } else if (fileResource instanceof IPath) {
            result.path = (IPath)fileResource;
        }
        result.startOffset = start;
        result.endOffset = end;
        result.parentName = "";
        IASTOffsetableNamedElement offsetable = null;
        if (node instanceof IASTReference) {
            offsetable = (IASTOffsetableNamedElement)((Object)((IASTReference)node).getReferencedElement());
            result.name = ((IASTReference)node).getName();
        } else if (node instanceof IASTOffsetableNamedElement) {
            offsetable = (IASTOffsetableNamedElement)((Object)node);
            result.name = offsetable.getName();
        }
        result.parentName = "";
        String[] names = null;
        if (offsetable instanceof IASTEnumerator) {
            IASTEnumerator enumerator = (IASTEnumerator)offsetable;
            names = enumerator.getOwnerEnumerationSpecifier().getFullyQualifiedName();
        } else if (offsetable instanceof IASTQualifiedNameElement) {
            names = ((IASTQualifiedNameElement)((Object)offsetable)).getFullyQualifiedName();
        }
        if (names != null) {
            int i = 0;
            while (i < names.length - 1) {
                if (i > 0) {
                    result.parentName = String.valueOf(result.parentName) + "::";
                }
                result.parentName = String.valueOf(result.parentName) + names[i];
                ++i;
            }
        }
        if (offsetable instanceof IASTFunction) {
            result.name = String.valueOf(result.name) + this.getParameterString((IASTFunction)offsetable);
            result.returnType = ASTUtil.getType(((IASTFunction)offsetable).getReturnType());
        }
        this.setElementInfo(result, offsetable);
        return result;
    }

    private String getParameterString(IASTFunction function) {
        if (function == null) {
            return "";
        }
        String paramString = "(";
        Iterator iter = function.getParameters();
        boolean first = true;
        while (iter.hasNext()) {
            IASTParameterDeclaration param = (IASTParameterDeclaration)iter.next();
            if (!first) {
                paramString = String.valueOf(paramString) + ", ";
            }
            IASTTypeSpecifier typeSpec = param.getTypeSpecifier();
            if (param.isConst()) {
                paramString = String.valueOf(paramString) + "const ";
            }
            if (typeSpec instanceof IASTSimpleTypeSpecifier) {
                paramString = String.valueOf(paramString) + ((IASTSimpleTypeSpecifier)typeSpec).getTypename();
            } else if (typeSpec instanceof IASTOffsetableNamedElement) {
                paramString = String.valueOf(paramString) + ((IASTOffsetableNamedElement)((Object)typeSpec)).getName();
            } else if (typeSpec instanceof IASTElaboratedTypeSpecifier) {
                ASTClassKind kind = ((IASTElaboratedTypeSpecifier)typeSpec).getClassKind();
                if (kind == ASTClassKind.CLASS) {
                    paramString = String.valueOf(paramString) + "class ";
                } else if (kind == ASTClassKind.STRUCT) {
                    paramString = String.valueOf(paramString) + "struct ";
                } else if (kind == ASTClassKind.ENUM) {
                    paramString = String.valueOf(paramString) + "enum ";
                } else if (kind == ASTClassKind.UNION) {
                    paramString = String.valueOf(paramString) + "union ";
                }
                paramString = String.valueOf(paramString) + ((IASTElaboratedTypeSpecifier)typeSpec).getName();
            }
            Iterator ptrs = param.getPointerOperators();
            if (ptrs.hasNext()) {
                paramString = String.valueOf(paramString) + " ";
            }
            while (ptrs.hasNext()) {
                ASTPointerOperator ptr = (ASTPointerOperator)ptrs.next();
                if (ptr == ASTPointerOperator.POINTER) {
                    paramString = String.valueOf(paramString) + "*";
                } else if (ptr == ASTPointerOperator.REFERENCE) {
                    paramString = String.valueOf(paramString) + "&";
                } else if (ptr == ASTPointerOperator.CONST_POINTER) {
                    paramString = String.valueOf(paramString) + " const * ";
                } else if (ptr == ASTPointerOperator.VOLATILE_POINTER) {
                    paramString = String.valueOf(paramString) + " volatile * ";
                }
                ptr = ASTPointerOperator.POINTER;
            }
            first = false;
        }
        paramString = String.valueOf(paramString) + ")";
        return paramString;
    }

    public boolean acceptMatch(IMatch match) throws CoreException {
        if (!this.results.contains(match)) {
            this.results.add(match);
            return true;
        }
        return false;
    }

    public Set getSearchResults() {
        return this.results;
    }

    private void setElementInfo(BasicSearchMatch match, IASTOffsetableElement node) {
        if (node instanceof IASTClassSpecifier || node instanceof IASTElaboratedTypeSpecifier) {
            ASTClassKind kind = null;
            kind = node instanceof IASTClassSpecifier ? ((IASTClassSpecifier)node).getClassKind() : ((IASTElaboratedTypeSpecifier)node).getClassKind();
            if (kind == ASTClassKind.CLASS) {
                match.type = 64;
            } else if (kind == ASTClassKind.STRUCT) {
                match.type = 65;
            } else if (kind == ASTClassKind.UNION) {
                match.type = 66;
            }
        } else if (node instanceof IASTNamespaceDefinition) {
            match.type = 61;
        } else if (node instanceof IASTEnumerationSpecifier) {
            match.type = 63;
        } else if (node instanceof IASTMacro) {
            match.type = 77;
        } else if (node instanceof IASTField) {
            match.type = 69;
            IASTField field = (IASTField)node;
            ASTAccessVisibility visibility = field.getVisiblity();
            if (visibility == ASTAccessVisibility.PUBLIC) {
                match.visibility = 8192;
            } else if (visibility == ASTAccessVisibility.PRIVATE) {
                match.visibility = 4096;
            }
            match.isConst = field.getAbstractDeclaration().isConst();
            match.isStatic = field.isStatic();
        } else if (node instanceof IASTVariable) {
            match.type = 74;
            IASTVariable variable = (IASTVariable)node;
            match.isConst = variable.getAbstractDeclaration().isConst();
        } else if (node instanceof IASTEnumerator) {
            match.type = 79;
        } else if (node instanceof IASTMethod) {
            match.type = 67;
            IASTMethod method = (IASTMethod)node;
            ASTAccessVisibility visibility = method.getVisiblity();
            if (visibility == ASTAccessVisibility.PUBLIC) {
                match.visibility = 8192;
            } else if (visibility == ASTAccessVisibility.PRIVATE) {
                match.visibility = 4096;
            }
            match.isConst = method.isConst();
            match.isVolatile = method.isVolatile();
            match.isStatic = method.isStatic();
        } else if (node instanceof IASTFunction) {
            match.type = 71;
            IASTFunction function = (IASTFunction)node;
            match.isStatic = function.isStatic();
        } else if (node instanceof IASTTypedefDeclaration) {
            match.type = 78;
        }
    }
}

