/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.problem;

import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IReferenceContext;
import org.eclipse.cdt.core.parser.ITranslationOptions;
import org.eclipse.cdt.core.parser.ITranslationResult;
import org.eclipse.cdt.internal.core.parser.IErrorHandlingPolicy;
import org.eclipse.cdt.internal.core.parser.IProblemFactory;

public class ProblemHandler {
    public static final String[] NoArgument = new String[0];
    public final IErrorHandlingPolicy policy;
    public final IProblemFactory problemFactory;
    private final ITranslationOptions options;

    public ProblemHandler(IErrorHandlingPolicy policy, ITranslationOptions options, IProblemFactory problemFactory) {
        this.policy = policy;
        this.problemFactory = problemFactory;
        this.options = options;
    }

    public int computeSeverity(int problemId) {
        if (problemId == 536871362) {
            return 65536;
        }
        return 1;
    }

    public IProblem createProblem(char[] fileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, int lineNumber, IReferenceContext referenceContext, ITranslationResult unitResult) {
        return this.problemFactory.createProblem(fileName, problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, lineNumber);
    }

    public void handle(int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, int line, IReferenceContext referenceContext, ITranslationResult unitResult) {
        if (severity == -1) {
            return;
        }
        IProblem problem = this.createProblem(unitResult.getFileName(), problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, line >= 0 ? line : 1, referenceContext, unitResult);
        if (problem == null) {
            return;
        }
        this.record(problem, unitResult, referenceContext);
    }

    public void handle(int problemId, String[] problemArguments, String[] messageArguments, int problemStartPosition, int problemEndPosition, int line, IReferenceContext referenceContext, ITranslationResult unitResult) {
        this.handle(problemId, problemArguments, messageArguments, this.computeSeverity(problemId), problemStartPosition, problemEndPosition, line, referenceContext, unitResult);
    }

    public void record(IProblem problem, ITranslationResult unitResult, IReferenceContext referenceContext) {
        unitResult.record(problem, referenceContext);
    }

    public ITranslationOptions getOptions() {
        return this.options;
    }
}

