/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.internal.corext.template.ContextType;
import org.eclipse.cdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.corext.template.TemplateSet;
import org.eclipse.cdt.internal.corext.template.Templates;
import org.eclipse.cdt.internal.ui.preferences.EditTemplateDialog;
import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.template.TemplateContentProvider;
import org.eclipse.cdt.internal.ui.text.template.TemplateLabelProvider;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TemplatePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREF_FORMAT_TEMPLATES = "org.eclipse.cdt.ui.template.format";
    private Templates fTemplates;
    private CheckboxTableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fImportButton;
    private Button fExportButton;
    private Button fExportAllButton;
    private Button fRemoveButton;
    private Button fEnableAllButton;
    private Button fDisableAllButton;
    private SourceViewer fPatternViewer;

    public TemplatePreferencePage() {
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(TemplateMessages.getString("TemplatePreferencePage.message"));
        this.fTemplates = Templates.getInstance();
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Table table = new Table(parent, 67618);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(TemplateMessages.getString("TemplatePreferencePage.column.name"));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(TemplateMessages.getString("TemplatePreferencePage.column.context"));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(TemplateMessages.getString("TemplatePreferencePage.column.description"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70));
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof Template && object2 instanceof Template) {
                    Template left = (Template)object1;
                    Template right = (Template)object2;
                    int result = left.getName().compareToIgnoreCase(right.getName());
                    if (result != 0) {
                        return result;
                    }
                    return left.getDescription().compareToIgnoreCase(right.getDescription());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                TemplatePreferencePage.this.edit();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TemplatePreferencePage.this.selectionChanged1();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Template template = (Template)event.getElement();
                template.setEnabled(event.getChecked());
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fAddButton));
        this.fAddButton.setText(TemplateMessages.getString("TemplatePreferencePage.new"));
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.add();
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fEditButton));
        this.fEditButton.setText(TemplateMessages.getString("TemplatePreferencePage.edit"));
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.edit();
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fRemoveButton));
        this.fRemoveButton.setText(TemplateMessages.getString("TemplatePreferencePage.remove"));
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.remove();
            }
        });
        this.createSpacer(buttons);
        this.fImportButton = new Button(buttons, 8);
        this.fImportButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fImportButton));
        this.fImportButton.setText(TemplateMessages.getString("TemplatePreferencePage.import"));
        this.fImportButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.import_();
            }
        });
        this.fExportButton = new Button(buttons, 8);
        this.fExportButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fExportButton));
        this.fExportButton.setText(TemplateMessages.getString("TemplatePreferencePage.export"));
        this.fExportButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.export();
            }
        });
        this.fExportAllButton = new Button(buttons, 8);
        this.fExportAllButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fExportAllButton));
        this.fExportAllButton.setText(TemplateMessages.getString("TemplatePreferencePage.export.all"));
        this.fExportAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.exportAll();
            }
        });
        this.createSpacer(buttons);
        this.fEnableAllButton = new Button(buttons, 8);
        this.fEnableAllButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fEnableAllButton));
        this.fEnableAllButton.setText(TemplateMessages.getString("TemplatePreferencePage.enable.all"));
        this.fEnableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.enableAll(true);
            }
        });
        this.fDisableAllButton = new Button(buttons, 8);
        this.fDisableAllButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fDisableAllButton));
        this.fDisableAllButton.setText(TemplateMessages.getString("TemplatePreferencePage.disable.all"));
        this.fDisableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.enableAll(false);
            }
        });
        this.fPatternViewer = this.createViewer(parent);
        this.createSpacer(parent);
        this.fTableViewer.setInput((Object)this.fTemplates);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
        this.updateButtons();
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.cdt.ui.new_c_templates_pref_page_context");
        return parent;
    }

    private Template[] getEnabledTemplates() {
        Template[] templates = this.fTemplates.getTemplates();
        ArrayList<Template> list = new ArrayList<Template>(templates.length);
        int i = 0;
        while (i != templates.length) {
            if (templates[i].isEnabled()) {
                list.add(templates[i]);
            }
            ++i;
        }
        return list.toArray(new Template[list.size()]);
    }

    private SourceViewer createViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Preview:");
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        SourceViewer viewer = new SourceViewer(parent, null, 2816);
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        viewer.configure((SourceViewerConfiguration)new CSourceViewerConfiguration(tools, null));
        viewer.setEditable(false);
        viewer.setDocument((IDocument)new Document());
        viewer.getTextWidget().setBackground(this.getShell().getDisplay().getSystemColor(22));
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        viewer.getTextWidget().setFont(font);
        Control control = viewer.getControl();
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    public void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.heightHint = 4;
        spacer.setLayoutData((Object)data);
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        data.widthHint = SWTUtil.getButtonWidthHint(button);
        data.heightHint = SWTUtil.getButtonHeigthHint(button);
        return data;
    }

    protected void selectionChanged1() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            Template template = (Template)selection.getFirstElement();
            this.fPatternViewer.getTextWidget().setText(template.getPattern());
        } else {
            this.fPatternViewer.getTextWidget().setText("");
        }
        this.updateButtons();
    }

    private void updateButtons() {
        int selectionCount = ((IStructuredSelection)this.fTableViewer.getSelection()).size();
        int itemCount = this.fTableViewer.getTable().getItemCount();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fExportButton.setEnabled(selectionCount > 0);
        this.fRemoveButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount);
        this.fEnableAllButton.setEnabled(itemCount > 0);
        this.fDisableAllButton.setEnabled(itemCount > 0);
    }

    protected void add() {
        String contextTypeName;
        Template template = new Template();
        ContextTypeRegistry registry = ContextTypeRegistry.getInstance();
        ContextType type = registry.getContextType("C");
        if (type != null) {
            contextTypeName = type.getName();
        } else {
            Iterator iterator = registry.iterator();
            contextTypeName = (String)iterator.next();
        }
        template.setContext(contextTypeName);
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), template, false);
        if (dialog.open() == 0) {
            this.fTemplates.add(template);
            this.fTableViewer.refresh();
            this.fTableViewer.setChecked((Object)template, template.isEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)template));
        }
    }

    protected void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        Template template = (Template)selection.getFirstElement();
        this.edit(template);
    }

    private void edit(Template template) {
        Template newTemplate = new Template(template);
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), newTemplate, true);
        if (dialog.open() == 0) {
            if (!newTemplate.getName().equals(template.getName()) && MessageDialog.openQuestion((Shell)this.getShell(), (String)TemplateMessages.getString("TemplatePreferencePage.question.create.new.title"), (String)TemplateMessages.getString("TemplatePreferencePage.question.create.new.message"))) {
                template = newTemplate;
                this.fTemplates.add(template);
                this.fTableViewer.refresh();
            } else {
                template.setName(newTemplate.getName());
                template.setDescription(newTemplate.getDescription());
                template.setContext(newTemplate.getContextTypeName());
                template.setPattern(newTemplate.getPattern());
                this.fTableViewer.refresh((Object)template);
            }
            this.fTableViewer.setChecked((Object)template, template.isEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)template));
        }
    }

    protected void import_() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(TemplateMessages.getString("TemplatePreferencePage.import.title"));
        dialog.setFilterExtensions(new String[]{TemplateMessages.getString("TemplatePreferencePage.import.extension")});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            this.fTemplates.addFromFile(new File(path));
            this.fTableViewer.refresh();
            this.fTableViewer.setAllChecked(false);
            this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
        }
        catch (CoreException e) {
            this.openReadErrorDialog(e);
        }
    }

    protected void exportAll() {
        this.export(this.fTemplates);
    }

    protected void export() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] templates = selection.toArray();
        TemplateSet templateSet = new TemplateSet();
        int i = 0;
        while (i != templates.length) {
            templateSet.add((Template)templates[i]);
            ++i;
        }
        this.export(templateSet);
    }

    private void export(TemplateSet templateSet) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(TemplateMessages.getFormattedString("TemplatePreferencePage.export.title", new Integer(templateSet.getTemplates().length)));
        dialog.setFilterExtensions(new String[]{TemplateMessages.getString("TemplatePreferencePage.export.extension")});
        dialog.setFileName(TemplateMessages.getString("TemplatePreferencePage.export.filename"));
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (!file.exists() || this.confirmOverwrite(file)) {
            try {
                templateSet.saveToFile(file);
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e);
                this.openWriteErrorDialog(e);
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)TemplateMessages.getString("TemplatePreferencePage.export.exists.title"), (String)TemplateMessages.getFormattedString("TemplatePreferencePage.export.exists.message", file.getAbsolutePath()));
    }

    protected void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            Template template = (Template)elements.next();
            this.fTemplates.remove(template);
        }
        this.fTableViewer.refresh();
    }

    protected void enableAll(boolean enable) {
        Template[] templates = this.fTemplates.getTemplates();
        int i = 0;
        while (i != templates.length) {
            templates[i].setEnabled(enable);
            ++i;
        }
        this.fTableViewer.setAllChecked(enable);
    }

    public void init(IWorkbench workbench) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(TemplateMessages.getString("TemplatePreferencePage.title"));
        }
    }

    protected void performDefaults() {
        try {
            this.fTemplates.restoreDefaults();
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
            this.openReadErrorDialog(e);
        }
        this.fTableViewer.refresh();
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
    }

    public boolean performOk() {
        try {
            this.fTemplates.save();
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
            this.openWriteErrorDialog(e);
        }
        return super.performOk();
    }

    public boolean performCancel() {
        try {
            this.fTemplates.reset();
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
            this.openReadErrorDialog(e);
        }
        return super.performCancel();
    }

    public static void initDefaults(IPreferenceStore prefs) {
        prefs.setDefault(PREF_FORMAT_TEMPLATES, true);
    }

    public static boolean useCodeFormatter() {
        IPreferenceStore prefs = CUIPlugin.getDefault().getPreferenceStore();
        return prefs.getBoolean(PREF_FORMAT_TEMPLATES);
    }

    private void openReadErrorDialog(CoreException e) {
        ErrorDialog.openError((Shell)this.getShell(), (String)TemplateMessages.getString("TemplatePreferencePage.error.read.title"), null, (IStatus)e.getStatus());
    }

    private void openWriteErrorDialog(CoreException e) {
        ErrorDialog.openError((Shell)this.getShell(), (String)TemplateMessages.getString("TemplatePreferencePage.error.write.title"), null, (IStatus)e.getStatus());
    }
}

