/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ITranslationResult;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CTaskTagsReconciler {
    private static CTaskTagsReconciler instance = null;

    private CTaskTagsReconciler() {
    }

    public static CTaskTagsReconciler getInstance() {
        if (instance == null) {
            instance = new CTaskTagsReconciler();
        }
        return instance;
    }

    public void acceptResult(ITranslationUnit translationUnit, ITranslationResult result) {
        try {
            this.updateTasksFor(translationUnit, result);
        }
        catch (CoreException e) {
            System.out.println("Exception while accepting parse results");
            e.printStackTrace();
        }
    }

    protected void updateTasksFor(ITranslationUnit sourceFile, ITranslationResult result) throws CoreException {
        IProblem[] tasks = result.getTasks();
        this.storeTasksFor(sourceFile, tasks);
    }

    protected void storeTasksFor(ITranslationUnit sourceFile, IProblem[] tasks) throws CoreException {
        int i;
        if (sourceFile == null) {
            return;
        }
        if (tasks == null) {
            tasks = new IProblem[]{};
        }
        IResource resource = sourceFile.getResource();
        IMarker[] existingTaskMarkers = resource.findMarkers("org.eclipse.cdt.core.task", false, 1);
        HashSet<IMarker> taskSet = new HashSet<IMarker>();
        if (existingTaskMarkers != null) {
            i = 0;
            while (i < existingTaskMarkers.length) {
                taskSet.add(existingTaskMarkers[i]);
                ++i;
            }
        }
        i = 0;
        int l = tasks.length;
        while (i < l) {
            block13: {
                IProblem task = tasks[i];
                if (task.getID() == 536871362) {
                    int priority = 1;
                    String compilerPriority = task.getArguments()[2];
                    if ("HIGH".equals(compilerPriority)) {
                        priority = 2;
                    } else if ("LOW".equals(compilerPriority)) {
                        priority = 0;
                    }
                    if (existingTaskMarkers != null && existingTaskMarkers.length > 0) {
                        int j = 0;
                        while (j < existingTaskMarkers.length) {
                            if (((Integer)existingTaskMarkers[j].getAttribute("lineNumber")).intValue() == task.getSourceLineNumber() && (Integer)existingTaskMarkers[j].getAttribute("priority") == priority && ((Integer)existingTaskMarkers[j].getAttribute("charStart")).intValue() == task.getSourceStart() && (Integer)existingTaskMarkers[j].getAttribute("charEnd") == task.getSourceEnd() + 1 && ((String)existingTaskMarkers[j].getAttribute("message")).equals(task.getMessage())) {
                                taskSet.remove(existingTaskMarkers[j]);
                                break block13;
                            }
                            ++j;
                        }
                    }
                    IMarker marker = resource.createMarker("org.eclipse.cdt.core.task");
                    marker.setAttributes(new String[]{"message", "priority", "done", "charStart", "charEnd", "lineNumber", "userEditable"}, new Object[]{task.getMessage(), new Integer(priority), new Boolean(false), new Integer(task.getSourceStart()), new Integer(task.getSourceEnd() + 1), new Integer(task.getSourceLineNumber()), new Boolean(false)});
                }
            }
            ++i;
        }
        Iterator setI = taskSet.iterator();
        while (setI.hasNext()) {
            IMarker marker = (IMarker)setI.next();
            marker.delete();
        }
    }
}

