/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.Reader;
import java.util.Map;
import org.eclipse.cdt.core.parser.ILineOffsetReconciler;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IPreprocessor;
import org.eclipse.cdt.core.parser.IProblemReporter;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITranslationResult;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.internal.core.parser.DefaultErrorHandlingPolicies;
import org.eclipse.cdt.internal.core.parser.LineOffsetReconciler;
import org.eclipse.cdt.internal.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.Preprocessor;
import org.eclipse.cdt.internal.core.parser.QuickParseCallback;
import org.eclipse.cdt.internal.core.parser.Scanner;
import org.eclipse.cdt.internal.core.parser.TranslationOptions;
import org.eclipse.cdt.internal.core.parser.TranslationResult;
import org.eclipse.cdt.internal.core.parser.ast.complete.CompleteParseASTFactory;
import org.eclipse.cdt.internal.core.parser.ast.quick.QuickParseASTFactory;
import org.eclipse.cdt.internal.core.parser.problem.DefaultProblemFactory;
import org.eclipse.cdt.internal.core.parser.problem.ProblemReporter;

public class ParserFactory {
    public static IASTFactory createASTFactory(ParserMode mode, ParserLanguage language) {
        if (mode == ParserMode.QUICK_PARSE) {
            return new QuickParseASTFactory();
        }
        return new CompleteParseASTFactory(language);
    }

    public static IParser createParser(IScanner scanner, ISourceElementRequestor callback, ParserMode mode, ParserLanguage language) {
        return ParserFactory.createParser(scanner, callback, mode, language, null, null);
    }

    public static IParser createParser(IScanner scanner, ISourceElementRequestor callback, ParserMode mode, ParserLanguage language, IProblemReporter problemReporter, ITranslationResult unitResult) {
        ParserMode ourMode = mode == null ? ParserMode.COMPLETE_PARSE : mode;
        ISourceElementRequestor ourCallback = callback == null ? new NullSourceElementRequestor() : callback;
        return new Parser(scanner, ourCallback, ourMode, language, problemReporter, unitResult);
    }

    public static IScanner createScanner(Reader input, String fileName, IScannerInfo config, ParserMode mode, ParserLanguage language, ISourceElementRequestor requestor) {
        return ParserFactory.createScanner(input, fileName, config, mode, language, requestor, null, null);
    }

    public static IScanner createScanner(Reader input, String fileName, IScannerInfo config, ParserMode mode, ParserLanguage language, ISourceElementRequestor requestor, IProblemReporter problemReporter, ITranslationResult unitResult) {
        ParserMode ourMode = mode == null ? ParserMode.COMPLETE_PARSE : mode;
        ISourceElementRequestor ourRequestor = requestor == null ? new NullSourceElementRequestor() : requestor;
        Scanner s = new Scanner(input, fileName, config, problemReporter, unitResult, ourRequestor, ourMode, language);
        return s;
    }

    public static IPreprocessor createPreprocessor(Reader input, String fileName, IScannerInfo info, ParserMode mode, ParserLanguage language, ISourceElementRequestor requestor) {
        return ParserFactory.createPreprocessor(input, fileName, info, mode, language, requestor, null, null);
    }

    public static IPreprocessor createPreprocessor(Reader input, String fileName, IScannerInfo info, ParserMode mode, ParserLanguage language, ISourceElementRequestor requestor, IProblemReporter problemReporter, ITranslationResult unitResult) {
        ParserMode ourMode = mode == null ? ParserMode.COMPLETE_PARSE : mode;
        ISourceElementRequestor ourRequestor = requestor == null ? new NullSourceElementRequestor() : requestor;
        Preprocessor s = new Preprocessor(input, fileName, info, ourRequestor, problemReporter, unitResult, ourMode, language);
        return s;
    }

    public static ILineOffsetReconciler createLineOffsetReconciler(Reader input) {
        return new LineOffsetReconciler(input);
    }

    public static IProblemReporter createProblemReporter(Map options) {
        TranslationOptions cOptions = new TranslationOptions(options);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), cOptions, new DefaultProblemFactory());
        return problemReporter;
    }

    public static ITranslationResult createTranslationResult(String fileName) {
        return new TranslationResult(fileName);
    }

    public static IQuickParseCallback createQuickParseCallback() {
        return new QuickParseCallback();
    }
}

