/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import org.eclipse.cdt.core.ICPathEntry;
import org.eclipse.core.runtime.IPath;

public class CPathEntry
implements ICPathEntry {
    public int entryKind;
    public IPath path;
    public IPath[] exclusionPatterns;
    public IPath sourceAttachmentPath;
    public IPath sourceAttachmentRootPath;
    public IPath sourceAttachmentPrefixMapping;
    private char[][] fullCharExclusionPatterns;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    public static final IPath[] NO_EXCLUSION_PATTERNS = new IPath[0];

    public CPathEntry(int entryKind, IPath path, IPath[] exclusionPatterns, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping) {
        this.entryKind = entryKind;
        this.path = path;
        this.exclusionPatterns = exclusionPatterns;
        if (exclusionPatterns.length > 0) {
            this.fullCharExclusionPatterns = UNINIT_PATTERNS;
        }
        this.sourceAttachmentPath = sourceAttachmentPath;
        this.sourceAttachmentRootPath = sourceAttachmentRootPath;
        this.sourceAttachmentPrefixMapping = sourceAttachmentPrefixMapping;
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullCharExclusionPatterns == UNINIT_PATTERNS) {
            int length = this.exclusionPatterns.length;
            this.fullCharExclusionPatterns = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullCharExclusionPatterns[i] = prefixPath.append(this.exclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullCharExclusionPatterns;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public IPath getSourceAttachmentPrefixMapping() {
        return this.sourceAttachmentPrefixMapping;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ICPathEntry) {
            ICPathEntry otherEntry = (ICPathEntry)object;
            if (this.entryKind != otherEntry.getEntryKind()) {
                return false;
            }
            if (!this.path.equals((Object)otherEntry.getPath())) {
                return false;
            }
            IPath otherPath = otherEntry.getSourceAttachmentPath();
            if (this.sourceAttachmentPath == null ? otherPath != null : !this.sourceAttachmentPath.equals((Object)otherPath)) {
                return false;
            }
            otherPath = otherEntry.getSourceAttachmentRootPath();
            if (this.sourceAttachmentRootPath == null ? otherPath != null : !this.sourceAttachmentRootPath.equals((Object)otherPath)) {
                return false;
            }
            IPath[] otherExcludes = otherEntry.getExclusionPatterns();
            if (this.exclusionPatterns != otherExcludes) {
                int excludeLength = this.exclusionPatterns.length;
                if (otherExcludes.length != excludeLength) {
                    return false;
                }
                int i = 0;
                while (i < excludeLength) {
                    if (!this.exclusionPatterns[i].toString().equals(otherExcludes[i].toString())) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("inc")) {
            return 5;
        }
        return -1;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return "prj";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "inc";
            }
        }
        return "unknown";
    }

    public String toString() {
        IPath[] patterns;
        int length;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPath().toString());
        buffer.append('[');
        switch (this.getEntryKind()) {
            case 1: {
                buffer.append("CPE_LIBRARY");
                break;
            }
            case 2: {
                buffer.append("CPE_PROJECT");
                break;
            }
            case 3: {
                buffer.append("CPE_SOURCE");
                break;
            }
            case 4: {
                buffer.append("CPE_VARIABLE");
                break;
            }
            case 5: {
                buffer.append("CPE_INCLUDE");
            }
        }
        buffer.append(']');
        if (this.getSourceAttachmentPath() != null) {
            buffer.append("[sourcePath:");
            buffer.append(this.getSourceAttachmentPath());
            buffer.append(']');
        }
        if (this.getSourceAttachmentRootPath() != null) {
            buffer.append("[rootPath:");
            buffer.append(this.getSourceAttachmentRootPath());
            buffer.append(']');
        }
        if ((length = (patterns = this.getExclusionPatterns()).length) > 0) {
            buffer.append("[excluding:");
            int i = 0;
            while (i < length) {
                buffer.append(patterns[i]);
                if (i != length - 1) {
                    buffer.append('|');
                }
                ++i;
            }
            buffer.append(']');
        }
        return buffer.toString();
    }
}

