/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.impl.InMemoryIndex;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;

public class SimpleIndexInput
extends IndexInput {
    protected WordEntry[] sortedWordEntries;
    protected IncludeEntry[] sortedIncludes;
    protected IndexedFile currentFile;
    protected IndexedFile[] sortedFiles;
    protected InMemoryIndex index;

    public SimpleIndexInput(InMemoryIndex index) {
        this.index = index;
    }

    public void clearCache() {
    }

    public void close() throws IOException {
        this.sortedFiles = null;
    }

    public IndexedFile getCurrentFile() throws IOException {
        if (!this.hasMoreFiles()) {
            return null;
        }
        return this.currentFile;
    }

    public IndexedFile getIndexedFile(int fileNum) throws IOException {
        int i = 0;
        while (i < this.sortedFiles.length) {
            if (this.sortedFiles[i].getFileNumber() == fileNum) {
                return this.sortedFiles[i];
            }
            ++i;
        }
        return null;
    }

    public IndexedFile getIndexedFile(IDocument document) throws IOException {
        String name = document.getName();
        int i = this.index.getNumFiles();
        while (i >= 1) {
            IndexedFile file = this.getIndexedFile(i);
            if (name.equals(file.getPath())) {
                return file;
            }
            --i;
        }
        return null;
    }

    public int getNumFiles() {
        return this.index.getNumFiles();
    }

    public int getNumIncludes() {
        return this.sortedIncludes.length;
    }

    public int getNumWords() {
        return this.sortedWordEntries.length;
    }

    public Object getSource() {
        return this.index;
    }

    public void init() {
        this.index.init();
    }

    public void moveToNextFile() throws IOException {
        ++this.filePosition;
        if (!this.hasMoreFiles()) {
            return;
        }
        this.currentFile = this.sortedFiles[this.filePosition - 1];
    }

    public void moveToNextWordEntry() throws IOException {
        ++this.wordPosition;
        if (this.hasMoreWords()) {
            this.currentWordEntry = this.sortedWordEntries[this.wordPosition - 1];
        }
    }

    public void moveToNextIncludeEntry() throws IOException {
        ++this.includePosition;
        if (this.hasMoreIncludes()) {
            this.currentIncludeEntry = this.sortedIncludes[this.includePosition - 1];
        }
    }

    public void open() throws IOException {
        this.sortedWordEntries = this.index.getSortedWordEntries();
        this.sortedFiles = this.index.getSortedFiles();
        this.sortedIncludes = this.index.getSortedIncludeEntries();
        this.filePosition = 1;
        this.wordPosition = 1;
        this.includePosition = 1;
        this.setFirstFile();
        this.setFirstWord();
        this.setFirstInclude();
    }

    public IQueryResult[] query(String word) throws IOException {
        char[] wordChar = word.toCharArray();
        WordEntry wordEntry = this.index.getWordEntry(wordChar);
        int[] fileNums = wordEntry.getRefs();
        IQueryResult[] files = new IQueryResult[fileNums.length];
        int i = 0;
        while (i < files.length) {
            files[i] = this.getIndexedFile(fileNums[i]);
            ++i;
        }
        return files;
    }

    public IEntryResult[] queryEntriesPrefixedBy(char[] prefix) throws IOException {
        return null;
    }

    public IQueryResult[] queryFilesReferringToPrefix(char[] prefix) throws IOException {
        return null;
    }

    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        this.setFirstFile();
        ArrayList<String> matches = new ArrayList<String>();
        while (this.hasMoreFiles()) {
            IndexedFile file = this.getCurrentFile();
            if (file.getPath().indexOf(word) != -1) {
                matches.add(file.getPath());
            }
            this.moveToNextFile();
        }
        IQueryResult[] match = new IQueryResult[matches.size()];
        matches.toArray(match);
        return match;
    }

    protected void setFirstFile() throws IOException {
        this.filePosition = 1;
        if (this.sortedFiles.length > 0) {
            this.currentFile = this.sortedFiles[0];
        }
    }

    protected void setFirstWord() throws IOException {
        this.wordPosition = 1;
        if (this.sortedWordEntries.length > 0) {
            this.currentWordEntry = this.sortedWordEntries[0];
        }
    }

    protected void setFirstInclude() throws IOException {
        this.includePosition = 1;
        if (this.sortedIncludes.length > 0) {
            this.currentIncludeEntry = this.sortedIncludes[0];
        }
    }

    public IncludeEntry[] queryIncludeEntries() {
        return null;
    }

    public IncludeEntry[] queryIncludeEntries(int fileNum) throws IOException {
        return null;
    }
}

