/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.IOException;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.internal.core.model.parser.ElfBinaryArchive;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.parser.BinaryExecutable;
import org.eclipse.cdt.utils.elf.parser.BinaryObject;
import org.eclipse.cdt.utils.elf.parser.BinaryShared;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

public class GNUElfParser
extends AbstractCExtension
implements IBinaryParser {
    public IBinaryParser.IBinaryFile getBinary(IPath path) throws IOException {
        if (path == null) {
            path = new Path("");
        }
        PlatformObject binary = null;
        try {
            Elf.Attribute attribute = Elf.getAttributes(path.toOSString());
            if (attribute != null) {
                switch (attribute.getType()) {
                    case 1: {
                        binary = new BinaryExecutable(path);
                        break;
                    }
                    case 2: {
                        binary = new BinaryShared(path);
                        break;
                    }
                    case 3: {
                        binary = new BinaryObject(path);
                        break;
                    }
                    case 4: {
                        BinaryObject obj = new BinaryObject(path);
                        obj.setType(16);
                        binary = obj;
                    }
                }
            }
        }
        catch (IOException iOException) {
            binary = new ElfBinaryArchive(path);
        }
        return binary;
    }

    public String getFormat() {
        return "ELF";
    }

    String getAddr2LinePath() {
        ICExtensionReference ref = this.getExtensionReference();
        return ref.getExtensionData("addr2line");
    }

    String getCPPFiltPath() {
        ICExtensionReference ref = this.getExtensionReference();
        return ref.getExtensionData("c++filt");
    }
}

