/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;

public class SessionProcess
extends Process {
    MISession session;
    OutputStream out;

    public SessionProcess(MISession s) {
        this.session = s;
    }

    public void destroy() {
        this.session.getGDBProcess().destroy();
    }

    public int exitValue() {
        return this.session.getGDBProcess().exitValue();
    }

    public InputStream getErrorStream() {
        return this.session.getMILogStream();
    }

    public InputStream getInputStream() {
        return this.session.getMIConsoleStream();
    }

    public OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new OutputStream(){
                StringBuffer buf = new StringBuffer();

                public void write(int b) throws IOException {
                    this.buf.append((char)b);
                    if (b == 10) {
                        this.post();
                    }
                }

                public void post() throws IOException {
                    String str = this.buf.toString().trim();
                    CLICommand cmd = new CLICommand(str);
                    this.buf.setLength(0);
                    try {
                        SessionProcess.this.session.postCommand(cmd);
                    }
                    catch (MIException e) {
                        throw new IOException(e.getMessage());
                    }
                }
            };
        }
        return this.out;
    }

    public int waitFor() throws InterruptedException {
        return this.session.getGDBProcess().waitFor();
    }
}

