/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIConst
extends MIValue {
    String cstring = "";

    public String getCString() {
        return this.cstring;
    }

    public void setCString(String str) {
        this.cstring = str;
    }

    public String getString() {
        return MIConst.getString(this.cstring);
    }

    public static String getString(String str) {
        StringBuffer buffer = new StringBuffer();
        boolean escape = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\\') {
                if (escape) {
                    buffer.append(c);
                    escape = false;
                } else {
                    escape = true;
                }
            } else {
                if (escape) {
                    buffer.append(MIConst.isoC(c));
                } else {
                    buffer.append(c);
                }
                escape = false;
            }
            ++i;
        }
        if (escape) {
            buffer.append('\\');
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getCString();
    }

    private static String isoC(char c) {
        String s = new Character(c).toString();
        if (c == '\"') {
            s = "\"";
        } else if (c == '\'') {
            s = "'";
        } else if (c == '?') {
            s = "?";
        } else if (c == 'a') {
            s = "\u0007";
        } else if (c == 'b') {
            s = "\b";
        } else if (c == 'f') {
            s = "\f";
        } else if (c == 'n') {
            s = System.getProperty("line.separator", "\n");
        } else if (c == 'r') {
            s = "\r";
        } else if (c == 't') {
            s = "\t";
        } else if (c == 'v') {
            s = "\u000b";
        }
        return s;
    }
}

