/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEditNode;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEditNodeComparator;
import org.eclipse.cdt.internal.corext.textmanipulation.UndoMemento;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Assert;

public class TextBufferEditor {
    private TextBuffer fBuffer;
    private List fEdits;
    private TextEditNode.RootNode fRootNode;
    private int fNumberOfNodes;
    private int fConnectCount;
    private int fMode;
    static final int UNDEFINED = 0;
    static final int REDO = 1;
    static final int UNDO = 2;

    public TextBufferEditor(TextBuffer buffer) {
        this.fBuffer = buffer;
        Assert.isNotNull((Object)this.fBuffer);
        this.fEdits = new ArrayList();
    }

    public TextBuffer getTextBuffer() {
        return this.fBuffer;
    }

    public void add(TextEdit edit) throws CoreException {
        Assert.isTrue((this.fMode == 0 || this.fMode == 1 ? 1 : 0) != 0);
        this.internalAdd(edit);
        this.fMode = 1;
    }

    public void add(MultiTextEdit edit) throws CoreException {
        Assert.isTrue((this.fMode == 0 || this.fMode == 1 ? 1 : 0) != 0);
        edit.connect(this);
        this.fMode = 1;
    }

    public void add(UndoMemento undo) throws CoreException {
        Assert.isTrue((this.fMode == 0 ? 1 : 0) != 0);
        List list = undo.fEdits;
        int i = list.size() - 1;
        while (i >= 0) {
            this.internalAdd((TextEdit)list.get(i));
            --i;
        }
        this.fMode = undo.fMode;
    }

    public boolean canPerformEdits() {
        if (this.fRootNode != null) {
            return true;
        }
        this.fRootNode = this.buildTree();
        if (this.fRootNode == null) {
            return false;
        }
        if (this.fRootNode.validate(this.fBuffer.getLength())) {
            return true;
        }
        this.fRootNode = null;
        return false;
    }

    public void clear() {
        this.fRootNode = null;
        this.fMode = 0;
        this.fEdits.clear();
    }

    public UndoMemento performEdits(IProgressMonitor pm) throws CoreException {
        UndoMemento undoMemento;
        int size;
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if ((size = this.fEdits.size()) == 0) {
            return new UndoMemento(this.fMode == 2 ? 1 : 2);
        }
        if (this.fRootNode == null) {
            this.fRootNode = this.buildTree();
            if (this.fRootNode == null || !this.fRootNode.validate(this.fBuffer.getLength())) {
                Status s = new Status(4, "org.eclipse.cdt.ui", 1, "RootNode empty", null);
                throw new CoreException((IStatus)s);
            }
        }
        try {
            pm.beginTask("", this.fNumberOfNodes + 10);
            UndoMemento undo = null;
            if (this.fMode == 1) {
                undo = this.fRootNode.performDo(this.fBuffer, pm);
                this.fRootNode.performedDo();
            } else {
                undo = this.fRootNode.performUndo(this.fBuffer, pm);
                this.fRootNode.performedUndo();
            }
            pm.worked(10);
            undoMemento = undo;
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            pm.done();
            this.clear();
            throw throwable;
        }
        pm.done();
        this.clear();
        return undoMemento;
    }

    private TextEditNode.RootNode buildTree() {
        TextEditNode[] nodes = new TextEditNode[this.fEdits.size()];
        int i = this.fEdits.size() - 1;
        while (i >= 0) {
            nodes[i] = TextEditNode.create((TextEdit)this.fEdits.get(i));
            --i;
        }
        this.fNumberOfNodes = nodes.length;
        Arrays.sort(nodes, new TextEditNodeComparator());
        TextEditNode.RootNode root = new TextEditNode.RootNode(this.fBuffer.getLength());
        int i2 = 0;
        while (i2 < nodes.length) {
            root.add(nodes[i2]);
            ++i2;
        }
        return root;
    }

    private void internalAdd(TextEdit edit) throws CoreException {
        edit.index = this.fEdits.size();
        edit.isSynthetic = this.fConnectCount > 0;
        try {
            ++this.fConnectCount;
            edit.connect(this);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            --this.fConnectCount;
            throw throwable;
        }
        Object var2_4 = null;
        --this.fConnectCount;
        this.fEdits.add(edit);
    }
}

