/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.search.CSearchScopeFactory;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.ui.text.TextSearchOperation;
import org.eclipse.search.internal.ui.text.TextSearchResultCollector;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class FileSearchActionInWorkingSet
extends Action {
    private static final String PREFIX = "FileSearchActionInWorkingSet.";
    private ISelectionProvider fSelectionProvider;
    static /* synthetic */ Class class$0;

    public FileSearchActionInWorkingSet(ISelectionProvider provider) {
        super(CUIPlugin.getResourceString("FileSearchActionInWorkingSet.label"));
        this.setDescription(CUIPlugin.getResourceString("FileSearchActionInWorkingSet.description"));
        this.setToolTipText(CUIPlugin.getResourceString("FileSearchActionInWorkingSet.tooltip"));
        if (provider instanceof CContentOutlinePage) {
            CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.open_incl.gif");
        }
        this.fSelectionProvider = provider;
    }

    public void run() {
        String search_name;
        ISelection selection = this.fSelectionProvider.getSelection();
        if (selection instanceof ITextSelection) {
            search_name = ((ITextSelection)selection).getText();
            if (search_name.length() == 0) {
                return;
            }
        } else {
            ICElement element = FileSearchActionInWorkingSet.getElement(selection);
            if (element == null) {
                return;
            }
            search_name = element.getElementName();
        }
        TextSearchResultCollector col = new TextSearchResultCollector();
        try {
            SearchUI.activateSearchResultView();
            IWorkingSet[] workingSets = CSearchScopeFactory.getInstance().queryWorkingSets();
            ArrayList<IResource> resourceList = new ArrayList<IResource>();
            int i = 0;
            while (i < workingSets.length) {
                IAdaptable[] elements = workingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    IResource resource;
                    IAdaptable iAdaptable = elements[j];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                        resourceList.add(resource);
                    }
                    ++j;
                }
                ++i;
            }
            IResource[] result = new IResource[resourceList.size()];
            resourceList.toArray(result);
            SearchScope scope = new SearchScope("File Search", result);
            TextSearchOperation op = new TextSearchOperation(CUIPlugin.getWorkspace(), search_name, "", (ISearchScope)scope, col);
            ProgressMonitorDialog context = null;
            Shell shell = new Shell();
            if (context == null) {
                context = new ProgressMonitorDialog(shell);
            }
            try {
                context.run(true, true, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException ex) {
                ExceptionHandler.handle((InvocationTargetException)ex, (String)"Error", (String)"Error");
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception exception) {}
    }

    private static ICElement getElement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof ICElement) {
            return (ICElement)element;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getLength() > 0;
        }
        return FileSearchActionInWorkingSet.getElement(selection) != null;
    }

    public static String getEditorID(String name) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        if (registry != null) {
            IEditorDescriptor descriptor = registry.getDefaultEditor(name);
            if (descriptor != null) {
                return descriptor.getId();
            }
            return registry.getDefaultEditor().getId();
        }
        return null;
    }
}

