/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class TabFolderOptionBlock {
    protected boolean initializingTabs = true;
    private Composite composite;
    private boolean bShowMessageArea;
    private String fErrorMessage;
    private boolean bIsValid = true;
    private Label messageLabel;
    private ArrayList pages;
    protected ICOptionContainer fParent;
    private ICOptionPage fCurrentPage;
    private TabFolder fFolder;

    public TabFolderOptionBlock(ICOptionContainer parent, boolean showMessageArea) {
        this.fParent = parent;
        this.bShowMessageArea = showMessageArea;
    }

    public TabFolderOptionBlock(ICOptionContainer parent) {
        this(parent, true);
    }

    protected void addOptionPage(ICOptionPage page) {
        if (this.pages == null) {
            this.pages = new ArrayList();
        }
        if (!this.pages.contains(page)) {
            this.pages.add(page);
        }
    }

    protected List getOptionPages() {
        return this.pages;
    }

    public Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        if (this.bShowMessageArea) {
            this.messageLabel = new Label(this.composite, 16384);
            this.messageLabel.setFont(this.composite.getFont());
            this.messageLabel.setLayoutData((Object)new GridData(768));
            Label separator = new Label(this.composite, 256);
            separator.setLayoutData((Object)new GridData(768));
        }
        this.createFolder(this.composite);
        this.addTabs();
        this.setCurrentPage((ICOptionPage)this.pages.get(0));
        this.initializingTabs = false;
        String desc = ((ICOptionPage)this.pages.get(0)).getDescription();
        if (desc != null) {
            this.messageLabel.setText(desc);
        }
        return this.composite;
    }

    protected void createFolder(Composite parent) {
        this.fFolder = new TabFolder(parent, 0);
        this.fFolder.setLayoutData((Object)new GridData(1808));
        this.fFolder.setLayout((Layout)new TabFolderLayout());
        this.fFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TabFolderOptionBlock.this.initializingTabs) {
                    TabFolderOptionBlock.this.setCurrentPage((ICOptionPage)((TabItem)e.item).getData());
                    TabFolderOptionBlock.this.fParent.updateContainer();
                }
            }
        });
    }

    protected void addTab(ICOptionPage tab) {
        TabItem item = new TabItem(this.fFolder, 0);
        item.setText(tab.getTitle());
        Image img = tab.getImage();
        if (img != null) {
            item.setImage(img);
        }
        item.setData((Object)tab);
        tab.setContainer(this.fParent);
        tab.createControl((Composite)item.getParent());
        item.setControl(tab.getControl());
        this.addOptionPage(tab);
    }

    protected abstract void addTabs();

    public boolean performApply(IProgressMonitor monitor) {
        if (this.initializingTabs) {
            return false;
        }
        Iterator iter = ((AbstractList)this.pages).iterator();
        while (iter.hasNext()) {
            ICOptionPage tab = (ICOptionPage)iter.next();
            try {
                tab.performApply((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                CUIPlugin.errorDialog(this.composite.getShell(), "Error", "Error setting options", e);
                return false;
            }
        }
        return true;
    }

    public void setVisible(boolean visible) {
        if (this.initializingTabs) {
            return;
        }
        if (this.fCurrentPage != null) {
            this.fCurrentPage.setVisible(visible);
        }
        this.update();
    }

    public void update() {
        ICOptionPage tab;
        if (this.initializingTabs) {
            return;
        }
        boolean ok = true;
        Iterator iter = ((AbstractList)this.pages).iterator();
        while (iter.hasNext()) {
            tab = (ICOptionPage)iter.next();
            ok = tab.isValid();
            if (ok) continue;
            this.setErrorMessage(tab.getErrorMessage());
            break;
        }
        if (ok) {
            this.setErrorMessage(null);
            tab = this.getCurrentPage();
            if (this.bShowMessageArea && tab.getDescription() != null) {
                this.messageLabel.setText(tab.getDescription());
            }
        }
        this.setValid(ok);
    }

    private void setValid(boolean ok) {
        this.bIsValid = ok;
    }

    private void setErrorMessage(String message) {
        this.fErrorMessage = message;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public boolean isValid() {
        return this.bIsValid;
    }

    public void performDefaults() {
        if (this.initializingTabs) {
            return;
        }
        this.getCurrentPage().performDefaults();
    }

    public ICOptionPage getCurrentPage() {
        return this.fCurrentPage;
    }

    public void setCurrentPage(ICOptionPage page) {
        ICOptionPage oldPage = this.fCurrentPage;
        this.fCurrentPage = page;
        this.fCurrentPage.setVisible(true);
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
    }
}

