/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.ui.wizards.IWizardTab;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.cdt.utils.ui.controls.RadioButtonsArea;
import org.eclipse.cdt.utils.ui.swt.IValidation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class BinaryParserBlock
implements IWizardTab {
    private static String[][] radios;
    private IProject project;
    protected RadioButtonsArea radioButtons;
    private String id;
    IValidation page;

    public BinaryParserBlock(IValidation valid) {
        this(valid, null);
    }

    public BinaryParserBlock(IValidation valid, IProject p) {
        this.page = valid;
        this.project = p;
        IExtensionPoint point = CCorePlugin.getDefault().getDescriptor().getExtensionPoint("BinaryParser");
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            radios = new String[exts.length][2];
            int i = 0;
            while (i < exts.length) {
                BinaryParserBlock.radios[i] = new String[]{exts[i].getLabel(), exts[i].getUniqueIdentifier()};
                ++i;
            }
        }
        if (this.project != null) {
            try {
                ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(p);
                ICExtensionReference[] ref = desc.get("org.eclipse.cdt.core.BinaryParser");
                if (ref.length > 0) {
                    this.id = ref[0].getID();
                }
            }
            catch (CoreException coreException) {}
        }
        if (this.id == null) {
            this.id = CCorePlugin.getDefault().getPluginPreferences().getDefaultString("binaryparser");
            if (this.id == null || this.id.length() == 0) {
                this.id = "org.eclipse.cdt.core.ELF";
            }
        }
    }

    public String getLabel() {
        return "Binary Parser";
    }

    public Image getImage() {
        return null;
    }

    public Composite getControl(Composite parent) {
        Composite composite = ControlFactory.createComposite(parent, 1);
        this.radioButtons = new RadioButtonsArea(composite, "Parsers", 1, radios);
        this.radioButtons.setEnabled(true);
        if (this.id != null) {
            this.radioButtons.setSelectValue(this.id);
        }
        return composite;
    }

    public boolean isValid() {
        return true;
    }

    public void setVisible(boolean visible) {
    }

    public void doRun(IProject project, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Parsers", 1);
        try {
            ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(project);
            String identity = this.radioButtons.getSelectedValue();
            if (!(identity == null || this.id != null && identity.equals(this.id))) {
                desc.remove("org.eclipse.cdt.core.BinaryParser");
                desc.create("org.eclipse.cdt.core.BinaryParser", identity);
                CCorePlugin.getDefault().getCoreModel().resetBinaryParser(project);
                this.id = identity;
            }
        }
        catch (CoreException coreException) {}
    }
}

