/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDICharValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIDoubleValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFloatValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntegralType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongLongValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIPointerValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIReferenceValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIShortValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIWCharValue;
import org.eclipse.cdt.debug.core.model.ICExpressionEvaluator;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;

public class CValue
extends CDebugElement
implements ICValue {
    private CVariable fParent = null;
    private String fValueString = null;
    private ICDIValue fCDIValue;
    private List fVariables = Collections.EMPTY_LIST;
    static /* synthetic */ Class class$0;

    public CValue(CVariable parent, ICDIValue cdiValue) {
        super((CDebugTarget)parent.getDebugTarget());
        this.fParent = parent;
        this.fCDIValue = cdiValue;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getParentVariable() != null ? this.getParentVariable().getReferenceTypeName() : null;
    }

    public String getValueString() throws DebugException {
        if (this.fValueString == null && this.getUnderlyingValue() != null) {
            try {
                this.fValueString = this.processUnderlyingValue(this.getUnderlyingValue());
            }
            catch (CDIException e) {
                this.fValueString = e.getMessage();
            }
        }
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        List list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        if (!this.isAllocated() || !this.hasVariables()) {
            return Collections.EMPTY_LIST;
        }
        if (this.fVariables.size() == 0) {
            try {
                List vars = this.getCDIVariables();
                this.fVariables = new ArrayList(vars.size());
                Iterator it = vars.iterator();
                while (it.hasNext()) {
                    this.fVariables.add(new CModificationVariable(this, (ICDIVariable)it.next()));
                }
            }
            catch (DebugException e) {
                this.fVariables = new ArrayList(1);
                CModificationVariable var = new CModificationVariable(this, new CVariable.ErrorVariable(null, (Exception)((Object)e)));
                var.setStatus(2, e.getMessage());
                this.fVariables.add(var);
            }
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        try {
            ICDIValue value = this.getUnderlyingValue();
            if (value != null) {
                return value.getChildrenNumber() > 0;
            }
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
        return false;
    }

    public ICDIValue getUnderlyingValue() {
        return this.fCDIValue;
    }

    protected List getCDIVariables() throws DebugException {
        ICDIVariable[] vars = null;
        try {
            ICDIValue value = this.getUnderlyingValue();
            if (value != null && (vars = value.getVariables()) == null) {
                vars = new ICDIVariable[]{};
            }
        }
        catch (CDIException e) {
            this.requestFailed("not available: ", e);
        }
        return Arrays.asList(vars);
    }

    public synchronized void setChanged(boolean changed) throws DebugException {
        if (changed) {
            this.fValueString = null;
        }
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((CVariable)it.next()).setChanged(changed);
        }
    }

    public void dispose() {
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((CVariable)it.next()).dispose();
        }
    }

    public CVariable getParentVariable() {
        return this.fParent;
    }

    private String processUnderlyingValue(ICDIValue cdiValue) throws CDIException {
        if (cdiValue != null) {
            if (cdiValue instanceof ICDICharValue) {
                return this.getCharValueString((ICDICharValue)cdiValue);
            }
            if (cdiValue instanceof ICDIShortValue) {
                return this.getShortValueString((ICDIShortValue)cdiValue);
            }
            if (cdiValue instanceof ICDIIntValue) {
                return this.getIntValueString((ICDIIntValue)cdiValue);
            }
            if (cdiValue instanceof ICDILongValue) {
                return this.getLongValueString((ICDILongValue)cdiValue);
            }
            if (cdiValue instanceof ICDILongLongValue) {
                return this.getLongLongValueString((ICDILongLongValue)cdiValue);
            }
            if (cdiValue instanceof ICDIFloatValue) {
                return this.getFloatValueString((ICDIFloatValue)cdiValue);
            }
            if (cdiValue instanceof ICDIDoubleValue) {
                return this.getDoubleValueString((ICDIDoubleValue)cdiValue);
            }
            if (cdiValue instanceof ICDIPointerValue) {
                return this.getPointerValueString((ICDIPointerValue)cdiValue);
            }
            if (cdiValue instanceof ICDIReferenceValue) {
                return this.getReferenceValueString((ICDIReferenceValue)cdiValue);
            }
            if (cdiValue instanceof ICDIWCharValue) {
                return this.getWCharValueString((ICDIWCharValue)cdiValue);
            }
            return cdiValue.getValueString();
        }
        return null;
    }

    private String getCharValueString(ICDICharValue value) throws CDIException {
        switch (this.getParentVariable().getFormat()) {
            case 0: {
                byte byteValue = (byte)value.byteValue();
                return Character.isISOControl((char)byteValue) && byteValue != 8 && byteValue != 9 && byteValue != 10 && byteValue != 12 && byteValue != 13 || byteValue < 0 ? "" : new String(new byte[]{39, byteValue, 39});
            }
            case 1: {
                return this.isUnsigned() ? Integer.toString(value.shortValue()) : Integer.toString((byte)value.byteValue());
            }
            case 4: {
                StringBuffer sb = new StringBuffer("0x");
                String stringValue = this.isUnsigned() ? Integer.toHexString(value.shortValue()) : Integer.toHexString((byte)value.byteValue());
                sb.append(stringValue.length() > 2 ? stringValue.substring(stringValue.length() - 2) : stringValue);
                return sb.toString();
            }
        }
        return null;
    }

    private String getShortValueString(ICDIShortValue value) throws CDIException {
        switch (this.getParentVariable().getFormat()) {
            case 0: 
            case 1: {
                return this.isUnsigned() ? Integer.toString(value.intValue()) : Short.toString(value.shortValue());
            }
            case 4: {
                StringBuffer sb = new StringBuffer("0x");
                String stringValue = Integer.toHexString(this.isUnsigned() ? value.intValue() : (int)value.shortValue());
                sb.append(stringValue.length() > 4 ? stringValue.substring(stringValue.length() - 4) : stringValue);
                return sb.toString();
            }
        }
        return null;
    }

    private String getIntValueString(ICDIIntValue value) throws CDIException {
        switch (this.getParentVariable().getFormat()) {
            case 0: 
            case 1: {
                return this.isUnsigned() ? Long.toString(value.longValue()) : Integer.toString(value.intValue());
            }
            case 4: {
                StringBuffer sb = new StringBuffer("0x");
                String stringValue = this.isUnsigned() ? Long.toHexString(value.longValue()) : Integer.toHexString(value.intValue());
                sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
                return sb.toString();
            }
        }
        return null;
    }

    private String getLongValueString(ICDILongValue value) throws CDIException {
        switch (this.getParentVariable().getFormat()) {
            case 0: 
            case 1: {
                return this.isUnsigned() ? Long.toString(value.longValue()) : Integer.toString(value.intValue());
            }
            case 4: {
                StringBuffer sb = new StringBuffer("0x");
                String stringValue = Long.toHexString(this.isUnsigned() ? value.longValue() : (long)value.intValue());
                sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
                return sb.toString();
            }
        }
        return null;
    }

    private String getLongLongValueString(ICDILongLongValue value) throws CDIException {
        switch (this.getParentVariable().getFormat()) {
            case 0: 
            case 1: {
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    return bigValue.toString();
                }
                return Long.toString(value.longValue());
            }
            case 4: {
                StringBuffer sb = new StringBuffer("0x");
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    sb.append(bigValue.toString(16));
                } else {
                    sb.append(Long.toHexString(value.longValue()));
                }
                return sb.toString();
            }
        }
        return null;
    }

    private String getFloatValueString(ICDIFloatValue value) throws CDIException {
        float floatValue = value.floatValue();
        Float flt = new Float(floatValue);
        if (flt.isNaN() || flt.isInfinite()) {
            return "";
        }
        long longValue = flt.longValue();
        switch (this.getParentVariable().getFormat()) {
            case 0: {
                return Float.toString(floatValue);
            }
            case 1: {
                return Long.toString(longValue);
            }
            case 4: {
                StringBuffer sb = new StringBuffer("0x");
                String stringValue = Long.toHexString(longValue);
                sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
                return sb.toString();
            }
        }
        return null;
    }

    private String getDoubleValueString(ICDIDoubleValue value) throws CDIException {
        double doubleValue = value.doubleValue();
        Double dbl = new Double(doubleValue);
        if (dbl.isNaN() || dbl.isInfinite()) {
            return "";
        }
        long longValue = dbl.longValue();
        switch (this.getParentVariable().getFormat()) {
            case 0: {
                return dbl.toString();
            }
            case 1: {
                return Long.toString(longValue);
            }
            case 4: {
                StringBuffer sb = new StringBuffer("0x");
                String stringValue = Long.toHexString(longValue);
                sb.append(stringValue.length() > 16 ? stringValue.substring(stringValue.length() - 16) : stringValue);
                return sb.toString();
            }
        }
        return null;
    }

    private String getPointerValueString(ICDIPointerValue value) throws CDIException {
        long longValue = value.pointerValue();
        switch (this.getParentVariable().getFormat()) {
            case 1: {
                return Long.toString(longValue);
            }
            case 0: 
            case 4: {
                StringBuffer sb = new StringBuffer("0x");
                String stringValue = Long.toHexString(longValue);
                sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
                return sb.toString();
            }
        }
        return null;
    }

    private String getReferenceValueString(ICDIReferenceValue value) throws CDIException {
        long longValue = value.referenceValue();
        switch (this.getParentVariable().getFormat()) {
            case 1: {
                return Long.toString(longValue);
            }
            case 0: 
            case 4: {
                StringBuffer sb = new StringBuffer("0x");
                String stringValue = Long.toHexString(longValue);
                sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
                return sb.toString();
            }
        }
        return null;
    }

    private String getWCharValueString(ICDIWCharValue value) throws CDIException {
        if (this.getParentVariable() != null) {
            int size = this.getParentVariable().sizeof();
            if (size == 2) {
                switch (this.getParentVariable().getFormat()) {
                    case 0: 
                    case 1: {
                        return this.isUnsigned() ? Integer.toString(value.intValue()) : Short.toString(value.shortValue());
                    }
                    case 4: {
                        StringBuffer sb = new StringBuffer("0x");
                        String stringValue = Integer.toHexString(this.isUnsigned() ? value.intValue() : (int)value.shortValue());
                        sb.append(stringValue.length() > 4 ? stringValue.substring(stringValue.length() - 4) : stringValue);
                        return sb.toString();
                    }
                }
            }
            if (size == 4) {
                switch (this.getParentVariable().getFormat()) {
                    case 0: 
                    case 1: {
                        return this.isUnsigned() ? Long.toString(value.longValue()) : Integer.toString(value.intValue());
                    }
                    case 4: {
                        StringBuffer sb = new StringBuffer("0x");
                        String stringValue = this.isUnsigned() ? Long.toHexString(value.longValue()) : Integer.toHexString(value.intValue());
                        sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
                        return sb.toString();
                    }
                }
            }
        }
        return value.getValueString();
    }

    private boolean isUnsigned() {
        boolean result = false;
        try {
            if (this.getParentVariable().getCDIVariable() != null) {
                result = this.getParentVariable().getCDIVariable().getType() instanceof ICDIIntegralType ? ((ICDIIntegralType)this.getParentVariable().getCDIVariable().getType()).isUnsigned() : false;
            }
        }
        catch (CDIException cDIException) {}
        return result;
    }

    public String evaluateAsExpression() {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICExpressionEvaluator ee = (ICExpressionEvaluator)iDebugTarget.getAdapter((Class)clazz);
        String valueString = null;
        if (ee != null && ee.canEvaluate()) {
            try {
                if (this.getParentVariable() != null) {
                    valueString = ee.evaluateExpressionToString(this.getParentVariable().getQualifiedName());
                }
            }
            catch (DebugException e) {
                valueString = e.getMessage();
            }
        }
        return valueString;
    }

    protected void reset() throws DebugException {
        this.fValueString = null;
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((CVariable)it.next()).reset();
        }
    }
}

