/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.ISourceMode;
import org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;

public class CSourceManager
implements ICSourceLocator,
IPersistableSourceLocator,
ISourceMode,
IAdaptable {
    private ISourceLocator fSourceLocator = null;
    private int fMode;
    private int fRealMode = this.fMode = 0;
    private ILaunch fLaunch = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CSourceManager(ISourceLocator sourceLocator) {
        this.setSourceLocator(sourceLocator);
    }

    public int getLineNumber(IStackFrame frame) {
        if (this.getRealMode() == 0) {
            IStackFrameInfo info;
            if (this.getCSourceLocator() != null) {
                return this.getCSourceLocator().getLineNumber(frame);
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((info = (IStackFrameInfo)frame.getAdapter((Class)clazz)) != null) {
                return info.getFrameLineNumber();
            }
        }
        if (this.getRealMode() == 1 && this.getDisassemblyManager(frame) != null) {
            return this.getDisassemblyManager(frame).getLineNumber(frame);
        }
        return 0;
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().getSourceLocations() : new ICSourceLocation[]{};
    }

    public void setSourceLocations(ICSourceLocation[] locations) {
        if (this.getCSourceLocator() != null) {
            this.getCSourceLocator().setSourceLocations(locations);
        }
    }

    public boolean contains(IResource resource) {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().contains(resource) : false;
    }

    public int getMode() {
        return this.fMode;
    }

    public void setMode(int mode) {
        this.fMode = mode;
        this.setRealMode(mode);
    }

    public int getRealMode() {
        return this.fRealMode;
    }

    protected void setRealMode(int mode) {
        this.fRealMode = mode;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz) && this.fSourceLocator instanceof IResourceChangeListener) {
            return this.fSourceLocator;
        }
        return null;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        Object result = null;
        boolean autoDisassembly = CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_AUTO_DISASSEMBLY);
        if (this.getMode() == 0 && this.getSourceLocator() != null) {
            result = this.getSourceLocator().getSourceElement(stackFrame);
        }
        if (result == null && (autoDisassembly || this.getMode() == 1) && this.getDisassemblyManager(stackFrame) != null) {
            this.setRealMode(1);
            result = this.getDisassemblyManager(stackFrame).getSourceElement(stackFrame);
        } else {
            this.setRealMode(0);
        }
        return result;
    }

    protected ICSourceLocator getCSourceLocator() {
        if (this.getSourceLocator() instanceof ICSourceLocator) {
            return (ICSourceLocator)this.getSourceLocator();
        }
        return null;
    }

    protected ISourceLocator getSourceLocator() {
        if (this.fSourceLocator != null) {
            return this.fSourceLocator;
        }
        if (this.fLaunch != null) {
            return this.fLaunch.getSourceLocator();
        }
        return null;
    }

    protected void setSourceLocator(ISourceLocator sl) {
        this.fSourceLocator = sl;
    }

    protected DisassemblyManager getDisassemblyManager(IStackFrame stackFrame) {
        if (stackFrame != null) {
            IDebugTarget iDebugTarget = stackFrame.getDebugTarget();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (DisassemblyManager)iDebugTarget.getAdapter((Class)clazz);
        }
        return null;
    }

    public void addSourceLocation(ICSourceLocation location) {
        ICSourceLocation[] locations = this.getSourceLocations();
        ArrayList<ICSourceLocation> list = new ArrayList<ICSourceLocation>(Arrays.asList(locations));
        list.add(location);
        this.setSourceLocations(list.toArray(new ICSourceLocation[list.size()]));
    }

    public Object findSourceElement(String fileName) {
        if (this.getCSourceLocator() != null) {
            return this.getCSourceLocator().findSourceElement(fileName);
        }
        return null;
    }

    public String getMemento() throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            return this.getPersistableSourceLocator().getMemento();
        }
        return null;
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            this.getPersistableSourceLocator().initializeDefaults(configuration);
        }
    }

    public void initializeFromMemento(String memento) throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            this.getPersistableSourceLocator().initializeFromMemento(memento);
        }
    }

    private IPersistableSourceLocator getPersistableSourceLocator() {
        if (this.fSourceLocator instanceof IPersistableSourceLocator) {
            return (IPersistableSourceLocator)this.fSourceLocator;
        }
        return null;
    }

    public IProject getProject() {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().getProject() : null;
    }
}

