/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CBreakpointPreferencePage
extends FieldEditorPreferencePage {
    private Text fConditionTextControl;
    private BreakpointStringFieldEditor fCondition;
    private Text fIgnoreCountTextControl;
    private BreakpointIntegerFieldEditor fIgnoreCount;
    private ICBreakpoint fBreakpoint;

    public CBreakpointPreferencePage(ICBreakpoint breakpoint) {
        super(1);
        this.setBreakpoint(breakpoint);
        this.noDefaultAndApplyButton();
    }

    protected void createFieldEditors() {
        ICBreakpoint breakpoint = this.getBreakpoint();
        this.createTypeSpecificLabelFieldEditors(breakpoint);
        IPreferenceStore store = this.getPreferenceStore();
        try {
            String condition = breakpoint.getCondition();
            if (condition == null) {
                condition = "";
            }
            store.setValue("CONDITION", condition);
            this.createConditionEditor(this.getFieldEditorParent());
            store.setValue("ENABLED", breakpoint.isEnabled());
            int ignoreCount = breakpoint.getIgnoreCount();
            store.setValue("IGNORE_COUNT", ignoreCount >= 0 ? ignoreCount : 0);
            this.createIgnoreCountEditor(this.getFieldEditorParent());
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
    }

    private void createTypeSpecificLabelFieldEditors(ICBreakpoint breakpoint) {
        if (breakpoint instanceof ICFunctionBreakpoint) {
            ICFunctionBreakpoint fbrkpt = (ICFunctionBreakpoint)breakpoint;
            String function = "Not available";
            try {
                function = fbrkpt.getFunction();
            }
            catch (CoreException coreException) {
            }
            catch (NumberFormatException numberFormatException) {}
            if (function != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), "Function name: ", function));
            }
            this.setTitle("C/C++ Function Breakpoint Properties");
        } else if (breakpoint instanceof ICAddressBreakpoint) {
            ICAddressBreakpoint abrkpt = (ICAddressBreakpoint)breakpoint;
            String address = "Not available";
            try {
                address = CDebugUtils.toHexAddressString((long)Long.parseLong(abrkpt.getAddress()));
            }
            catch (CoreException coreException) {
            }
            catch (NumberFormatException numberFormatException) {}
            if (address != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), "Address: ", address));
            }
            this.setTitle("C/C++ Address Breakpoint Properties");
        } else if (breakpoint instanceof ILineBreakpoint) {
            String fileName = breakpoint.getMarker().getResource().getLocation().toOSString();
            if (fileName != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), "File: ", fileName));
            }
            this.setTitle("C/C++ Line Breakpoint Properties");
            ILineBreakpoint lBreakpoint = (ILineBreakpoint)breakpoint;
            StringBuffer lineNumber = new StringBuffer(4);
            try {
                int lNumber = lBreakpoint.getLineNumber();
                if (lNumber > 0) {
                    lineNumber.append(lNumber);
                }
            }
            catch (CoreException ce) {
                CDebugUIPlugin.log(ce);
            }
            if (lineNumber.length() > 0) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), "Line Number: ", lineNumber.toString()));
            }
        } else if (breakpoint instanceof ICWatchpoint) {
            String projectName = breakpoint.getMarker().getResource().getLocation().toOSString();
            if (projectName != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), "Project: ", projectName));
            }
            ICWatchpoint watchpoint = (ICWatchpoint)breakpoint;
            String title = "";
            String expression = "";
            try {
                title = watchpoint.isReadType() && !watchpoint.isWriteType() ? "C/C++ Read Watchpoint Properties" : (!watchpoint.isReadType() && watchpoint.isWriteType() ? "C/C++ Watchpoint Properties" : "C/C++ Access Watchpoint Properties");
                expression = watchpoint.getExpression();
            }
            catch (CoreException ce) {
                CDebugUIPlugin.log(ce);
            }
            this.setTitle(title);
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), "Expression To Watch: ", expression));
        }
    }

    protected void createConditionEditor(Composite parent) {
        this.fCondition = new BreakpointStringFieldEditor("CONDITION", "&Condition", parent);
        this.fConditionTextControl = this.fCondition.getTextControl(parent);
        this.fCondition.setEmptyStringAllowed(true);
        this.fCondition.setErrorMessage("Invalid_condition");
        this.addField((FieldEditor)this.fCondition);
    }

    protected void createIgnoreCountEditor(Composite parent) {
        this.fIgnoreCount = new BreakpointIntegerFieldEditor("IGNORE_COUNT", "&Ignore Count: ", parent);
        this.fIgnoreCount.setValidRange(0, Integer.MAX_VALUE);
        this.fIgnoreCountTextControl = this.fIgnoreCount.getTextControl(parent);
        try {
            this.fIgnoreCountTextControl.setEnabled(this.getBreakpoint().getIgnoreCount() >= 0);
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
        this.addField((FieldEditor)this.fIgnoreCount);
    }

    protected FieldEditor createLabelEditor(Composite parent, String title, String value) {
        return new LabelFieldEditor(parent, title, value);
    }

    protected ICBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(ICBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
    }

    class BreakpointIntegerFieldEditor
    extends IntegerFieldEditor {
        public BreakpointIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setErrorMessage("Ignore count must be a positive integer");
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void clearErrorMessage() {
            if (this.getPreferencePage() != null) {
                String message = this.getPreferencePage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class BreakpointStringFieldEditor
    extends StringFieldEditor {
        public BreakpointStringFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (this.getPreferencePage() != null) {
                String message = this.getPreferencePage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class LabelFieldEditor
    extends FieldEditor {
        private Label fTitleLabel;
        private Label fValueLabel;
        private Composite fBasicComposite;
        private String fValue;
        private String fTitle;

        public LabelFieldEditor(Composite parent, String title, String value) {
            this.fValue = value;
            this.fTitle = title;
            this.createControl(parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.fBasicComposite.getLayoutData()).horizontalSpan = numColumns;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.fBasicComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = 2;
            this.fBasicComposite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.horizontalAlignment = 4;
            this.fBasicComposite.setLayoutData((Object)data);
            this.fTitleLabel = new Label(this.fBasicComposite, 0);
            this.fTitleLabel.setText(this.fTitle);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            this.fTitleLabel.setLayoutData((Object)gd);
            this.fValueLabel = new Label(this.fBasicComposite, 64);
            this.fValueLabel.setText(this.fValue);
            gd = new GridData();
            this.fValueLabel.setLayoutData((Object)gd);
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }
}

