/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValueModification;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class ChangeRegisterValueAction
extends SelectionProviderAction {
    protected Tree fTree;
    protected TreeEditor fTreeEditor;
    protected Composite fComposite;
    protected Label fEditorLabel;
    protected Text fEditorText;
    protected IVariable fVariable;
    protected boolean fKeyReleased = false;

    public ChangeRegisterValueAction(Viewer viewer) {
        super((ISelectionProvider)viewer, "Change Register Value");
        this.setDescription("Change Register Value");
        CDebugImages.setLocalImageDescriptors((IAction)this, "org.eclipse.cdt.debug.ui.change_reg_value_co.gif");
        this.fTree = ((TreeViewer)viewer).getTree();
        this.fTreeEditor = new TreeEditor(this.fTree);
        WorkbenchHelp.setHelp((IAction)this, (String)ICDebugHelpContextIds.CHANGE_REGISTER_VALUE_ACTION);
    }

    protected void doActionPerformed(IVariable variable) {
        IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        final Shell activeShell = window.getShell();
        if (this.fEditorText != null) {
            this.saveChangesAndCleanup(this.fVariable, activeShell);
        }
        this.fVariable = variable;
        this.fComposite = new Composite((Composite)this.fTree, 0);
        this.fComposite.setBackground(this.fTree.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fComposite.setLayout((Layout)layout);
        this.fEditorLabel = new Label(this.fComposite, 16384);
        this.fEditorLabel.setLayoutData((Object)new GridData(1040));
        int textStyles = 16388;
        if (SWT.getPlatform().equals("win32")) {
            textStyles |= 0x800;
        }
        this.fEditorText = new Text(this.fComposite, textStyles);
        this.fEditorText.setLayoutData((Object)new GridData(1808));
        String valueString = "";
        try {
            valueString = this.fVariable.getValue().getValueString();
        }
        catch (DebugException de) {
            CDebugUIPlugin.errorDialog("Setting the register value failed.", de);
        }
        TreeItem[] selectedItems = this.fTree.getSelection();
        this.fTreeEditor.horizontalAlignment = 16384;
        this.fTreeEditor.grabHorizontal = true;
        this.fTreeEditor.setEditor((Control)this.fComposite, selectedItems[0]);
        String varName = "";
        try {
            varName = this.fVariable.getName();
        }
        catch (DebugException de) {
            CDebugUIPlugin.errorDialog("Setting the register value failed.", de);
        }
        this.fEditorLabel.setText(String.valueOf(varName) + "=");
        this.fEditorText.setText(valueString);
        this.fEditorText.selectAll();
        this.fComposite.layout(true);
        this.fComposite.setVisible(true);
        this.fEditorText.setFocus();
        this.fEditorText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r') {
                    if (ChangeRegisterValueAction.this.fKeyReleased) {
                        ChangeRegisterValueAction.this.saveChangesAndCleanup(ChangeRegisterValueAction.this.fVariable, activeShell);
                    } else {
                        ChangeRegisterValueAction.this.cleanup();
                        return;
                    }
                }
                if (event.character == '\u001b') {
                    ChangeRegisterValueAction.this.cleanup();
                    return;
                }
                ChangeRegisterValueAction.this.fKeyReleased = true;
            }
        });
        this.fEditorText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                if (ChangeRegisterValueAction.this.fKeyReleased) {
                    ChangeRegisterValueAction.this.saveChangesAndCleanup(ChangeRegisterValueAction.this.fVariable, activeShell);
                } else {
                    ChangeRegisterValueAction.this.cleanup();
                }
            }
        });
    }

    protected void saveChangesAndCleanup(IVariable variable, Shell shell) {
        String newValue = this.fEditorText.getText();
        try {
            if (!variable.verifyValue(newValue)) {
                shell.getDisplay().beep();
                return;
            }
            variable.setValue(newValue);
        }
        catch (DebugException de) {
            CDebugUIPlugin.errorDialog("Setting the register value failed.", de);
        }
        this.cleanup();
    }

    protected void cleanup() {
        this.fKeyReleased = false;
        if (this.fEditorText != null) {
            this.fEditorText.dispose();
            this.fEditorText = null;
            this.fVariable = null;
            this.fTreeEditor.setEditor(null, null);
            this.fComposite.setVisible(false);
        }
    }

    protected void update(IStructuredSelection sel) {
        Object object;
        Iterator iter = sel.iterator();
        if (iter.hasNext() && (object = iter.next()) instanceof IValueModification) {
            IValueModification varMod = (IValueModification)object;
            if (!varMod.supportsValueModification()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(!iter.hasNext());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        Iterator iterator = this.getStructuredSelection().iterator();
        this.doActionPerformed((IVariable)iterator.next());
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.update(sel);
    }
}

