/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.AbstractBreakpointRulerAction;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class EnableDisableBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    public EnableDisableBreakpointRulerAction(ITextEditor editor, IVerticalRulerInfo info) {
        this.setInfo(info);
        this.setTextEditor(editor);
        this.setText("&Enable Breakpoint");
    }

    public void run() {
        if (this.getBreakpoint() != null) {
            try {
                this.getBreakpoint().setEnabled(!this.getBreakpoint().isEnabled());
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getTextEditor().getEditorSite().getShell(), (String)"Enabling/disabling breakpoints", (String)"Exceptions occurred enabling disabling the breakpoint", (IStatus)e.getStatus());
            }
        }
    }

    public void update() {
        this.setBreakpoint(this.determineBreakpoint());
        if (this.getBreakpoint() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        try {
            boolean enabled = this.getBreakpoint().isEnabled();
            this.setText(enabled ? "&Disable Breakpoint" : "&Enable Breakpoint");
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
    }
}

