/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.registers;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.ICRegisterManager;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.actions.AutoRefreshAction;
import org.eclipse.cdt.debug.internal.ui.actions.ChangeRegisterValueAction;
import org.eclipse.cdt.debug.internal.ui.actions.RefreshAction;
import org.eclipse.cdt.debug.internal.ui.actions.ShowRegisterTypesAction;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.ViewerState;
import org.eclipse.cdt.debug.internal.ui.views.registers.RegistersViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.registers.RegistersViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.registers.RegistersViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class RegistersView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    private IDebugModelPresentation fModelPresentation;
    protected static final String VARIABLES_SELECT_ALL_ACTION = "selectAll.Registers";
    private HashMap fExpandedRegisters = new HashMap(10);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Viewer createViewer(Composite parent) {
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        RegistersViewer vv = new RegistersViewer(parent, 770);
        vv.setContentProvider(this.createContentProvider());
        vv.setLabelProvider((IBaseLabelProvider)new VariablesViewLabelProvider(this.getModelPresentation()));
        vv.setUseHashlookup(true);
        this.setAction("selectAll", this.getAction(VARIABLES_SELECT_ALL_ACTION));
        this.getViewSite().getActionBars().updateActionBars();
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler((Viewer)vv));
        return vv;
    }

    protected void createActions() {
        Object action = new ShowRegisterTypesAction((IDebugView)this);
        this.setAction("ShowTypeNames", (IAction)action);
        action = new ChangeRegisterValueAction(this.getViewer());
        action.setEnabled(false);
        this.setAction("ChangeRegisterValue", (IAction)action);
        this.setAction("Double_Click_ActionId", (IAction)action);
        action = new AutoRefreshAction(this.getViewer(), "Auto-Refresh");
        CDebugImages.setLocalImageDescriptors((IAction)action, "org.eclipse.cdt.debug.ui.autorefresh_mem.gif");
        action.setDescription("Automatically Refresh Registers View");
        action.setToolTipText("Auto-Refresh");
        WorkbenchHelp.setHelp((IAction)action, (String)ICDebugHelpContextIds.AUTO_REFRESH_REGISTERS_ACTION);
        action.setEnabled(false);
        this.setAction("AutoRefresh", (IAction)action);
        this.add((AutoRefreshAction)((Object)action));
        action = new RefreshAction(this.getViewer(), "Refresh");
        CDebugImages.setLocalImageDescriptors((IAction)action, "org.eclipse.cdt.debug.ui.refresh_mem.gif");
        action.setDescription("Refresh Registers View");
        action.setToolTipText("Refresh");
        WorkbenchHelp.setHelp((IAction)action, (String)ICDebugHelpContextIds.REFRESH_REGISTERS_ACTION);
        action.setEnabled(false);
        this.setAction("Refresh", (IAction)action);
        this.add((RefreshAction)((Object)action));
        this.setInitialContent();
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.REGISTERS_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyRegisterGroup"));
        menu.add((IContributionItem)new Separator("registerGroup"));
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("emptyRefreshGroup"));
        menu.add((IContributionItem)new Separator("refreshGroup"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.appendToGroup("registerGroup", this.getAction("ChangeRegisterValue"));
        menu.appendToGroup("refreshGroup", this.getAction("AutoRefresh"));
        menu.appendToGroup("refreshGroup", this.getAction("Refresh"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator(this.getClass().getName()));
        tbm.add((IContributionItem)new Separator("refreshGroup"));
        tbm.add(this.getAction("AutoRefresh"));
        tbm.add(this.getAction("Refresh"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        tbm.add(this.getAction("ShowTypeNames"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("Changed.Register.RGB")) {
            this.getEventHandler().refresh();
        }
    }

    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    public void dispose() {
        this.fModelPresentation.dispose();
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected IContentProvider createContentProvider() {
        RegistersViewContentProvider cp = new RegistersViewContentProvider();
        cp.setExceptionHandler(this);
        return cp;
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = DebugUITools.newDebugModelPresentation();
        }
        return this.fModelPresentation;
    }

    protected AbstractDebugEventHandler createEventHandler(Viewer viewer) {
        return new RegistersViewEventHandler(this);
    }

    protected void setViewerInput(IStructuredSelection ssel) {
        ViewerState state;
        ICRegisterManager rm = null;
        if (ssel.size() == 1 && ssel.getFirstElement() instanceof IStackFrame) {
            IDebugTarget iDebugTarget = ((IStackFrame)ssel.getFirstElement()).getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICRegisterManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rm = (ICRegisterManager)iDebugTarget.getAdapter((Class)clazz);
        }
        if (this.getViewer() == null) {
            return;
        }
        Object current = this.getViewer().getInput();
        if (current == null && rm == null) {
            return;
        }
        if (current != null && current.equals(rm)) {
            return;
        }
        if (current != null) {
            state = new ViewerState(this.getRegistersViewer());
            this.fExpandedRegisters.put(current, state);
        }
        this.showViewer();
        this.getViewer().setInput((Object)rm);
        if (rm != null && (state = (ViewerState)this.fExpandedRegisters.get(rm)) != null) {
            state.restoreState(this.getRegistersViewer());
        }
        this.updateObjects();
    }

    protected void setInitialContent() {
        ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }

    protected RegistersViewer getRegistersViewer() {
        return (RegistersViewer)this.getViewer();
    }

    protected void clearExpandedRegisters(ICRegisterManager rm) {
        this.fExpandedRegisters.remove(rm);
    }

    public Object getAdapter(Class adapter) {
        IBaseLabelProvider labelProvider;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.debug.ui.IDebugModelPresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter) && (labelProvider = this.getStructuredViewer().getLabelProvider()) instanceof VariablesViewLabelProvider) {
            return ((VariablesViewLabelProvider)labelProvider).getPresentation();
        }
        return super.getAdapter(adapter);
    }

    class VariablesViewLabelProvider
    implements ILabelProvider,
    IColorProvider {
        private IDebugModelPresentation fPresentation;

        public VariablesViewLabelProvider(IDebugModelPresentation presentation) {
            this.fPresentation = presentation;
        }

        public IDebugModelPresentation getPresentation() {
            return this.fPresentation;
        }

        public Image getImage(Object element) {
            return this.fPresentation.getImage(element);
        }

        public String getText(Object element) {
            return this.fPresentation.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.fPresentation.addListener(listener);
        }

        public void dispose() {
            this.fPresentation.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.fPresentation.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.fPresentation.removeListener(listener);
        }

        public Color getForeground(Object element) {
            if (element instanceof IRegister) {
                IRegister register = (IRegister)element;
                try {
                    if (register.hasValueChanged()) {
                        return CDebugUIPlugin.getPreferenceColor("Changed.Register.RGB");
                    }
                }
                catch (DebugException e) {
                    CDebugUIPlugin.log(e);
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

