/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.registers;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.ICRegisterManager;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RegistersViewContentProvider
implements ITreeContentProvider {
    private HashMap fParentCache = new HashMap(10);
    private IDebugExceptionHandler fExceptionHandler = null;

    public Object[] getChildren(Object parent) {
        Object[] children = null;
        try {
            if (parent instanceof ICRegisterManager) {
                children = ((ICRegisterManager)parent).getRegisterGroups();
            } else if (parent instanceof IRegisterGroup) {
                children = ((IRegisterGroup)parent).getRegisters();
            } else if (parent instanceof IVariable) {
                children = ((IVariable)parent).getValue().getVariables();
            }
            if (children != null) {
                this.cache(parent, children);
                return children;
            }
        }
        catch (DebugException e) {
            if (this.getExceptionHandler() != null) {
                this.getExceptionHandler().handleException(e);
            }
            CDebugUIPlugin.log(e);
        }
        return new Object[0];
    }

    protected void cache(Object parent, Object[] children) {
        int i = 0;
        while (i < children.length) {
            this.fParentCache.put(children[i], parent);
            ++i;
        }
    }

    public Object getParent(Object element) {
        return this.fParentCache.get(element);
    }

    public boolean hasChildren(Object element) {
        try {
            if (element instanceof IVariable) {
                return ((IVariable)element).getValue().hasVariables();
            }
            if (element instanceof IValue) {
                return ((IValue)element).hasVariables();
            }
            if (element instanceof IRegisterGroup) {
                return ((IRegisterGroup)element).hasRegisters();
            }
            if (element instanceof IStackFrame) {
                return ((IStackFrame)element).hasRegisterGroups();
            }
        }
        catch (DebugException e) {
            CDebugUIPlugin.log(e);
            return false;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.fParentCache = null;
        this.setExceptionHandler(null);
    }

    protected void clearCache() {
        if (this.fParentCache != null) {
            this.fParentCache.clear();
        }
    }

    public void removeCache(Object[] children) {
        if (this.fParentCache != null) {
            int i = 0;
            while (i < children.length) {
                this.fParentCache.remove(children[i]);
                ++i;
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clearCache();
    }

    protected void setExceptionHandler(IDebugExceptionHandler handler) {
        this.fExceptionHandler = handler;
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }
}

