/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.ui.ICCompletionContributor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;

public class CCompletionContributorManager {
    private static List fCompletionContributors;
    static boolean fContributorsLoaded;
    public static final String CONTRIBUTION_EXTENSION = "CCompletionContributor";
    private static CCompletionContributorManager fInstance;

    static {
        fContributorsLoaded = false;
    }

    private CCompletionContributorManager() {
    }

    public static CCompletionContributorManager getDefault() {
        if (fInstance == null) {
            fInstance = new CCompletionContributorManager();
        }
        return fInstance;
    }

    public IFunctionSummary getFunctionInfo(String name) {
        if (!fContributorsLoaded) {
            this.loadExtensions();
        }
        int i = 0;
        while (i < fCompletionContributors.size()) {
            ICCompletionContributor c = (ICCompletionContributor)fCompletionContributors.get(i);
            IFunctionSummary f = c.getFunctionInfo(name);
            if (f != null) {
                return f;
            }
            ++i;
        }
        return null;
    }

    public IFunctionSummary[] getMatchingFunctions(String frag) {
        if (!fContributorsLoaded) {
            this.loadExtensions();
        }
        IFunctionSummary[] fs = null;
        int i = 0;
        while (i < fCompletionContributors.size()) {
            ICCompletionContributor c = (ICCompletionContributor)fCompletionContributors.get(i);
            IFunctionSummary[] f = c.getMatchingFunctions(frag);
            if (f != null) {
                if (fs != null) {
                    int length = f.length + fs.length;
                    IFunctionSummary[] ft = new IFunctionSummary[length];
                    int j = 0;
                    while (j < fs.length) {
                        ft[j] = fs[j];
                        ++j;
                    }
                    j = 0;
                    while (j < f.length) {
                        ft[j + fs.length] = f[j];
                        ++j;
                    }
                    fs = ft;
                } else {
                    fs = f;
                }
            }
            ++i;
        }
        return fs;
    }

    private void loadExtensions() {
        fContributorsLoaded = true;
        fCompletionContributors = new ArrayList(2);
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.cdt.ui", CONTRIBUTION_EXTENSION);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getName().equals("provider")) {
                    try {
                        final ICCompletionContributor c = (ICCompletionContributor)elements[i].createExecutableExtension("class");
                        ISafeRunnable runnable = new ISafeRunnable(){

                            public void run() throws Exception {
                                c.initialize();
                                fCompletionContributors.add(c);
                            }

                            public void handleException(Throwable exception) {
                            }
                        };
                        Platform.run((ISafeRunnable)runnable);
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
    }
}

