/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.IWizardTab;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.cdt.utils.ui.swt.IValidation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ReferenceBlock
implements IWizardTab {
    private static final String PREFIX = "ReferenceBlock";
    private static final String LABEL = "ReferenceBlock.label";
    private static final String DESC = "ReferenceBlock.desc";
    private CheckboxTableViewer referenceProjectsViewer;
    private static final int PROJECT_LIST_MULTIPLIER = 15;
    IProject project;
    IValidation page;

    public Composite getControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 16384);
        label.setText(CUIPlugin.getResourceString(DESC));
        GridData lbldata = new GridData(768);
        lbldata.horizontalSpan = 1;
        label.setLayoutData((Object)lbldata);
        this.referenceProjectsViewer = ControlFactory.createListViewer(composite, null, -1, -1, 1808);
        this.referenceProjectsViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.referenceProjectsViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.referenceProjectsViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.initializeValues();
        return composite;
    }

    public Image getImage() {
        return CPluginImages.get("org.eclipse.cdt.ui.prj_obj.gif");
    }

    public String getLabel() {
        return CUIPlugin.getResourceString(LABEL);
    }

    protected IStructuredContentProvider getContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (!(element instanceof IWorkspace)) {
                    return new Object[0];
                }
                ArrayList<IProject> aList = new ArrayList<IProject>(15);
                IProject[] projects = ((IWorkspace)element).getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (CoreModel.getDefault().hasCNature(projects[i]) && (ReferenceBlock.this.project == null || !ReferenceBlock.this.project.equals((Object)projects[i]))) {
                        aList.add(projects[i]);
                    }
                    ++i;
                }
                return aList.toArray();
            }
        };
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    protected void initializeValues() {
        if (this.project != null) {
            try {
                Object[] referenced = this.project.getReferencedProjects();
                this.referenceProjectsViewer.setCheckedElements(referenced);
            }
            catch (CoreException coreException) {}
        }
    }

    public IProject[] getReferencedProjects() {
        Object[] elements = this.referenceProjectsViewer.getCheckedElements();
        IProject[] projects = new IProject[elements.length];
        System.arraycopy(elements, 0, projects, 0, elements.length);
        return projects;
    }

    public boolean isValid() {
        return true;
    }

    public void setVisible(boolean visible) {
    }

    public void doRun(IProject project, IProgressMonitor monitor) {
        IProject[] refProjects = this.getReferencedProjects();
        if (refProjects != null) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Reference Projects", 1);
            try {
                IProjectDescription description = project.getDescription();
                description.setReferencedProjects(refProjects);
                project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    public ReferenceBlock(IValidation page) {
        this(page, null);
    }

    public ReferenceBlock(IValidation page, IProject project) {
        this.page = page;
        this.project = project;
    }
}

