/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.resources.IStandardBuildInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BuildInfoFactory {
    public static final String LOCATION = "buildLocation";
    public static final String FULL_ARGUMENTS = "buildFullArguments";
    public static final String INCREMENTAL_ARGUMENTS = "buildIncrementalArguments";
    public static final String STOP_ON_ERROR = "stopOnError";
    public static final String DEFAULT_BUILD_CMD = "useDefaultBuildCmd";
    public static final String PROJECT_NAME = "projectName";
    public static final String INCLUDE_PATH = "includePath";
    public static final String PATH = "path";
    public static final String DEFINED_SYMBOL = "definedSymbol";
    public static final String SYMBOL = "symbol";

    public static IStandardBuildInfo create() {
        return new Preference();
    }

    public static IStandardBuildInfo create(IProject project) {
        return new Property((IResource)project);
    }

    public static IStandardBuildInfo create(IProject project, Element element) {
        Property buildProperties = new Property((IResource)project);
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals(INCLUDE_PATH)) {
                buildProperties.getPathList().add(((Element)child).getAttribute(PATH));
            } else if (child.getNodeName().equals(DEFINED_SYMBOL)) {
                buildProperties.getSymbolList().add(((Element)child).getAttribute(SYMBOL));
            }
            child = child.getNextSibling();
        }
        return buildProperties;
    }

    public static abstract class Store
    implements IStandardBuildInfo,
    IScannerInfo {
        protected List pathList;
        protected List symbolList;

        public String getBuildLocation() {
            if (this.isDefaultBuildCmd()) {
                IExtensionPoint extension;
                CCorePlugin plugin = CCorePlugin.getDefault();
                if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("CBuildCommand")) != null) {
                    IExtension[] extensions = extension.getExtensions();
                    int i = 0;
                    while (i < extensions.length) {
                        IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                        int j = 0;
                        while (j < configElements.length) {
                            String command = configElements[j].getAttribute("command");
                            if (command != null) {
                                return command;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                return "make";
            }
            return this.getString(BuildInfoFactory.LOCATION);
        }

        public Map getDefinedSymbols() {
            HashMap<String, String> symbols = new HashMap<String, String>();
            String[] symbolList = this.getPreprocessorSymbols();
            int i = 0;
            while (i < symbolList.length) {
                String symbol = symbolList[i];
                if (symbol.length() != 0) {
                    String key = new String();
                    String value = new String();
                    int index = symbol.indexOf("=");
                    if (index != -1) {
                        key = symbol.substring(0, index).trim();
                        value = symbol.substring(index + 1).trim();
                    } else {
                        key = symbol.trim();
                    }
                    symbols.put(key, value);
                }
                ++i;
            }
            return symbols;
        }

        public String getFullBuildArguments() {
            return this.getString(BuildInfoFactory.FULL_ARGUMENTS);
        }

        public String[] getIncludePaths() {
            return this.getPathList().toArray(new String[this.getPathList().size()]);
        }

        public String getIncrementalBuildArguments() {
            return this.getString(BuildInfoFactory.INCREMENTAL_ARGUMENTS);
        }

        public boolean isStopOnError() {
            return this.getBoolean(BuildInfoFactory.STOP_ON_ERROR);
        }

        public void setBuildLocation(String location) {
            this.putValue(BuildInfoFactory.LOCATION, location);
        }

        public void setPreprocessorSymbols(String[] symbols) {
            this.getSymbolList().clear();
            this.getSymbolList().addAll(Arrays.asList(symbols));
        }

        public void setFullBuildArguments(String arguments) {
            this.putValue(BuildInfoFactory.FULL_ARGUMENTS, arguments);
        }

        public void setIncludePaths(String[] paths) {
            this.getPathList().clear();
            this.getPathList().addAll(Arrays.asList(paths));
        }

        public void setIncrementalBuildArguments(String arguments) {
            this.putValue(BuildInfoFactory.INCREMENTAL_ARGUMENTS, arguments);
        }

        public void setStopOnError(boolean on) {
            this.putValue(BuildInfoFactory.STOP_ON_ERROR, new Boolean(on).toString());
        }

        public boolean isDefaultBuildCmd() {
            if (this.getString(BuildInfoFactory.DEFAULT_BUILD_CMD) == null) {
                return true;
            }
            return this.getBoolean(BuildInfoFactory.DEFAULT_BUILD_CMD);
        }

        public void setUseDefaultBuildCmd(boolean on) {
            this.putValue(BuildInfoFactory.DEFAULT_BUILD_CMD, new Boolean(on).toString());
        }

        public boolean getBoolean(String property) {
            return Boolean.valueOf(this.getString(property));
        }

        public void putValue(String name, String value) {
        }

        public void serialize(Document doc, Element rootElement) {
            ListIterator iter = this.getPathList().listIterator();
            while (iter.hasNext()) {
                Element pathElement = doc.createElement(BuildInfoFactory.INCLUDE_PATH);
                pathElement.setAttribute(BuildInfoFactory.PATH, (String)iter.next());
                rootElement.appendChild(pathElement);
            }
            iter = this.getSymbolList().listIterator();
            while (iter.hasNext()) {
                Element symbolElement = doc.createElement(BuildInfoFactory.DEFINED_SYMBOL);
                symbolElement.setAttribute(BuildInfoFactory.SYMBOL, (String)iter.next());
                rootElement.appendChild(symbolElement);
            }
        }

        protected List getPathList() {
            if (this.pathList == null) {
                this.pathList = new ArrayList();
            }
            return this.pathList;
        }

        public String getString(String property) {
            return null;
        }

        public String[] getPreprocessorSymbols() {
            return this.getSymbolList().toArray(new String[this.getSymbolList().size()]);
        }

        protected List getSymbolList() {
            if (this.symbolList == null) {
                this.symbolList = new ArrayList();
            }
            return this.symbolList;
        }
    }

    public static class Preference
    extends Store {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();

        public void putValue(String name, String value) {
            this.prefs.setValue(name, value);
        }

        public String getString(String property) {
            return this.prefs.getString(property);
        }

        public void setDefault(String name, String def) {
            this.prefs.setDefault(name, def);
        }
    }

    public static class Property
    extends Store {
        private IResource resource;

        public Property(IResource resource) {
            this.resource = resource;
        }

        public void putValue(String name, String value) {
            QualifiedName qName = new QualifiedName("org.eclipse.cdt.core", name);
            try {
                this.resource.setPersistentProperty(qName, value);
            }
            catch (CoreException coreException) {}
        }

        public String getString(String property) {
            QualifiedName qName = new QualifiedName("org.eclipse.cdt.core", property);
            try {
                return this.resource.getPersistentProperty(qName);
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        public void setDefault(String name, String def) {
        }
    }
}

