/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.impl.Block;
import org.eclipse.cdt.internal.core.index.impl.EntryResult;
import org.eclipse.cdt.internal.core.index.impl.FileListBlock;
import org.eclipse.cdt.internal.core.index.impl.GammaCompressedIndexBlock;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexBlock;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexSummary;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.SafeRandomAccessFile;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;
import org.eclipse.cdt.internal.core.search.HashtableOfInt;
import org.eclipse.cdt.internal.core.util.LRUCache;

public class BlocksIndexInput
extends IndexInput {
    public static final int CACHE_SIZE = 16;
    protected FileListBlock currentFileListBlock;
    protected int currentFileListBlockNum;
    protected int currentIndexBlockNum;
    protected IndexBlock currentIndexBlock;
    protected IndexBlock currentIncludeIndexBlock;
    private RandomAccessFile raf;
    protected File indexFile;
    protected LRUCache blockCache;
    protected boolean opened = false;
    protected IndexSummary summary;

    public BlocksIndexInput(File inputFile) {
        this.indexFile = inputFile;
        this.blockCache = new LRUCache(16);
    }

    public void clearCache() {
        this.blockCache = new LRUCache(16);
    }

    public void close() throws IOException {
        if (this.opened) {
            this.summary = null;
            this.opened = false;
            if (this.raf != null) {
                this.raf.close();
            }
        }
    }

    public IndexedFile getCurrentFile() throws IOException {
        if (!this.hasMoreFiles()) {
            return null;
        }
        IndexedFile file = null;
        file = this.currentFileListBlock.getFile(this.filePosition);
        if (file == null) {
            this.currentFileListBlockNum = this.summary.getBlockNumForFileNum(this.filePosition);
            this.currentFileListBlock = this.getFileListBlock(this.currentFileListBlockNum);
            file = this.currentFileListBlock.getFile(this.filePosition);
        }
        return file;
    }

    protected WordEntry getEntry(char[] word) throws IOException {
        int blockNum = this.summary.getBlockNumForWord(word);
        if (blockNum == -1) {
            return null;
        }
        IndexBlock block = this.getIndexBlock(blockNum);
        return block.findExactEntry(word);
    }

    protected FileListBlock getFileListBlock(int blockNum) throws IOException {
        Integer key = new Integer(blockNum);
        Block block = (Block)this.blockCache.get(key);
        if (block != null && block instanceof FileListBlock) {
            return (FileListBlock)block;
        }
        FileListBlock fileListBlock = new FileListBlock(8192);
        fileListBlock.read(this.raf, blockNum);
        this.blockCache.put(key, fileListBlock);
        return fileListBlock;
    }

    protected IndexBlock getIndexBlock(int blockNum) throws IOException {
        Integer key = new Integer(blockNum);
        Block block = (Block)this.blockCache.get(key);
        if (block != null && block instanceof IndexBlock) {
            return (IndexBlock)block;
        }
        GammaCompressedIndexBlock indexBlock = new GammaCompressedIndexBlock(8192);
        indexBlock.read(this.raf, blockNum);
        this.blockCache.put(key, indexBlock);
        return indexBlock;
    }

    public IndexedFile getIndexedFile(int fileNum) throws IOException {
        int blockNum = this.summary.getBlockNumForFileNum(fileNum);
        if (blockNum == -1) {
            return null;
        }
        FileListBlock block = this.getFileListBlock(blockNum);
        return block.getFile(fileNum);
    }

    public IndexedFile getIndexedFile(IDocument document) throws IOException {
        this.setFirstFile();
        String name = document.getName();
        while (this.hasMoreFiles()) {
            IndexedFile file = this.getCurrentFile();
            String path = file.getPath();
            if (path.equals(name)) {
                return file;
            }
            this.moveToNextFile();
        }
        return null;
    }

    protected int[] getMatchingFileNumbers(char[] word) throws IOException {
        int blockNum = this.summary.getBlockNumForWord(word);
        if (blockNum == -1) {
            return new int[0];
        }
        IndexBlock block = this.getIndexBlock(blockNum);
        WordEntry entry = block.findExactEntry(word);
        return entry == null ? new int[]{} : entry.getRefs();
    }

    public int getNumFiles() {
        return this.summary.getNumFiles();
    }

    public int getNumWords() {
        return this.summary.getNumWords();
    }

    public int getNumIncludes() {
        return this.summary.getNumIncludes();
    }

    public Object getSource() {
        return this.indexFile;
    }

    protected void init() throws IOException {
        this.clearCache();
        this.setFirstFile();
        this.setFirstWord();
        this.setFirstInclude();
    }

    public void moveToNextFile() throws IOException {
        ++this.filePosition;
    }

    public void moveToNextWordEntry() throws IOException {
        boolean endOfBlock;
        ++this.wordPosition;
        if (!this.hasMoreWords()) {
            return;
        }
        boolean bl = endOfBlock = !this.currentIndexBlock.nextEntry(this.currentWordEntry);
        if (endOfBlock) {
            this.currentIndexBlock = this.getIndexBlock(++this.currentIndexBlockNum);
            this.currentIndexBlock.nextEntry(this.currentWordEntry);
        }
    }

    public void open() throws IOException {
        if (!this.opened) {
            this.raf = new SafeRandomAccessFile(this.indexFile, "r");
            String sig = this.raf.readUTF();
            if (!sig.equals("INDEX FILE 0.014")) {
                throw new IOException(Util.bind("exception.wrongFormat"));
            }
            int summaryBlockNum = this.raf.readInt();
            this.raf.seek((long)summaryBlockNum * 8192L);
            this.summary = new IndexSummary();
            this.summary.read(this.raf);
            this.init();
            this.opened = true;
        }
    }

    public IQueryResult[] query(String word) throws IOException {
        this.open();
        int[] fileNums = this.getMatchingFileNumbers(word.toCharArray());
        int size = fileNums.length;
        IQueryResult[] files = new IQueryResult[size];
        int i = 0;
        while (i < size) {
            files[i] = this.getIndexedFile(fileNums[i]);
            ++i;
        }
        return files;
    }

    public IEntryResult[] queryEntriesMatching(char[] pattern) throws IOException {
        this.open();
        if (pattern == null || pattern.length == 0) {
            return null;
        }
        int[] blockNums = null;
        int firstStar = CharOperation.indexOf('*', pattern);
        switch (firstStar) {
            case -1: {
                WordEntry entry = this.getEntry(pattern);
                if (entry == null) {
                    return null;
                }
                return new IEntryResult[]{new EntryResult(entry.getWord(), entry.getRefs())};
            }
            case 0: {
                blockNums = this.summary.getAllBlockNums();
                break;
            }
            default: {
                char[] prefix = CharOperation.subarray(pattern, 0, firstStar);
                blockNums = this.summary.getBlockNumsForPrefix(prefix);
            }
        }
        if (blockNums == null || blockNums.length == 0) {
            return null;
        }
        IEntryResult[] entries = new IEntryResult[5];
        int count = 0;
        int i = 0;
        int max = blockNums.length;
        while (i < max) {
            IndexBlock block = this.getIndexBlock(blockNums[i]);
            block.reset();
            boolean found = false;
            WordEntry entry = new WordEntry();
            while (block.nextEntry(entry)) {
                if (CharOperation.match(entry.getWord(), pattern, true)) {
                    if (count == entries.length) {
                        IEntryResult[] iEntryResultArray = entries;
                        entries = new IEntryResult[count * 2];
                        System.arraycopy(iEntryResultArray, 0, entries, 0, count);
                    }
                    entries[count++] = new EntryResult(entry.getWord(), entry.getRefs());
                    found = true;
                    continue;
                }
                if (found) break;
            }
            ++i;
        }
        if (count != entries.length) {
            IEntryResult[] iEntryResultArray = entries;
            entries = new IEntryResult[count];
            System.arraycopy(iEntryResultArray, 0, entries, 0, count);
        }
        return entries;
    }

    public IEntryResult[] queryEntriesPrefixedBy(char[] prefix) throws IOException {
        this.open();
        int blockLoc = this.summary.getFirstBlockLocationForPrefix(prefix);
        if (blockLoc < 0) {
            return null;
        }
        IEntryResult[] entries = new IEntryResult[5];
        int count = 0;
        while (blockLoc >= 0) {
            IndexBlock block = this.getIndexBlock(this.summary.getBlockNum(blockLoc));
            block.reset();
            boolean found = false;
            WordEntry entry = new WordEntry();
            while (block.nextEntry(entry)) {
                if (CharOperation.prefixEquals(prefix, entry.getWord())) {
                    if (count == entries.length) {
                        IEntryResult[] iEntryResultArray = entries;
                        entries = new IEntryResult[count * 2];
                        System.arraycopy(iEntryResultArray, 0, entries, 0, count);
                    }
                    entries[count++] = new EntryResult(entry.getWord(), entry.getRefs());
                    found = true;
                    continue;
                }
                if (found) break;
            }
            blockLoc = this.summary.getNextBlockLocationForPrefix(prefix, blockLoc);
        }
        if (count == 0) {
            return null;
        }
        if (count != entries.length) {
            IEntryResult[] iEntryResultArray = entries;
            entries = new IEntryResult[count];
            System.arraycopy(iEntryResultArray, 0, entries, 0, count);
        }
        return entries;
    }

    public IQueryResult[] queryFilesReferringToPrefix(char[] prefix) throws IOException {
        this.open();
        int blockLoc = this.summary.getFirstBlockLocationForPrefix(prefix);
        if (blockLoc < 0) {
            return null;
        }
        HashtableOfInt fileMatches = new HashtableOfInt(20);
        int count = 0;
        while (blockLoc >= 0) {
            IndexBlock block = this.getIndexBlock(this.summary.getBlockNum(blockLoc));
            block.reset();
            boolean found = false;
            WordEntry entry = new WordEntry();
            while (block.nextEntry(entry)) {
                if (CharOperation.prefixEquals(prefix, entry.getWord())) {
                    int[] refs = entry.getRefs();
                    int i = 0;
                    int max = refs.length;
                    while (i < max) {
                        int ref = refs[i];
                        if (!fileMatches.containsKey(ref)) {
                            ++count;
                            fileMatches.put(ref, this.getIndexedFile(ref));
                        }
                        ++i;
                    }
                    found = true;
                    continue;
                }
                if (found) break;
            }
            blockLoc = this.summary.getNextBlockLocationForPrefix(prefix, blockLoc);
        }
        IQueryResult[] files = new IQueryResult[count];
        Object[] indexedFiles = fileMatches.valueTable;
        int i = 0;
        int index = 0;
        int max = indexedFiles.length;
        while (i < max) {
            IndexedFile indexedFile = (IndexedFile)indexedFiles[i];
            if (indexedFile != null) {
                files[index++] = indexedFile;
            }
            ++i;
        }
        return files;
    }

    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        this.open();
        ArrayList<IndexedFile> matches = new ArrayList<IndexedFile>();
        this.setFirstFile();
        while (this.hasMoreFiles()) {
            IndexedFile file = this.getCurrentFile();
            if (file.getPath().indexOf(word) != -1) {
                matches.add(file);
            }
            this.moveToNextFile();
        }
        IQueryResult[] match = new IQueryResult[matches.size()];
        matches.toArray(match);
        return match;
    }

    protected void setFirstFile() throws IOException {
        this.filePosition = 1;
        if (this.getNumFiles() > 0) {
            this.currentFileListBlockNum = this.summary.getBlockNumForFileNum(1);
            this.currentFileListBlock = this.getFileListBlock(this.currentFileListBlockNum);
        }
    }

    protected void setFirstWord() throws IOException {
        this.wordPosition = 1;
        if (this.getNumWords() > 0) {
            this.currentIndexBlockNum = this.summary.getFirstWordBlockNum();
            this.currentIndexBlock = this.getIndexBlock(this.currentIndexBlockNum);
            this.currentWordEntry = new WordEntry();
            this.currentIndexBlock.reset();
            this.currentIndexBlock.nextEntry(this.currentWordEntry);
        }
    }

    public void moveToNextIncludeEntry() throws IOException {
        boolean endOfBlock;
        ++this.includePosition;
        if (!this.hasMoreIncludes()) {
            return;
        }
        boolean bl = endOfBlock = !this.currentIncludeIndexBlock.nextEntry(this.currentIncludeEntry);
        if (endOfBlock) {
            this.currentIncludeIndexBlock = this.getIndexBlock(++this.currentIndexBlockNum);
            this.currentIncludeIndexBlock.nextEntry(this.currentWordEntry);
        }
    }

    protected void setFirstInclude() throws IOException {
        this.includePosition = 1;
        if (this.getNumIncludes() > 0) {
            this.currentIndexBlockNum = this.summary.getFirstIncludeBlockNum();
            this.currentIncludeIndexBlock = this.getIndexBlock(this.currentIndexBlockNum);
            this.currentIncludeEntry = new IncludeEntry(0);
            this.currentIncludeIndexBlock.reset();
            this.currentIncludeIndexBlock.nextEntry(this.currentIncludeEntry);
        }
    }

    public IncludeEntry[] queryIncludeEntries() {
        return null;
    }

    public IncludeEntry[] queryIncludeEntries(int fileNum) throws IOException {
        this.open();
        if (fileNum < 0) {
            return null;
        }
        int[] blockNums = null;
        blockNums = this.summary.getBlockNumsForIncludes();
        if (blockNums == null || blockNums.length == 0) {
            return null;
        }
        IncludeEntry[] entries = new IncludeEntry[5];
        int count = 0;
        int i = 0;
        int max = blockNums.length;
        while (i < max) {
            IndexBlock block = this.getIndexBlock(blockNums[i]);
            block.reset();
            IncludeEntry entry = new IncludeEntry(0);
            block1: while (block.nextEntry(entry)) {
                if (count == entries.length) {
                    IncludeEntry[] includeEntryArray = entries;
                    entries = new IncludeEntry[count * 2];
                    System.arraycopy(includeEntryArray, 0, entries, 0, count);
                }
                int j = 0;
                while (j < entry.getNumRefs()) {
                    if (entry.getRef(j) == fileNum) {
                        entries[count++] = new IncludeEntry(entry.getFile(), entry.getID());
                        continue block1;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (count == 0) {
            return null;
        }
        if (count != entries.length) {
            IncludeEntry[] includeEntryArray = entries;
            entries = new IncludeEntry[count];
            System.arraycopy(includeEntryArray, 0, entries, 0, count);
        }
        return entries;
    }
}

