/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;

public final class IncludeEntryHashedArray {
    public IncludeEntry[] elements;
    public int elementSize;
    public int threshold;

    public IncludeEntryHashedArray(int size) {
        if (size < 7) {
            size = 7;
        }
        this.elements = new IncludeEntry[2 * size + 1];
        this.elementSize = 0;
        this.threshold = size + 1;
    }

    public IncludeEntry add(IncludeEntry entry) {
        IncludeEntry current;
        int length = this.elements.length;
        char[] word = entry.getFile();
        int index = CharOperation.hashCode(word) % length;
        while ((current = this.elements[index]) != null) {
            if (CharOperation.equals(current.getFile(), word)) {
                this.elements[index] = entry;
                return this.elements[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.elements[index] = entry;
        if (++this.elementSize > this.threshold) {
            this.grow();
        }
        return entry;
    }

    public IncludeEntry[] asArray() {
        IncludeEntry[] array = new IncludeEntry[this.elementSize];
        int i = 0;
        int j = 0;
        int length = this.elements.length;
        while (i < length) {
            IncludeEntry current = this.elements[i];
            if (current != null) {
                array[j++] = current;
            }
            ++i;
        }
        return array;
    }

    public IncludeEntry get(char[] word) {
        IncludeEntry current;
        int length = this.elements.length;
        int index = CharOperation.hashCode(word) % length;
        while ((current = this.elements[index]) != null) {
            if (CharOperation.equals(current.getFile(), word)) {
                return current;
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    private void grow() {
        IncludeEntryHashedArray newArray = new IncludeEntryHashedArray(this.elementSize * 2);
        int i = 0;
        int length = this.elements.length;
        while (i < length) {
            if (this.elements[i] != null) {
                newArray.add(this.elements[i]);
            }
            ++i;
        }
        this.elements = newArray.elements;
        this.elementSize = newArray.elementSize;
        this.threshold = newArray.threshold;
    }

    public String toString() {
        String s = "";
        IncludeEntry[] entries = this.asArray();
        int i = 0;
        int length = entries.length;
        while (i < length) {
            s = String.valueOf(s) + entries[i].toString() + "\n";
            ++i;
        }
        return s;
    }
}

