/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;

public class CElementDeltaBuilder {
    ICElement cElement;
    int maxDepth = Integer.MAX_VALUE;
    Map infos;
    Map oldPositions;
    Map newPositions;
    CElementDelta delta;
    ArrayList added;
    ArrayList removed;

    public CElementDeltaBuilder(ICElement CElement2) {
        this.cElement = CElement2;
        this.initialize();
        this.recordElementInfo(CElement2, 0);
    }

    public CElementDeltaBuilder(ICElement cElement, int maxDepth) {
        this.cElement = cElement;
        this.maxDepth = maxDepth;
        this.initialize();
        this.recordElementInfo(cElement, 0);
    }

    private void added(ICElement element) {
        this.added.add(element);
        ListItem current = this.getNewPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getNewPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getNewPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    public void buildDeltas() {
        this.recordNewPositions(this.cElement, 0);
        this.findAdditions(this.cElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.cElement, 0);
        this.trimDelta(this.delta);
    }

    private void findAdditions(ICElement newElement, int depth) {
        ICElement[] children;
        CElementInfo oldInfo = this.getElementInfo(newElement);
        if (oldInfo == null && depth < this.maxDepth) {
            this.delta.added(newElement);
            this.added(newElement);
        } else {
            this.removeElementInfo(newElement);
        }
        if (depth >= this.maxDepth) {
            this.delta.changed(newElement, 1);
            return;
        }
        CElementInfo newInfo = null;
        newInfo = ((CElement)newElement).getElementInfo();
        this.findContentChange(oldInfo, newInfo, newElement);
        if (oldInfo != null && newElement instanceof IParent && (children = newInfo.getChildren()) != null) {
            int length = children.length;
            int i = 0;
            while (i < length) {
                this.findAdditions(children[i], depth + 1);
                ++i;
            }
        }
    }

    private void findChangesInPositioning(ICElement element, int depth) {
        if (depth >= this.maxDepth || this.added.contains(element) || this.removed.contains(element)) {
            return;
        }
        if (!this.isPositionedCorrectly(element)) {
            this.delta.removed(element);
            this.delta.added(element);
        }
        if (element instanceof IParent) {
            CElementInfo info = null;
            info = ((CElement)element).getElementInfo();
            ICElement[] children = info.getChildren();
            if (children != null) {
                int length = children.length;
                int i = 0;
                while (i < length) {
                    this.findChangesInPositioning(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void findContentChange(CElementInfo oldInfo, CElementInfo newInfo, ICElement newElement) {
        if (oldInfo instanceof SourceManipulationInfo && newInfo instanceof SourceManipulationInfo) {
            SourceManipulationInfo oldSourceInfo = (SourceManipulationInfo)oldInfo;
            SourceManipulationInfo newSourceInfo = (SourceManipulationInfo)newInfo;
            if (oldSourceInfo.getModifiers() != newSourceInfo.getModifiers()) {
                this.delta.changed(newElement, 2);
            }
            if (!oldSourceInfo.hasSameContentsAs(newSourceInfo)) {
                this.delta.changed(newElement, 1);
            }
        }
    }

    private void findDeletions() {
        Iterator iter = this.infos.keySet().iterator();
        while (iter.hasNext()) {
            ICElement element = (ICElement)iter.next();
            this.delta.removed(element);
            this.removed(element);
        }
    }

    private CElementInfo getElementInfo(ICElement element) {
        return (CElementInfo)this.infos.get(element);
    }

    private ListItem getNewPosition(ICElement element) {
        return (ListItem)this.newPositions.get(element);
    }

    private ListItem getOldPosition(ICElement element) {
        return (ListItem)this.oldPositions.get(element);
    }

    private void initialize() {
        this.infos = new HashMap(20);
        this.oldPositions = new HashMap(20);
        this.newPositions = new HashMap(20);
        this.putOldPosition(this.cElement, new ListItem(null, null));
        this.putNewPosition(this.cElement, new ListItem(null, null));
        this.delta = new CElementDelta(this.cElement);
        if (this.cElement.getElementType() >= 60) {
            this.delta.fineGrained();
        }
        this.added = new ArrayList(5);
        this.removed = new ArrayList(5);
    }

    private void insertPositions(ICElement[] elements, boolean isNew) {
        int length = elements.length;
        ICElement previous = null;
        ICElement current = null;
        ICElement next = length > 0 ? elements[0] : null;
        int i = 0;
        while (i < length) {
            previous = current;
            current = next;
            ICElement iCElement = next = i + 1 < length ? elements[i + 1] : null;
            if (isNew) {
                this.putNewPosition(current, new ListItem(previous, next));
            } else {
                this.putOldPosition(current, new ListItem(previous, next));
            }
            ++i;
        }
    }

    private boolean isIdentical(CElement e1, CElement e2) {
        if (e1 == null ^ e2 == null) {
            return false;
        }
        if (e1 == null) {
            return true;
        }
        return e1.isIdentical(e2);
    }

    private boolean isPositionedCorrectly(ICElement element) {
        ListItem oldListItem = this.getOldPosition(element);
        if (oldListItem == null) {
            return false;
        }
        ICElement oldPrevious = oldListItem.previous;
        ListItem newListItem = this.getNewPosition(element);
        if (newListItem == null) {
            return false;
        }
        ICElement newPrevious = newListItem.previous;
        if (oldPrevious == newPrevious) {
            return true;
        }
        ICElement lastNewPrevious = null;
        while (lastNewPrevious != newPrevious) {
            if (this.isIdentical((CElement)oldPrevious, (CElement)newPrevious)) {
                return true;
            }
            lastNewPrevious = newPrevious;
            if (newPrevious == null) break;
            newPrevious = this.getNewPosition((ICElement)newPrevious).previous;
        }
        return false;
    }

    private void putElementInfo(ICElement element, CElementInfo info) {
        this.infos.put(element, info);
    }

    private void putNewPosition(ICElement element, ListItem position) {
        this.newPositions.put(element, position);
    }

    private void putOldPosition(ICElement element, ListItem position) {
        this.oldPositions.put(element, position);
    }

    private void recordElementInfo(ICElement element, int depth) {
        ICElement[] children;
        if (depth >= this.maxDepth) {
            return;
        }
        CElementInfo info = (CElementInfo)CModelManager.getDefault().getInfo(element);
        if (info == null) {
            return;
        }
        this.putElementInfo(element, info);
        if (element instanceof IParent && (children = info.getChildren()) != null) {
            this.insertPositions(children, false);
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.recordElementInfo(children[i], depth + 1);
                ++i;
            }
        }
    }

    private void recordNewPositions(ICElement newElement, int depth) {
        if (depth < this.maxDepth && newElement instanceof IParent) {
            CElementInfo info = null;
            info = ((CElement)newElement).getElementInfo();
            ICElement[] children = info.getChildren();
            if (children != null) {
                this.insertPositions(children, true);
                int i = 0;
                int length = children.length;
                while (i < length) {
                    this.recordNewPositions(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void removed(ICElement element) {
        this.removed.add(element);
        ListItem current = this.getOldPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getOldPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getOldPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private void removeElementInfo(ICElement element) {
        this.infos.remove(element);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Built delta:\n");
        buffer.append(this.delta.toString());
        return buffer.toString();
    }

    private void trimDelta(CElementDelta delta) {
        if (delta.getKind() == 2) {
            ICElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                delta.removeAffectedChild((CElementDelta)children[i]);
                ++i;
            }
        } else {
            ICElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.trimDelta((CElementDelta)children[i]);
                ++i;
            }
        }
    }

    class ListItem {
        public ICElement previous;
        public ICElement next;

        public ListItem(ICElement previous, ICElement next) {
            this.previous = previous;
            this.next = next;
        }
    }
}

