/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.EmptyStackException;
import java.util.Stack;
import org.eclipse.cdt.core.parser.ScannerException;

public class BranchTracker {
    private static final int IGNORE_SENTINEL = -1;
    private Stack branches = new Stack();
    private int ignore = -1;
    private static final Boolean FALSE = new Boolean(false);
    private static final Boolean TRUE = new Boolean(true);

    public boolean poundif(boolean taken) {
        if (this.ignore == -1) {
            this.branches.push(new Boolean(taken));
            if (!taken) {
                this.ignore = this.branches.size();
            }
            return taken;
        }
        this.branches.push(FALSE);
        return false;
    }

    public boolean poundelif(boolean taken) throws ScannerException {
        Boolean branchAlreadyTaken;
        if (this.ignore != -1 && this.ignore < this.branches.size()) {
            this.branches.pop();
            this.branches.push(FALSE);
            return false;
        }
        try {
            branchAlreadyTaken = (Boolean)this.branches.peek();
        }
        catch (EmptyStackException emptyStackException) {
            throw new ScannerException(ScannerException.ErrorCode.UNBALANCED_CONDITIONALS);
        }
        if (this.ignore == -1) {
            if (!branchAlreadyTaken.booleanValue()) {
                this.branches.pop();
                this.branches.push(new Boolean(taken));
                if (!taken) {
                    this.ignore = this.branches.size();
                }
                return taken;
            }
            this.ignore = this.branches.size();
            return false;
        }
        if (!branchAlreadyTaken.booleanValue()) {
            this.branches.pop();
            this.branches.push(new Boolean(taken));
            if (taken) {
                this.ignore = -1;
            }
            return taken;
        }
        this.ignore = this.branches.size();
        return false;
    }

    public boolean poundelse() throws ScannerException {
        Boolean branchAlreadyTaken;
        if (this.ignore != -1 && this.ignore < this.branches.size()) {
            this.branches.pop();
            this.branches.push(FALSE);
            return false;
        }
        try {
            branchAlreadyTaken = (Boolean)this.branches.peek();
        }
        catch (EmptyStackException emptyStackException) {
            throw new ScannerException(ScannerException.ErrorCode.UNBALANCED_CONDITIONALS);
        }
        if (this.ignore == -1) {
            if (branchAlreadyTaken.booleanValue()) {
                this.ignore = this.branches.size();
                return false;
            }
            this.branches.pop();
            this.branches.push(TRUE);
            return true;
        }
        if (branchAlreadyTaken.booleanValue()) {
            this.ignore = this.branches.size();
            return false;
        }
        this.branches.pop();
        this.branches.push(TRUE);
        this.ignore = -1;
        return true;
    }

    public boolean poundendif() {
        if (this.ignore == this.branches.size()) {
            this.ignore = -1;
        }
        this.branches.pop();
        return this.ignore == -1;
    }

    public int getDepth() {
        return this.branches.size();
    }
}

