/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTConstructorMemberInitializer;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.internal.core.parser.DeclarationWrapper;
import org.eclipse.cdt.internal.core.parser.IDeclarator;
import org.eclipse.cdt.internal.core.parser.IDeclaratorOwner;
import org.eclipse.cdt.internal.core.parser.IParameterCollection;

public class Declarator
implements IParameterCollection,
IDeclaratorOwner,
IDeclarator {
    private ITokenDuple pointerOperatorNameDuple;
    private ITokenDuple namedDuple;
    private boolean isFunction;
    private boolean hasFunctionBody;
    private IASTExpression constructorExpression;
    private boolean pureVirtual = false;
    private final IDeclaratorOwner owner;
    private Declarator ownedDeclarator = null;
    private String name = "";
    private IASTInitializerClause initializerClause = null;
    private List ptrOps = new ArrayList();
    private List parameters = new ArrayList();
    private List arrayModifiers = new ArrayList();
    private List constructorMemberInitializers = new ArrayList();
    private IASTExceptionSpecification exceptionSpecification = null;
    private IASTExpression bitFieldExpression = null;
    private boolean isConst = false;
    private boolean isVolatile = false;
    private boolean isKandR = false;
    private int nameStartOffset;
    private int nameEndOffset;

    public Declarator(IDeclaratorOwner owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public int getNameStartOffset() {
        return this.nameStartOffset;
    }

    public IDeclaratorOwner getOwner() {
        return this.owner;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNameEndOffset(int i) {
        this.nameEndOffset = i;
    }

    public void setNameStartOffset(int i) {
        this.nameStartOffset = i;
    }

    public List getPointerOperators() {
        return Collections.unmodifiableList(this.ptrOps);
    }

    public void addPointerOperator(ASTPointerOperator ptrOp) {
        this.ptrOps.add(ptrOp);
    }

    public List getParameters() {
        return this.parameters;
    }

    public void addParameter(DeclarationWrapper param) {
        this.parameters.add(param);
    }

    public IASTInitializerClause getInitializerClause() {
        return this.initializerClause;
    }

    public void setInitializerClause(IASTInitializerClause expression) {
        this.initializerClause = expression;
    }

    public Declarator getOwnedDeclarator() {
        return this.ownedDeclarator;
    }

    public void setOwnedDeclarator(Declarator declarator) {
        this.ownedDeclarator = declarator;
    }

    public void setName(ITokenDuple duple) {
        this.setName(duple.toString());
        this.setNameStartOffset(duple.getFirstToken().getOffset());
        this.setNameEndOffset(duple.getLastToken().getEndOffset());
        this.namedDuple = duple;
    }

    public IASTExceptionSpecification getExceptionSpecification() {
        return this.exceptionSpecification;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setExceptionSpecification(IASTExceptionSpecification specification) {
        this.exceptionSpecification = specification;
    }

    public void setConst(boolean b) {
        this.isConst = b;
    }

    public void setVolatile(boolean b) {
        this.isVolatile = b;
    }

    public boolean isKandR() {
        return this.isKandR;
    }

    public void setKandR(boolean b) {
        this.isKandR = b;
    }

    public void setPureVirtual(boolean b) {
        this.pureVirtual = b;
    }

    public boolean isPureVirtual() {
        return this.pureVirtual;
    }

    public void addArrayModifier(IASTArrayModifier arrayMod) {
        this.arrayModifiers.add(arrayMod);
    }

    public List getArrayModifiers() {
        return this.arrayModifiers;
    }

    public IASTExpression getBitFieldExpression() {
        return this.bitFieldExpression;
    }

    public void setBitFieldExpression(IASTExpression expression) {
        this.bitFieldExpression = expression;
    }

    public void setConstructorExpression(IASTExpression astExpression) {
        this.constructorExpression = astExpression;
    }

    public IASTExpression getConstructorExpression() {
        return this.constructorExpression;
    }

    public void addConstructorMemberInitializer(IASTConstructorMemberInitializer initializer) {
        this.constructorMemberInitializers.add(initializer);
    }

    public List getConstructorMemberInitializers() {
        return this.constructorMemberInitializers;
    }

    public void hasFunctionBody(boolean b) {
        this.hasFunctionBody = b;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public void setIsFunction(boolean b) {
        this.isFunction = b;
    }

    public Iterator getDeclarators() {
        ArrayList<Declarator> l = new ArrayList<Declarator>();
        if (this.ownedDeclarator != null) {
            l.add(this.ownedDeclarator);
        }
        return l.iterator();
    }

    public DeclarationWrapper getDeclarationWrapper() {
        Declarator d = this;
        while (d.getOwner() instanceof IDeclarator) {
            d = (Declarator)d.getOwner();
        }
        return (DeclarationWrapper)d.getOwner();
    }

    public ITokenDuple getNamedDuple() {
        return this.namedDuple;
    }

    public void setPointerOperatorName(ITokenDuple nameDuple) {
        this.pointerOperatorNameDuple = nameDuple;
    }

    public ITokenDuple getPointerOperatorNameDuple() {
        return this.pointerOperatorNameDuple;
    }

    public boolean hasFunctionBody() {
        return this.hasFunctionBody;
    }

    public void setHasFunctionBody(boolean b) {
        this.hasFunctionBody = b;
    }
}

