/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.cdt.core.parser.ILineOffsetReconciler;
import org.eclipse.cdt.core.parser.IOffsetDuple;
import org.eclipse.cdt.internal.core.parser.OffsetDuple;

public class LineOffsetReconciler
implements ILineOffsetReconciler {
    private Reader ourReader;

    public LineOffsetReconciler(Reader input) {
        this.ourReader = input;
    }

    public int getLineNumberForOffset(int offset) {
        this.resetReader();
        int lineNumber = 1;
        int i = 0;
        while (i < offset) {
            int c = this.getChar();
            if (c == 10) {
                ++lineNumber;
            }
            ++i;
        }
        return lineNumber;
    }

    private int getChar() {
        int c;
        try {
            c = this.ourReader.read();
        }
        catch (IOException iOException) {
            throw new Error("Could not read");
        }
        return c;
    }

    private void resetReader() {
        try {
            this.ourReader.reset();
        }
        catch (IOException iOException) {
            throw new Error("Could not reset Reader");
        }
    }

    public IOffsetDuple getOffsetRangeForLineNumber(int LineNumber) {
        int c;
        int lineNumber = 1;
        int floor = -1;
        int ceiling = -1;
        int offset = 0;
        while (lineNumber != LineNumber) {
            c = this.getChar();
            ++offset;
            if (c != 10) continue;
            ++lineNumber;
        }
        floor = offset;
        while (lineNumber == LineNumber) {
            c = this.getChar();
            ++offset;
            if (c != 10) continue;
            ++lineNumber;
        }
        ceiling = offset;
        return new OffsetDuple(floor, ceiling);
    }
}

