/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;

public class ASTFunction
extends ASTDeclaration
implements IASTFunction {
    private boolean previouslyDeclared;
    private boolean hasFunctionBody = false;
    private final IASTQualifiedNameElement qualifiedName;
    private final IASTTemplate ownerTemplateDeclaration;
    private NamedOffsets offsets = new NamedOffsets();
    private List declarations = new ArrayList();
    private final IASTExceptionSpecification exceptionSpec;
    private final String name;
    private final List parms;
    private final IASTAbstractDeclaration returnType;
    private final boolean isInline;
    private final boolean isFriend;
    private final boolean isStatic;

    public ASTFunction(IASTScope scope, String name, int nameEndOffset, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, boolean isInline, boolean isFriend, boolean isStatic, int startOffset, int nameOffset, IASTTemplate ownerTemplate) {
        super(ownerTemplate != null ? null : scope);
        this.name = name;
        this.parms = parameters;
        this.returnType = returnType;
        this.exceptionSpec = exception;
        this.isInline = isInline;
        this.isFriend = isFriend;
        this.isStatic = isStatic;
        this.ownerTemplateDeclaration = ownerTemplate;
        if (ownerTemplate != null) {
            ownerTemplate.setOwnedDeclaration(this);
        }
        this.offsets.setStartingOffset(startOffset);
        this.offsets.setNameOffset(nameOffset);
        this.qualifiedName = new ASTQualifiedNamedElement(scope, name);
        this.setNameEndOffset(nameEndOffset);
    }

    public boolean isInline() {
        return this.isInline;
    }

    public boolean isFriend() {
        return this.isFriend;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getName() {
        return this.name;
    }

    public IASTAbstractDeclaration getReturnType() {
        return this.returnType;
    }

    public Iterator getParameters() {
        return this.parms.iterator();
    }

    public IASTExceptionSpecification getExceptionSpec() {
        return this.exceptionSpec;
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public IASTTemplate getOwnerTemplateDeclaration() {
        return this.ownerTemplateDeclaration;
    }

    public void setStartingOffset(int o) {
        this.offsets.setStartingOffset(o);
    }

    public void setEndingOffset(int o) {
        this.offsets.setEndingOffset(o);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public Iterator getDeclarations() {
        return this.declarations.iterator();
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptFunctionDeclaration(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor) {
        try {
            requestor.enterFunctionBody(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor) {
        try {
            requestor.exitFunctionBody(this);
        }
        catch (Exception exception) {}
    }

    public void setHasFunctionBody(boolean b) {
        this.hasFunctionBody = true;
    }

    public boolean hasFunctionBody() {
        return this.hasFunctionBody;
    }

    public IASTCodeScope getOwnerCodeScope() {
        return null;
    }

    public boolean previouslyDeclared() {
        return this.previouslyDeclared;
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffset(int o) {
        this.offsets.setNameEndOffset(o);
    }
}

