/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.impl.IFileDocument;
import org.eclipse.cdt.internal.core.search.SimpleLookupTable;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexAllProject
extends IndexRequest {
    IProject project;

    public IndexAllProject(IProject project, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.project = project;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexAllProject) {
            return this.project.equals((Object)((IndexAllProject)o).project);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        ReadWriteMonitor monitor;
        block24: {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                return true;
            }
            if (!this.project.isAccessible()) {
                return true;
            }
            IIndex index = this.manager.getIndex(this.indexPath, true, true);
            if (index == null) {
                return true;
            }
            monitor = this.manager.getMonitorFor(index);
            if (monitor == null) {
                return true;
            }
            try {
                try {
                    monitor.enterRead();
                    this.saveIfNecessary(index, monitor);
                    IQueryResult[] results = index.queryInDocumentNames("");
                    int max = results == null ? 0 : results.length;
                    final SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                    int i = 0;
                    while (true) {
                        block26: {
                            if (i < max) break block26;
                        }
                        indexedFileNames.put(results[i].getPath(), "DELETED");
                        ++i;
                    }
                    final long indexLastModified = max == 0 ? 0L : index.getIndexFile().lastModified();
                    IPath cProjectPath = this.project.getFullPath();
                    IWorkspaceRoot root = this.project.getWorkspace().getRoot();
                    IResource sourceFolder = root.findMember(cProjectPath);
                    if (this.isCancelled) {
                        Object var19_14 = null;
                        monitor.exitRead();
                        return false;
                    }
                    if (sourceFolder != null) {
                        final HashSet outputs = new HashSet();
                        final boolean hasOutputs = !outputs.isEmpty();
                        final char[][] patterns = null;
                        if (max == 0) {
                            sourceFolder.accept(new IResourceProxyVisitor(){

                                public boolean visit(IResourceProxy proxy) {
                                    if (IndexAllProject.this.isCancelled) {
                                        return false;
                                    }
                                    switch (proxy.getType()) {
                                        case 1: {
                                            IResource resource = proxy.requestResource();
                                            if (!(resource.getLocation() == null || patterns != null && Util.isExcluded(resource, patterns))) {
                                                String name = new IFileDocument((IFile)resource).getName();
                                                indexedFileNames.put(name, resource);
                                            }
                                        }
                                        case 2: {
                                            if (patterns != null && Util.isExcluded(proxy.requestResource(), patterns)) {
                                                return false;
                                            }
                                            if (!hasOutputs || !outputs.contains(proxy.requestFullPath())) break;
                                            return false;
                                        }
                                    }
                                    return true;
                                }
                            }, 0);
                        } else {
                            sourceFolder.accept(new IResourceProxyVisitor(){

                                public boolean visit(IResourceProxy proxy) {
                                    if (IndexAllProject.this.isCancelled) {
                                        return false;
                                    }
                                    switch (proxy.getType()) {
                                        case 1: {
                                            IResource resource = proxy.requestResource();
                                            IPath path = resource.getLocation();
                                            if (!(path == null || patterns != null && Util.isExcluded(resource, patterns))) {
                                                String name;
                                                indexedFileNames.put(name, indexedFileNames.get(name = new IFileDocument((IFile)resource).getName()) == null || indexLastModified < path.toFile().lastModified() ? resource : "OK");
                                            }
                                        }
                                        case 2: {
                                            if (patterns != null && Util.isExcluded(proxy.requestResource(), patterns)) {
                                                return false;
                                            }
                                            if (!hasOutputs || !outputs.contains(proxy.requestFullPath())) break;
                                            return false;
                                        }
                                    }
                                    return true;
                                }
                            }, 0);
                        }
                    }
                    Object[] names = indexedFileNames.keyTable;
                    Object[] values = indexedFileNames.valueTable;
                    boolean shouldSave = false;
                    int i2 = 0;
                    int length = names.length;
                    while (true) {
                        if (i2 >= length) {
                            if (shouldSave) {
                                this.manager.request(new SaveIndex(this.indexPath, this.manager));
                            }
                            break block24;
                        }
                        String name = (String)names[i2];
                        if (name != null) {
                            if (this.isCancelled) {
                                break;
                            }
                            Object value = values[i2];
                            if (value != "OK") {
                                shouldSave = true;
                                if (value == "DELETED") {
                                    this.manager.remove(name, this.indexPath);
                                } else {
                                    this.manager.addSource((IFile)value, this.indexPath);
                                }
                            }
                        }
                        ++i2;
                    }
                }
                catch (CoreException e) {
                    if (IndexManager.VERBOSE) {
                        JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                        e.printStackTrace();
                    }
                    this.manager.removeIndex(this.indexPath);
                    Object var19_16 = null;
                    monitor.exitRead();
                    return false;
                }
                catch (IOException e) {
                    if (IndexManager.VERBOSE) {
                        JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                        e.printStackTrace();
                    }
                    this.manager.removeIndex(this.indexPath);
                    Object var19_17 = null;
                    monitor.exitRead();
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                monitor.exitRead();
                throw throwable;
            }
            Object var19_15 = null;
            monitor.exitRead();
            return false;
        }
        Object var19_19 = null;
        monitor.exitRead();
        return true;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing project " + this.project.getFullPath();
    }
}

