/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.debug.mi.core.CLIProcessor;
import org.eclipse.cdt.debug.mi.core.CommandQueue;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.RxThread;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.Command;

public class TxThread
extends Thread {
    MISession session;
    CLIProcessor cli;

    public TxThread(MISession s) {
        super("MI TX Thread");
        this.session = s;
        this.cli = new CLIProcessor(this.session);
    }

    public void run() {
        try {
            OutputStream out;
            while ((out = this.session.getChannelOutputStream()) != null) {
                Object rxQueue;
                Command cmd = null;
                CommandQueue txQueue = this.session.getTxQueue();
                try {
                    cmd = txQueue.removeCommand();
                }
                catch (InterruptedException interruptedException) {}
                if (cmd == null) continue;
                RxThread rx = this.session.getRxThread();
                if (rx != null && rx.isAlive()) {
                    rxQueue = this.session.getRxQueue();
                    ((CommandQueue)rxQueue).addCommand(cmd);
                } else {
                    rxQueue = cmd;
                    synchronized (rxQueue) {
                        cmd.notifyAll();
                    }
                }
                if (cmd instanceof CLICommand) {
                    this.cli.process((CLICommand)cmd);
                }
                String str = cmd.toString();
                if (out == null) continue;
                out.write(str.getBytes());
                out.flush();
            }
        }
        catch (IOException iOException) {}
        CommandQueue txQueue = this.session.getTxQueue();
        if (txQueue != null) {
            Command[] cmds = txQueue.clearCommands();
            int i = 0;
            while (i < cmds.length) {
                Command command = cmds[i];
                synchronized (command) {
                    cmds[i].notifyAll();
                }
                ++i;
            }
        }
    }
}

