/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDICatchEvent;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDICatchpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Condition;
import org.eclipse.cdt.debug.mi.core.cdi.EventManager;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Watchpoint;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIBreakAfter;
import org.eclipse.cdt.debug.mi.core.command.MIBreakCondition;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDelete;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDisable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakEnable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakInsert;
import org.eclipse.cdt.debug.mi.core.command.MIBreakList;
import org.eclipse.cdt.debug.mi.core.command.MIBreakWatch;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.output.MIBreakInsertInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakListInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakWatchInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class BreakpointManager
extends SessionObject
implements ICDIBreakpointManager {
    List breakList = Collections.synchronizedList(new ArrayList());
    boolean allowInterrupt = true;
    boolean autoupdate = false;

    public BreakpointManager(Session session) {
        super(session);
    }

    public MIBreakpoint[] getMIBreakpoints() throws CDIException {
        Session s = (Session)this.getSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakList breakpointList = factory.createMIBreakList();
        try {
            s.getMISession().postCommand(breakpointList);
            MIBreakListInfo info = breakpointList.getMIBreakListInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            return info.getMIBreakpoints();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    boolean hasBreakpointChanged(Breakpoint point, MIBreakpoint miBreakpoint) {
        MIBreakpoint miBreak = point.getMIBreakpoint();
        return miBreak.isEnabled() != miBreakpoint.isEnabled() || !miBreak.getCondition().equals(miBreakpoint.getCondition()) || miBreak.getIgnoreCount() != miBreakpoint.getIgnoreCount();
    }

    public Breakpoint getBreakpoint(int number) {
        Breakpoint[] bkpts = this.breakList.toArray(new Breakpoint[0]);
        int i = 0;
        while (i < bkpts.length) {
            MIBreakpoint miBreak = bkpts[i].getMIBreakpoint();
            if (miBreak.getNumber() == number) {
                return bkpts[i];
            }
            ++i;
        }
        return null;
    }

    public Watchpoint getWatchpoint(int number) {
        return (Watchpoint)this.getBreakpoint(number);
    }

    boolean suspendInferior(ICDITarget target) throws CDIException {
        boolean shouldRestart = false;
        Session session = (Session)this.getSession();
        if (this.allowInterrupt) {
            if (target instanceof Target) {
                Target ctarget = (Target)target;
                if (ctarget.isRunning()) {
                    EventManager mgr = (EventManager)session.getEventManager();
                    int lastToken = ctarget.getLastExecutionToken();
                    mgr.disableEventToken(lastToken);
                    ctarget.suspend();
                    shouldRestart = true;
                    mgr.enableEventToken(lastToken);
                }
            } else if (!target.isSuspended()) {
                target.suspend();
                shouldRestart = true;
            }
        }
        return shouldRestart;
    }

    void resumeInferior(ICDITarget target, boolean shouldRestart) throws CDIException {
        if (shouldRestart) {
            target.resume();
        }
    }

    public void deleteBreakpoint(int no) {
        Breakpoint[] points = this.breakList.toArray(new Breakpoint[0]);
        int i = 0;
        while (i < points.length) {
            if (points[i].getMIBreakpoint().getNumber() == no) {
                this.breakList.remove(points[i]);
                break;
            }
            ++i;
        }
    }

    public void enableBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        int number = 0;
        if (!(breakpoint instanceof Breakpoint) || !this.breakList.contains(breakpoint)) {
            throw new CDIException("Not a CDT breakpoint");
        }
        number = ((Breakpoint)breakpoint).getMIBreakpoint().getNumber();
        boolean state = this.suspendInferior(breakpoint.getTarget());
        Session session = (Session)this.getSession();
        CommandFactory factory = session.getMISession().getCommandFactory();
        MIBreakEnable breakEnable = factory.createMIBreakEnable(new int[]{number});
        try {
            try {
                session.getMISession().postCommand(breakEnable);
                MIInfo info = breakEnable.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.resumeInferior(breakpoint.getTarget(), state);
            throw throwable;
        }
        Object var8_11 = null;
        this.resumeInferior(breakpoint.getTarget(), state);
        ((Breakpoint)breakpoint).getMIBreakpoint().setEnabled(true);
        MISession mi = session.getMISession();
        mi.fireEvent(new MIBreakpointChangedEvent(((Breakpoint)breakpoint).getMIBreakpoint().getNumber()));
    }

    public void disableBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        int number = 0;
        if (!(breakpoint instanceof Breakpoint) || !this.breakList.contains(breakpoint)) {
            throw new CDIException("Not a CDT breakpoint");
        }
        number = ((Breakpoint)breakpoint).getMIBreakpoint().getNumber();
        Session session = (Session)this.getSession();
        boolean state = this.suspendInferior(breakpoint.getTarget());
        CommandFactory factory = session.getMISession().getCommandFactory();
        MIBreakDisable breakDisable = factory.createMIBreakDisable(new int[]{number});
        try {
            try {
                session.getMISession().postCommand(breakDisable);
                MIInfo info = breakDisable.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.resumeInferior(breakpoint.getTarget(), state);
            throw throwable;
        }
        Object var8_11 = null;
        this.resumeInferior(breakpoint.getTarget(), state);
        ((Breakpoint)breakpoint).getMIBreakpoint().setEnabled(false);
        MISession mi = session.getMISession();
        mi.fireEvent(new MIBreakpointChangedEvent(((Breakpoint)breakpoint).getMIBreakpoint().getNumber()));
    }

    public void setCondition(ICDIBreakpoint breakpoint, ICDICondition condition) throws CDIException {
        int ignoreCount;
        int number = 0;
        if (!(breakpoint instanceof Breakpoint) || !this.breakList.contains(breakpoint)) {
            throw new CDIException("Not a CDT breakpoint");
        }
        number = ((Breakpoint)breakpoint).getMIBreakpoint().getNumber();
        Session session = (Session)this.getSession();
        boolean state = this.suspendInferior(breakpoint.getTarget());
        CommandFactory factory = session.getMISession().getCommandFactory();
        String exprCond = condition.getExpression();
        if (exprCond == null) {
            exprCond = "";
        }
        if ((ignoreCount = condition.getIgnoreCount()) < 0) {
            ignoreCount = 0;
        }
        try {
            try {
                MIBreakCondition breakCondition = factory.createMIBreakCondition(number, exprCond);
                session.getMISession().postCommand(breakCondition);
                MIInfo info = breakCondition.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                MIBreakAfter breakAfter = factory.createMIBreakAfter(number, ignoreCount);
                session.getMISession().postCommand(breakAfter);
                info = breakAfter.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.resumeInferior(breakpoint.getTarget(), state);
            throw throwable;
        }
        Object var12_15 = null;
        this.resumeInferior(breakpoint.getTarget(), state);
        MISession mi = session.getMISession();
        mi.fireEvent(new MIBreakpointChangedEvent(((Breakpoint)breakpoint).getMIBreakpoint().getNumber()));
    }

    public void update() throws CDIException {
        MIBreakpoint[] newMIBreakpoints = this.getMIBreakpoints();
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>(newMIBreakpoints.length);
        int i = 0;
        while (i < newMIBreakpoints.length) {
            int no = newMIBreakpoints[i].getNumber();
            Breakpoint bp = this.getBreakpoint(no);
            if (bp != null) {
                if (this.hasBreakpointChanged(bp, newMIBreakpoints[i])) {
                    bp.setMIBreakpoint(newMIBreakpoints[i]);
                    eventList.add(new MIBreakpointChangedEvent(no));
                }
            } else {
                if (newMIBreakpoints[i].isWatchpoint()) {
                    this.breakList.add(new Watchpoint(this, newMIBreakpoints[i]));
                } else {
                    this.breakList.add(new Breakpoint(this, newMIBreakpoints[i]));
                }
                eventList.add(new MIBreakpointCreatedEvent(no));
            }
            ++i;
        }
        Breakpoint[] oldBreakpoints = this.breakList.toArray(new Breakpoint[0]);
        int i2 = 0;
        while (i2 < oldBreakpoints.length) {
            boolean found = false;
            int no = oldBreakpoints[i2].getMIBreakpoint().getNumber();
            int j = 0;
            while (j < newMIBreakpoints.length) {
                if (no == newMIBreakpoints[j].getNumber()) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                eventList.add(new MIBreakpointDeletedEvent(no));
            }
            ++i2;
        }
        MISession mi = ((Session)this.getSession()).getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public void allowProgramInterruption(boolean e) {
        this.allowInterrupt = e;
    }

    public void deleteAllBreakpoints() throws CDIException {
        this.deleteBreakpoints(this.getBreakpoints());
    }

    public void deleteBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        this.deleteBreakpoints(new ICDIBreakpoint[]{breakpoint});
    }

    public void deleteBreakpoints(ICDIBreakpoint[] breakpoints) throws CDIException {
        int[] numbers = new int[breakpoints.length];
        int i = 0;
        while (i < numbers.length) {
            if (!(breakpoints[i] instanceof Breakpoint) || !this.breakList.contains(breakpoints[i])) {
                throw new CDIException("Not a CDT breakpoint");
            }
            numbers[i] = ((Breakpoint)breakpoints[i]).getMIBreakpoint().getNumber();
            ++i;
        }
        Session session = (Session)this.getSession();
        boolean state = this.suspendInferior(session.getCurrentTarget());
        CommandFactory factory = session.getMISession().getCommandFactory();
        MIBreakDelete breakDelete = factory.createMIBreakDelete(numbers);
        try {
            try {
                session.getMISession().postCommand(breakDelete);
                MIInfo info = breakDelete.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.resumeInferior(session.getCurrentTarget(), state);
            throw throwable;
        }
        Object var8_14 = null;
        this.resumeInferior(session.getCurrentTarget(), state);
        ArrayList<MIBreakpointDeletedEvent> eventList = new ArrayList<MIBreakpointDeletedEvent>(breakpoints.length);
        int i2 = 0;
        while (i2 < breakpoints.length) {
            int no = ((Breakpoint)breakpoints[i2]).getMIBreakpoint().getNumber();
            eventList.add(new MIBreakpointDeletedEvent(no));
            ++i2;
        }
        MISession mi = session.getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public ICDIBreakpoint[] getBreakpoints() throws CDIException {
        return this.breakList.toArray(new ICDIBreakpoint[0]);
    }

    public ICDICatchpoint setCatchpoint(int type, ICDICatchEvent event, String expression, ICDICondition condition) throws CDIException {
        throw new CDIException("Not Supported");
    }

    public ICDILocationBreakpoint setLocationBreakpoint(int type, ICDILocation location, ICDICondition condition, String threadId) throws CDIException {
        boolean hardware = type == 2;
        boolean temporary = type == 1;
        String exprCond = null;
        int ignoreCount = 0;
        StringBuffer line = new StringBuffer();
        if (condition != null) {
            exprCond = condition.getExpression();
            ignoreCount = condition.getIgnoreCount();
        }
        if (location != null) {
            String file = location.getFile();
            String function = location.getFunction();
            if (file != null && file.length() > 0) {
                line.append(file).append(':');
                if (function != null && function.length() > 0) {
                    line.append(function);
                } else {
                    line.append(location.getLineNumber());
                }
            } else if (function != null && function.length() > 0) {
                line.append(function);
            } else if (location.getLineNumber() != 0) {
                line.append(location.getLineNumber());
            } else {
                line.append('*').append(location.getAddress());
            }
        }
        Session session = (Session)this.getSession();
        boolean state = this.suspendInferior(session.getCurrentTarget());
        CommandFactory factory = session.getMISession().getCommandFactory();
        MIBreakInsert breakInsert = factory.createMIBreakInsert(temporary, hardware, exprCond, ignoreCount, line.toString());
        MIBreakpoint[] points = null;
        try {
            try {
                session.getMISession().postCommand(breakInsert);
                MIBreakInsertInfo info = breakInsert.getMIBreakInsertInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                points = info.getMIBreakpoints();
                if (points == null || points.length == 0) {
                    throw new CDIException("Error parsing");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            this.resumeInferior(session.getCurrentTarget(), state);
            throw throwable;
        }
        Object var16_20 = null;
        this.resumeInferior(session.getCurrentTarget(), state);
        Breakpoint bkpt = new Breakpoint(this, points[0]);
        this.breakList.add(bkpt);
        MISession mi = session.getMISession();
        mi.fireEvent(new MIBreakpointCreatedEvent(bkpt.getMIBreakpoint().getNumber()));
        return bkpt;
    }

    public ICDIWatchpoint setWatchpoint(int type, int watchType, String expression, ICDICondition condition) throws CDIException {
        boolean access = (watchType & 1) == 1 && (watchType & 2) == 2;
        boolean read = (watchType & 1) != 1 && (watchType & 2) == 2;
        Session session = (Session)this.getSession();
        boolean state = this.suspendInferior(session.getCurrentTarget());
        CommandFactory factory = session.getMISession().getCommandFactory();
        MIBreakWatch breakWatch = factory.createMIBreakWatch(access, read, expression);
        MIBreakpoint[] points = null;
        try {
            try {
                session.getMISession().postCommand(breakWatch);
                MIBreakWatchInfo info = breakWatch.getMIBreakWatchInfo();
                points = info.getMIBreakpoints();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                if (points == null || points.length == 0) {
                    throw new CDIException("Parsing Error");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.resumeInferior(session.getCurrentTarget(), state);
            throw throwable;
        }
        Object var13_16 = null;
        this.resumeInferior(session.getCurrentTarget(), state);
        Watchpoint bkpt = new Watchpoint(this, points[0]);
        this.breakList.add(bkpt);
        MISession mi = session.getMISession();
        mi.fireEvent(new MIBreakpointCreatedEvent(bkpt.getMIBreakpoint().getNumber()));
        return bkpt;
    }

    public ICDICondition createCondition(int ignoreCount, String expression) {
        return new Condition(ignoreCount, expression);
    }

    public ICDILocation createLocation(String file, String function, int line) {
        return new Location(file, function, line);
    }

    public ICDILocation createLocation(long address) {
        return new Location(address);
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean update) {
        this.autoupdate = update;
    }
}

