/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MILocationReachedEvent
extends MIStoppedEvent {
    public MILocationReachedEvent(MIExecAsyncOutput async) {
        super(async);
        this.parse();
    }

    public MILocationReachedEvent(MIResultRecord record) {
        super(record);
        this.parse();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("thread-id=").append(this.getThreadId()).append('\n');
        MIFrame f = this.getFrame();
        if (f != null) {
            buffer.append(f.toString());
        }
        return buffer.toString();
    }

    void parse() {
        MIResult[] results = null;
        MIExecAsyncOutput exec = this.getMIExecAsyncOutput();
        MIResultRecord rr = this.getMIResultRecord();
        if (exec != null) {
            results = exec.getMIResults();
        } else if (rr != null) {
            results = rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("thread-id")) {
                    try {
                        int id = Integer.parseInt(str.trim());
                        this.setThreadId(id);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("frame") && value instanceof MITuple) {
                    MIFrame f = new MIFrame((MITuple)value);
                    this.setFrame(f);
                }
                ++i;
            }
        }
    }
}

