/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;

public class CAddressBreakpoint
extends CBreakpoint
implements ICAddressBreakpoint {
    private static final String C_ADDRESS_BREAKPOINT = "org.eclipse.cdt.debug.core.cAddressBreakpointMarker";

    public CAddressBreakpoint() {
    }

    public CAddressBreakpoint(IResource resource, Map attributes, boolean add) throws DebugException {
        super(resource, CAddressBreakpoint.getMarkerType(), attributes, add);
    }

    public String getAddress() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.address", null);
    }

    public void setAddress(String address) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.address", address);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public static String getMarkerType() {
        return C_ADDRESS_BREAKPOINT;
    }

    protected String getMarkerMessage() throws CoreException {
        StringBuffer sb = new StringBuffer("Address breakpoint:");
        String name = this.ensureMarker().getResource().getName();
        if (name != null && name.length() > 0) {
            sb.append(' ');
            sb.append(name);
        }
        try {
            long address = Long.parseLong(this.getAddress());
            sb.append(" [address: ");
            sb.append(CDebugUtils.toHexAddressString(address));
            sb.append(']');
        }
        catch (NumberFormatException numberFormatException) {}
        sb.append(this.getConditionText());
        return sb.toString();
    }
}

