/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLocationFactory;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CProjectSourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CSourceLocator
implements ICSourceLocator,
IPersistableSourceLocator,
IResourceChangeListener {
    private static final String SOURCE_LOCATOR_NAME = "cSourceLocator";
    private static final String DISABLED_GENERIC_PROJECT_NAME = "disabledGenericProject";
    private static final String ADDITIONAL_SOURCE_LOCATION_NAME = "additionalSourceLocation";
    private static final String SOURCE_LOCATION_NAME = "cSourceLocation";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_MEMENTO = "memento";
    private static final String ATTR_PROJECT_NAME = "projectName";
    private IProject fProject = null;
    private ICSourceLocation[] fSourceLocations;
    private List fReferencedProjects = new ArrayList(10);
    static /* synthetic */ Class class$0;

    public CSourceLocator(IProject project) {
        this.setProject(project);
        this.setReferencedProjects();
        this.setSourceLocations(this.getDefaultSourceLocations());
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        if (stackFrame != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (stackFrame.getAdapter((Class)clazz) != null) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return this.getInput((IStackFrameInfo)stackFrame.getAdapter((Class)clazz2));
            }
        }
        return null;
    }

    public int getLineNumber(IStackFrame frame) {
        IStackFrameInfo info;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (info = (IStackFrameInfo)frame.getAdapter((Class)clazz)) != null ? info.getFrameLineNumber() : 0;
    }

    protected Object getInput(IStackFrameInfo info) {
        String fileName;
        Object result = null;
        if (info != null && (fileName = info.getFile()) != null && fileName.length() > 0 && (result = this.findFileByAbsolutePath(fileName)) == null) {
            ICSourceLocation[] locations = this.getSourceLocations();
            int i = 0;
            while (i < locations.length) {
                try {
                    result = locations[i].findSourceElement(fileName);
                }
                catch (CoreException coreException) {}
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public boolean contains(IResource resource) {
        ICSourceLocation[] locations = this.getSourceLocations();
        int i = 0;
        while (i < locations.length) {
            if (resource instanceof IProject && locations[i] instanceof CProjectSourceLocation && ((CProjectSourceLocation)locations[i]).getProject().equals((Object)resource)) {
                return true;
            }
            if (resource instanceof IFile) {
                try {
                    if (locations[i].findSourceElement(resource.getLocation().toOSString()) != null) {
                        return true;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return false;
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.fSourceLocations;
    }

    public void setSourceLocations(ICSourceLocation[] locations) {
        this.fSourceLocations = locations;
    }

    public static ICSourceLocation[] getDefaultSourceLocations(IProject project) {
        ArrayList<IProjectSourceLocation> list = new ArrayList<IProjectSourceLocation>();
        if (project != null && project.exists()) {
            list.add(SourceLocationFactory.createProjectSourceLocation(project));
            CSourceLocator.addReferencedSourceLocations(list, project);
        }
        return list.toArray(new ICSourceLocation[list.size()]);
    }

    private static void addReferencedSourceLocations(List list, IProject project) {
        if (project != null) {
            try {
                IProject[] projects = project.getReferencedProjects();
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].exists() && !CSourceLocator.containsProject(list, projects[i])) {
                        list.add(SourceLocationFactory.createProjectSourceLocation(projects[i]));
                        CSourceLocator.addReferencedSourceLocations(list, projects[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private static boolean containsProject(List list, IProject project) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            CProjectSourceLocation location = (CProjectSourceLocation)it.next();
            if (!project.equals((Object)location.getProject())) continue;
            return true;
        }
        return false;
    }

    private Object findFileByAbsolutePath(String fileName) {
        File file = new File(fileName);
        if (file.isAbsolute() && file.exists()) {
            try {
                Path path = new Path(file.getCanonicalPath());
                IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                if (f != null && f.exists()) {
                    return f;
                }
                return new FileStorage((IPath)path);
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public Object findSourceElement(String fileName) {
        Object result = null;
        if (fileName != null && fileName.length() > 0 && (result = this.findFileByAbsolutePath(fileName)) == null) {
            ICSourceLocation[] locations = this.getSourceLocations();
            int i = 0;
            while (i < locations.length) {
                try {
                    result = locations[i].findSourceElement(fileName);
                }
                catch (CoreException coreException) {}
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public String getMemento() throws CoreException {
        DocumentImpl doc = new DocumentImpl();
        Element node = doc.createElement(SOURCE_LOCATOR_NAME);
        doc.appendChild(node);
        ICSourceLocation[] locations = this.getSourceLocations();
        this.saveDisabledGenericSourceLocations(locations, (Document)doc, node);
        this.saveAdditionalSourceLocations(locations, (Document)doc, node);
        try {
            return CDebugUtils.serializeDocument((Document)doc, " ");
        }
        catch (IOException e) {
            this.abort("Unable to create memento for C/C++ source locator.", e);
            return null;
        }
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.setSourceLocations(this.getDefaultSourceLocations());
    }

    public void initializeFromMemento(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            if (!root.getNodeName().equalsIgnoreCase(SOURCE_LOCATOR_NAME)) {
                this.abort("Unable to restore C/C++ source locator - invalid format.", null);
            }
            ArrayList<ICSourceLocation> sourceLocations = new ArrayList<ICSourceLocation>();
            IProject project = this.getProject();
            if (project != null && project.exists() && project.isOpen()) {
                sourceLocations.addAll(Arrays.asList(this.getDefaultSourceLocations()));
            }
            this.removeDisabledLocations(root, sourceLocations);
            this.addAdditionalLocations(root, sourceLocations);
            this.addOldLocations(root, sourceLocations);
            this.setSourceLocations(sourceLocations.toArray(new ICSourceLocation[sourceLocations.size()]));
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort("Exception occurred initializing source locator.", ex);
    }

    private void removeDisabledLocations(Element root, List sourceLocations) throws CoreException {
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        HashSet<String> disabledProjects = new HashSet<String>(length);
        int i = 0;
        while (i < length) {
            Element entry;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(DISABLED_GENERIC_PROJECT_NAME)) {
                String projectName = entry.getAttribute(ATTR_PROJECT_NAME);
                if (this.isEmpty(projectName)) {
                    CDebugCorePlugin.log("Unable to restore C/C++ source locator - invalid format.");
                }
                disabledProjects.add(projectName.trim());
            }
            ++i;
        }
        Iterator it = sourceLocations.iterator();
        while (it.hasNext()) {
            ICSourceLocation location = (ICSourceLocation)it.next();
            if (!(location instanceof IProjectSourceLocation) || !disabledProjects.contains(((IProjectSourceLocation)location).getProject().getName())) continue;
            it.remove();
        }
    }

    private void addAdditionalLocations(Element root, List sourceLocations) throws CoreException {
        ClassLoader classLoader = CDebugCorePlugin.getDefault().getDescriptor().getPluginClassLoader();
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            block9: {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(ADDITIONAL_SOURCE_LOCATION_NAME)) {
                    String className = entry.getAttribute(ATTR_CLASS);
                    String data = entry.getAttribute(ATTR_MEMENTO);
                    if (this.isEmpty(className)) {
                        CDebugCorePlugin.log("Unable to restore C/C++ source locator - invalid format.");
                    } else {
                        Class<?> clazz = null;
                        try {
                            clazz = classLoader.loadClass(className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            CDebugCorePlugin.log(MessageFormat.format("Unable to restore source location - class not found {0}", className));
                            break block9;
                        }
                        ICSourceLocation location = null;
                        try {
                            location = (ICSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block9;
                        }
                        catch (InstantiationException instantiationException) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block9;
                        }
                        location.initializeFrom(data);
                        sourceLocations.add(location);
                    }
                }
            }
            ++i;
        }
    }

    private void addOldLocations(Element root, List sourceLocations) throws CoreException {
        ClassLoader classLoader = CDebugCorePlugin.getDefault().getDescriptor().getPluginClassLoader();
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            block11: {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(SOURCE_LOCATION_NAME)) {
                    String className = entry.getAttribute(ATTR_CLASS);
                    String data = entry.getAttribute(ATTR_MEMENTO);
                    if (this.isEmpty(className)) {
                        CDebugCorePlugin.log("Unable to restore C/C++ source locator - invalid format.");
                    } else {
                        Class<?> clazz = null;
                        try {
                            clazz = classLoader.loadClass(className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            CDebugCorePlugin.log(MessageFormat.format("Unable to restore source location - class not found {0}", className));
                            break block11;
                        }
                        ICSourceLocation location = null;
                        try {
                            location = (ICSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block11;
                        }
                        catch (InstantiationException instantiationException) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block11;
                        }
                        location.initializeFrom(data);
                        if (!sourceLocations.contains(location)) {
                            if (location instanceof CProjectSourceLocation) {
                                ((CProjectSourceLocation)location).setGenerated(this.isReferencedProject(((CProjectSourceLocation)location).getProject()));
                            }
                            sourceLocations.add(location);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] deltas;
        if (event.getSource() instanceof IWorkspace && event.getDelta() != null && (deltas = event.getDelta().getAffectedChildren()) != null) {
            ArrayList<IResource> list = new ArrayList<IResource>(deltas.length);
            int i = 0;
            while (i < deltas.length) {
                if (deltas[i].getResource() instanceof IProject) {
                    list.add(deltas[i].getResource());
                }
                ++i;
            }
            this.resetSourceLocations(list);
        }
    }

    private void saveDisabledGenericSourceLocations(ICSourceLocation[] locations, Document doc, Element node) {
        IProject project = this.getProject();
        if (project != null && project.exists() && project.isOpen()) {
            List list = CDebugUtils.getReferencedProjects(project);
            HashSet<String> names = new HashSet<String>(list.size() + 1);
            names.add(project.getName());
            Iterator it = list.iterator();
            while (it.hasNext()) {
                names.add(((IProject)it.next()).getName());
            }
            int i = 0;
            while (i < locations.length) {
                if (locations[i] instanceof IProjectSourceLocation && ((IProjectSourceLocation)locations[i]).isGeneric()) {
                    names.remove(((IProjectSourceLocation)locations[i]).getProject().getName());
                }
                ++i;
            }
            it = names.iterator();
            while (it.hasNext()) {
                Element child = doc.createElement(DISABLED_GENERIC_PROJECT_NAME);
                child.setAttribute(ATTR_PROJECT_NAME, (String)it.next());
                node.appendChild(child);
            }
        }
    }

    private void saveAdditionalSourceLocations(ICSourceLocation[] locations, Document doc, Element node) {
        int i = 0;
        while (i < locations.length) {
            block4: {
                if (!(locations[i] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)locations[i]).isGeneric()) {
                    Element child = doc.createElement(ADDITIONAL_SOURCE_LOCATION_NAME);
                    child.setAttribute(ATTR_CLASS, locations[i].getClass().getName());
                    try {
                        child.setAttribute(ATTR_MEMENTO, locations[i].getMemento());
                    }
                    catch (CoreException e) {
                        CDebugCorePlugin.log(e);
                        break block4;
                    }
                    node.appendChild(child);
                }
            }
            ++i;
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    protected void setProject(IProject project) {
        this.fProject = project;
    }

    private boolean isReferencedProject(IProject ref) {
        if (this.getProject() != null) {
            try {
                return Arrays.asList(this.getProject().getReferencedProjects()).contains(ref);
            }
            catch (CoreException e) {
                CDebugCorePlugin.log(e);
            }
        }
        return false;
    }

    private void setReferencedProjects() {
        this.fReferencedProjects.clear();
        this.fReferencedProjects = CDebugUtils.getReferencedProjects(this.getProject());
    }

    protected ICSourceLocation[] getDefaultSourceLocations() {
        Iterator it = this.fReferencedProjects.iterator();
        ArrayList<IProjectSourceLocation> list = new ArrayList<IProjectSourceLocation>(this.fReferencedProjects.size());
        if (this.getProject() != null && this.getProject().exists() && this.getProject().isOpen()) {
            list.add(SourceLocationFactory.createProjectSourceLocation(this.getProject()));
        }
        while (it.hasNext()) {
            IProject project = (IProject)it.next();
            if (project == null || !project.exists() || !project.isOpen()) continue;
            list.add(SourceLocationFactory.createProjectSourceLocation(project));
        }
        return list.toArray(new ICSourceLocation[list.size()]);
    }

    private void resetSourceLocations(List affectedProjects) {
        if (affectedProjects.size() != 0 && this.getProject() != null) {
            if (!this.getProject().exists() || !this.getProject().isOpen()) {
                this.removeGenericSourceLocations();
            } else {
                this.updateGenericSourceLocations(affectedProjects);
            }
        }
    }

    private void removeGenericSourceLocations() {
        this.fReferencedProjects.clear();
        ICSourceLocation[] locations = this.getSourceLocations();
        ArrayList<ICSourceLocation> newLocations = new ArrayList<ICSourceLocation>(locations.length);
        int i = 0;
        while (i < locations.length) {
            if (!(locations[i] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)locations[i]).isGeneric()) {
                newLocations.add(locations[i]);
            }
            ++i;
        }
        this.setSourceLocations(newLocations.toArray(new ICSourceLocation[newLocations.size()]));
    }

    private void updateGenericSourceLocations(List affectedProjects) {
        IProject project;
        List newRefs = CDebugUtils.getReferencedProjects(this.getProject());
        ICSourceLocation[] locations = this.getSourceLocations();
        ArrayList<ICSourceLocation> newLocations = new ArrayList<ICSourceLocation>(locations.length);
        int i = 0;
        while (i < locations.length) {
            if (!(locations[i] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)locations[i]).isGeneric()) {
                newLocations.add(locations[i]);
            } else {
                project = ((IProjectSourceLocation)locations[i]).getProject();
                if (project.exists() && project.isOpen() && (newRefs.contains(project) || project.equals((Object)this.getProject()))) {
                    newLocations.add(locations[i]);
                    newRefs.remove(project);
                }
            }
            ++i;
        }
        Iterator it = newRefs.iterator();
        while (it.hasNext()) {
            project = (IProject)it.next();
            if (this.fReferencedProjects.contains(project)) continue;
            newLocations.add(SourceLocationFactory.createProjectSourceLocation(project));
        }
        this.fReferencedProjects = newRefs;
        this.setSourceLocations(newLocations.toArray(new ICSourceLocation[newLocations.size()]));
    }
}

