/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class CDebugImages {
    private static final String NAME_PREFIX = "org.eclipse.cdt.debug.ui.";
    private static final int NAME_PREFIX_LENGTH = "org.eclipse.cdt.debug.ui.".length();
    private static URL fgIconBaseURL = null;
    private static ImageRegistry fgImageRegistry;
    private static HashMap fgAvoidSWTErrorMap;
    public static final String IMG_OVRS_BREAKPOINT_INSTALLED = "org.eclipse.cdt.debug.ui.installed_ovr.gif";
    public static final String IMG_OVRS_BREAKPOINT_INSTALLED_DISABLED = "org.eclipse.cdt.debug.ui.installed_ovr_disabled.gif";
    public static final String IMG_OVRS_BREAKPOINT_CONDITIONAL = "org.eclipse.cdt.debug.ui.conditional_ovr.gif";
    public static final String IMG_OVRS_BREAKPOINT_CONDITIONAL_DISABLED = "org.eclipse.cdt.debug.ui.conditional_ovr_disabled.gif";
    public static final String IMG_OVRS_ADDRESS_BREAKPOINT = "org.eclipse.cdt.debug.ui.address_ovr.gif";
    public static final String IMG_OVRS_ADDRESS_BREAKPOINT_DISABLED = "org.eclipse.cdt.debug.ui.address_ovr_disabled.gif";
    public static final String IMG_OVRS_FUNCTION_BREAKPOINT = "org.eclipse.cdt.debug.ui.function_ovr.gif";
    public static final String IMG_OVRS_FUNCTION_BREAKPOINT_DISABLED = "org.eclipse.cdt.debug.ui.function_ovr_disabled.gif";
    public static final String IMG_OVRS_ERROR = "org.eclipse.cdt.debug.ui.error_ovr.gif";
    public static final String IMG_OVRS_WARNING = "org.eclipse.cdt.debug.ui.warning_ovr.gif";
    public static final String IMG_OVRS_SYMBOLS = "org.eclipse.cdt.debug.ui.symbols_ovr.gif";
    public static final String IMG_OBJS_ADDRESS_BREAKPOINT_ENABLED = "org.eclipse.cdt.debug.ui.addrbrkp_obj.gif";
    public static final String IMG_OBJS_ADDRESS_BREAKPOINT_DISABLED = "org.eclipse.cdt.debug.ui.addrbrkpd_obj.gif";
    public static final String IMG_OBJS_FUNCTION_BREAKPOINT_ENABLED = "org.eclipse.cdt.debug.ui.funbrkp_obj.gif";
    public static final String IMG_OBJS_FUNCTION_BREAKPOINT_DISABLED = "org.eclipse.cdt.debug.ui.funbrkpd_obj.gif";
    public static final String IMG_OBJS_WATCHPOINT_ENABLED = "org.eclipse.cdt.debug.ui.readwrite_obj.gif";
    public static final String IMG_OBJS_WATCHPOINT_DISABLED = "org.eclipse.cdt.debug.ui.readwrite_obj_disabled.gif";
    public static final String IMG_OBJS_READ_WATCHPOINT_ENABLED = "org.eclipse.cdt.debug.ui.read_obj.gif";
    public static final String IMG_OBJS_READ_WATCHPOINT_DISABLED = "org.eclipse.cdt.debug.ui.read_obj_disabled.gif";
    public static final String IMG_OBJS_WRITE_WATCHPOINT_ENABLED = "org.eclipse.cdt.debug.ui.write_obj.gif";
    public static final String IMG_OBJS_WRITE_WATCHPOINT_DISABLED = "org.eclipse.cdt.debug.ui.write_obj_disabled.gif";
    public static final String IMG_OBJS_VARIABLE_SIMPLE = "org.eclipse.cdt.debug.ui.var_simple.gif";
    public static final String IMG_OBJS_VARIABLE_SIMPLE_DISABLED = "org.eclipse.cdt.debug.ui.vard_simple.gif";
    public static final String IMG_OBJS_VARIABLE_AGGREGATE = "org.eclipse.cdt.debug.ui.var_aggr.gif";
    public static final String IMG_OBJS_VARIABLE_AGGREGATE_DISABLED = "org.eclipse.cdt.debug.ui.vard_aggr.gif";
    public static final String IMG_OBJS_VARIABLE_POINTER = "org.eclipse.cdt.debug.ui.var_pointer.gif";
    public static final String IMG_OBJS_VARIABLE_POINTER_DISABLED = "org.eclipse.cdt.debug.ui.vard_pointer.gif";
    public static final String IMG_OBJS_VARIABLE_STRING = "org.eclipse.cdt.debug.ui.var_string.gif";
    public static final String IMG_OBJS_REGISTER_GROUP = "org.eclipse.cdt.debug.ui.registergroup_obj.gif";
    public static final String IMG_OBJS_REGISTER = "org.eclipse.cdt.debug.ui.register_obj.gif";
    public static final String IMG_OBJS_DISASSEMBLY = "org.eclipse.cdt.debug.ui.disassembly_obj.gif";
    public static final String IMG_OBJS_PROJECT = "org.eclipse.cdt.debug.ui.project_obj.gif";
    public static final String IMG_OBJS_CLOSED_PROJECT = "org.eclipse.cdt.debug.ui.cproject_obj.gif";
    public static final String IMG_OBJS_FOLDER = "org.eclipse.cdt.debug.ui.folder_obj.gif";
    public static final String IMG_OBJS_LOADED_SHARED_LIBRARY = "org.eclipse.cdt.debug.ui.library_syms_obj.gif";
    public static final String IMG_OBJS_SHARED_LIBRARY = "org.eclipse.cdt.debug.ui.library_obj.gif";
    public static final String IMG_OBJS_SIGNAL = "org.eclipse.cdt.debug.ui.signal_obj.gif";
    public static final String IMG_LCL_TYPE_NAMES = "org.eclipse.cdt.debug.ui.tnames_co.gif";
    public static final String IMG_LCL_CHANGE_REGISTER_VALUE = "org.eclipse.cdt.debug.ui.change_reg_value_co.gif";
    public static final String IMG_LCL_AUTO_REFRESH = "org.eclipse.cdt.debug.ui.autorefresh_mem.gif";
    public static final String IMG_LCL_REFRESH = "org.eclipse.cdt.debug.ui.refresh_mem.gif";
    public static final String IMG_LCL_MEMORY_SAVE = "org.eclipse.cdt.debug.ui.memory_update.gif";
    public static final String IMG_LCL_MEMORY_CLEAR = "org.eclipse.cdt.debug.ui.memory_clear.gif";
    public static final String IMG_LCL_SHOW_ASCII = "org.eclipse.cdt.debug.ui.show_ascii.gif";
    public static final String IMG_LCL_LOAD_ALL_SYMBOLS = "org.eclipse.cdt.debug.ui.load_all_symbols_co.gif";
    public static final String IMG_LCL_CAST_TO_TYPE = "org.eclipse.cdt.debug.ui.casttotype_co.gif";
    public static final String IMG_LCL_DISPLAY_AS_ARRAY = "org.eclipse.cdt.debug.ui.showasarray_co.gif";
    public static final String IMG_TOOLS_ADD_DIR_SOURCE_LOCATION = "org.eclipse.cdt.debug.ui.adddirsource_wiz.gif";
    public static final String IMG_TOOLS_ADD_PRJ_SOURCE_LOCATION = "org.eclipse.cdt.debug.ui.addprjsource_wiz.gif";
    public static final String IMG_WIZBAN_ADD_SOURCE_LOCATION = "org.eclipse.cdt.debug.ui.add_source_location_wiz.gif";
    public static final String IMG_WIZBAN_ADD_DIR_SOURCE_LOCATION = "org.eclipse.cdt.debug.ui.add_dir_source_location_wiz.gif";
    public static final String IMG_WIZBAN_ADD_PRJ_SOURCE_LOCATION = "org.eclipse.cdt.debug.ui.add_prj_source_location_wiz.gif";
    private static final String T_OBJ = "obj16";
    private static final String T_OVR = "ovr16";
    private static final String T_WIZBAN = "wizban";
    private static final String T_LCL = "lcl16";
    private static final String T_CLCL = "clcl16";
    private static final String T_CTOOL = "ctool16";
    public static final ImageDescriptor DESC_OVRS_ERROR;
    public static final ImageDescriptor DESC_OVRS_WARNING;
    public static final ImageDescriptor DESC_OVRS_BREAKPOINT_INSTALLED;
    public static final ImageDescriptor DESC_OVRS_BREAKPOINT_INSTALLED_DISABLED;
    public static final ImageDescriptor DESC_OVRS_BREAKPOINT_CONDITIONAL;
    public static final ImageDescriptor DESC_OVRS_BREAKPOINT_CONDITIONAL_DISABLED;
    public static final ImageDescriptor DESC_OVRS_ADDRESS_BREAKPOINT;
    public static final ImageDescriptor DESC_OVRS_ADDRESS_BREAKPOINT_DISABLED;
    public static final ImageDescriptor DESC_OVRS_FUNCTION_BREAKPOINT;
    public static final ImageDescriptor DESC_OVRS_FUNCTION_BREAKPOINT_DISABLED;
    public static final ImageDescriptor DESC_OVRS_SYMBOLS;
    public static final ImageDescriptor DESC_OBJS_WATCHPOINT_ENABLED;
    public static final ImageDescriptor DESC_OBJS_WATCHPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_READ_WATCHPOINT_ENABLED;
    public static final ImageDescriptor DESC_OBJS_READ_WATCHPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_WRITE_WATCHPOINT_ENABLED;
    public static final ImageDescriptor DESC_OBJS_WRITE_WATCHPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_VARIABLE_SIMPLE;
    public static final ImageDescriptor DESC_OBJS_VARIABLE_SIMPLE_DISABLED;
    public static final ImageDescriptor DESC_OBJS_VARIABLE_AGGREGATE;
    public static final ImageDescriptor DESC_OBJS_VARIABLE_AGGREGATE_DISABLED;
    public static final ImageDescriptor DESC_OBJS_VARIABLE_POINTER;
    public static final ImageDescriptor DESC_OBJS_VARIABLE_POINTER_DISABLED;
    public static final ImageDescriptor DESC_OBJS_VARIABLE_STRING;
    public static final ImageDescriptor DESC_OBJS_REGISTER_GROUP;
    public static final ImageDescriptor DESC_OBJS_REGISTER;
    public static final ImageDescriptor DESC_OBJS_DISASSEMBLY;
    public static final ImageDescriptor DESC_OBJS_PROJECT;
    public static final ImageDescriptor DESC_OBJS_CLOSED_PROJECT;
    public static final ImageDescriptor DESC_OBJS_FOLDER;
    public static final ImageDescriptor DESC_OBJS_LOADED_SHARED_LIBRARY;
    public static final ImageDescriptor DESC_OBJS_SHARED_LIBRARY;
    public static final ImageDescriptor DESC_OBJS_SIGNAL;
    public static final ImageDescriptor DESC_WIZBAN_ADD_SOURCE_LOCATION;
    public static final ImageDescriptor DESC_WIZBAN_ADD_PRJ_SOURCE_LOCATION;
    public static final ImageDescriptor DESC_WIZBAN_ADD_DIR_SOURCE_LOCATION;
    public static final ImageDescriptor DESC_TOOLS_ADD_PRJ_SOURCE_LOCATION;
    public static final ImageDescriptor DESC_TOOLS_ADD_DIR_SOURCE_LOCATION;
    public static final ImageDescriptor DESC_LCL_CAST_TO_TYPE;
    public static final ImageDescriptor DESC_LCL_DISPLAY_AS_ARRAY;

    static {
        String pathSuffix = "icons/full/";
        try {
            fgIconBaseURL = new URL(CDebugUIPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
        }
        catch (MalformedURLException e) {
            CDebugUIPlugin.log(e);
        }
        fgImageRegistry = null;
        fgAvoidSWTErrorMap = null;
        DESC_OVRS_ERROR = CDebugImages.createManaged(T_OVR, IMG_OVRS_ERROR);
        DESC_OVRS_WARNING = CDebugImages.createManaged(T_OVR, IMG_OVRS_WARNING);
        DESC_OVRS_BREAKPOINT_INSTALLED = CDebugImages.createManaged(T_OVR, IMG_OVRS_BREAKPOINT_INSTALLED);
        DESC_OVRS_BREAKPOINT_INSTALLED_DISABLED = CDebugImages.createManaged(T_OVR, IMG_OVRS_BREAKPOINT_INSTALLED_DISABLED);
        DESC_OVRS_BREAKPOINT_CONDITIONAL = CDebugImages.createManaged(T_OVR, IMG_OVRS_BREAKPOINT_CONDITIONAL);
        DESC_OVRS_BREAKPOINT_CONDITIONAL_DISABLED = CDebugImages.createManaged(T_OVR, IMG_OVRS_BREAKPOINT_CONDITIONAL_DISABLED);
        DESC_OVRS_ADDRESS_BREAKPOINT = CDebugImages.createManaged(T_OVR, IMG_OVRS_ADDRESS_BREAKPOINT);
        DESC_OVRS_ADDRESS_BREAKPOINT_DISABLED = CDebugImages.createManaged(T_OVR, IMG_OVRS_ADDRESS_BREAKPOINT_DISABLED);
        DESC_OVRS_FUNCTION_BREAKPOINT = CDebugImages.createManaged(T_OVR, IMG_OVRS_FUNCTION_BREAKPOINT);
        DESC_OVRS_FUNCTION_BREAKPOINT_DISABLED = CDebugImages.createManaged(T_OVR, IMG_OVRS_FUNCTION_BREAKPOINT_DISABLED);
        DESC_OVRS_SYMBOLS = CDebugImages.createManaged(T_OVR, IMG_OVRS_SYMBOLS);
        DESC_OBJS_WATCHPOINT_ENABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_WATCHPOINT_ENABLED);
        DESC_OBJS_WATCHPOINT_DISABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_WATCHPOINT_DISABLED);
        DESC_OBJS_READ_WATCHPOINT_ENABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_READ_WATCHPOINT_ENABLED);
        DESC_OBJS_READ_WATCHPOINT_DISABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_READ_WATCHPOINT_DISABLED);
        DESC_OBJS_WRITE_WATCHPOINT_ENABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_WRITE_WATCHPOINT_ENABLED);
        DESC_OBJS_WRITE_WATCHPOINT_DISABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_WRITE_WATCHPOINT_DISABLED);
        DESC_OBJS_VARIABLE_SIMPLE = CDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE_SIMPLE);
        DESC_OBJS_VARIABLE_SIMPLE_DISABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE_SIMPLE_DISABLED);
        DESC_OBJS_VARIABLE_AGGREGATE = CDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE_AGGREGATE);
        DESC_OBJS_VARIABLE_AGGREGATE_DISABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE_AGGREGATE_DISABLED);
        DESC_OBJS_VARIABLE_POINTER = CDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE_POINTER);
        DESC_OBJS_VARIABLE_POINTER_DISABLED = CDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE_POINTER_DISABLED);
        DESC_OBJS_VARIABLE_STRING = CDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE_STRING);
        DESC_OBJS_REGISTER_GROUP = CDebugImages.createManaged(T_OBJ, IMG_OBJS_REGISTER_GROUP);
        DESC_OBJS_REGISTER = CDebugImages.createManaged(T_OBJ, IMG_OBJS_REGISTER);
        DESC_OBJS_DISASSEMBLY = CDebugImages.createManaged(T_OBJ, IMG_OBJS_DISASSEMBLY);
        DESC_OBJS_PROJECT = CDebugImages.createManaged(T_OBJ, IMG_OBJS_PROJECT);
        DESC_OBJS_CLOSED_PROJECT = CDebugImages.createManaged(T_OBJ, IMG_OBJS_CLOSED_PROJECT);
        DESC_OBJS_FOLDER = CDebugImages.createManaged(T_OBJ, IMG_OBJS_FOLDER);
        DESC_OBJS_LOADED_SHARED_LIBRARY = CDebugImages.createManaged(T_OBJ, IMG_OBJS_LOADED_SHARED_LIBRARY);
        DESC_OBJS_SHARED_LIBRARY = CDebugImages.createManaged(T_OBJ, IMG_OBJS_SHARED_LIBRARY);
        DESC_OBJS_SIGNAL = CDebugImages.createManaged(T_OBJ, IMG_OBJS_SIGNAL);
        DESC_WIZBAN_ADD_SOURCE_LOCATION = CDebugImages.createManaged(T_WIZBAN, IMG_WIZBAN_ADD_SOURCE_LOCATION);
        DESC_WIZBAN_ADD_PRJ_SOURCE_LOCATION = CDebugImages.createManaged(T_WIZBAN, IMG_WIZBAN_ADD_PRJ_SOURCE_LOCATION);
        DESC_WIZBAN_ADD_DIR_SOURCE_LOCATION = CDebugImages.createManaged(T_WIZBAN, IMG_WIZBAN_ADD_DIR_SOURCE_LOCATION);
        DESC_TOOLS_ADD_PRJ_SOURCE_LOCATION = CDebugImages.createManaged(T_CTOOL, IMG_TOOLS_ADD_PRJ_SOURCE_LOCATION);
        DESC_TOOLS_ADD_DIR_SOURCE_LOCATION = CDebugImages.createManaged(T_CTOOL, IMG_TOOLS_ADD_DIR_SOURCE_LOCATION);
        DESC_LCL_CAST_TO_TYPE = CDebugImages.createManaged(T_CLCL, IMG_LCL_CAST_TO_TYPE);
        DESC_LCL_DISPLAY_AS_ARRAY = CDebugImages.createManaged(T_CLCL, IMG_LCL_DISPLAY_AS_ARRAY);
    }

    public static Image get(String key) {
        return CDebugImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        CDebugImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        CDebugImages.setImageDescriptors(action, T_LCL, iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            Iterator iter = fgAvoidSWTErrorMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                fgImageRegistry.put(key, (ImageDescriptor)fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id;
        relPath = relPath.substring(NAME_PREFIX_LENGTH);
        try {
            id = ImageDescriptor.createFromURL((URL)CDebugImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            CDebugUIPlugin.log(e);
        }
        try {
            id = ImageDescriptor.createFromURL((URL)CDebugImages.makeIconFileURL("c" + type, relPath));
            if (id != null) {
                action.setHoverImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            CDebugUIPlugin.log(e);
        }
        action.setImageDescriptor(CDebugImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)CDebugImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (fgAvoidSWTErrorMap == null) {
                fgAvoidSWTErrorMap = new HashMap();
            }
            fgAvoidSWTErrorMap.put(name, result);
            if (fgImageRegistry != null) {
                CDebugUIPlugin.logErrorMessage("Internal Error: Image registry already defined");
            }
            return result;
        }
        catch (MalformedURLException e) {
            CDebugUIPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)CDebugImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            CDebugUIPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(fgIconBaseURL, buffer.toString());
    }
}

