/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    static final int DEFAULT_WIDTH = 16;
    static final int DEFAULT_HEIGHT = 16;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private Image fBase;
    private ImageDescriptor[] fOverlays;
    private Point fSize;

    public OverlayImageDescriptor(Image base, ImageDescriptor[] overlays) {
        this.fBase = base;
        this.fOverlays = overlays;
        this.fSize = new Point(16, 16);
    }

    public OverlayImageDescriptor(Image base, ImageDescriptor[] overlays, Point size) {
        this.fBase = base;
        this.fOverlays = overlays;
        this.fSize = size;
    }

    protected void drawOverlays(ImageDescriptor[] overlays) {
        Point size = this.getSize();
        int i = 0;
        while (i < overlays.length) {
            ImageDescriptor overlay = overlays[i];
            if (overlay != null) {
                ImageData overlayData = overlay.getImageData();
                if (overlayData == null) {
                    overlayData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                }
                switch (i) {
                    case 0: {
                        this.drawImage(overlayData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(overlayData, size.x - overlayData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(overlayData, 0, size.y - overlayData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(overlayData, size.x - overlayData.width, size.y - overlayData.height);
                    }
                }
            }
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof OverlayImageDescriptor)) {
            return false;
        }
        OverlayImageDescriptor other = (OverlayImageDescriptor)((Object)o);
        return this.fBase.equals((Object)other.fBase) && Arrays.equals(this.fOverlays, other.fOverlays);
    }

    public int hashCode() {
        int code = this.fBase.hashCode();
        int i = 0;
        while (i < this.fOverlays.length) {
            if (this.fOverlays[i] != null) {
                code ^= this.fOverlays[i].hashCode();
            }
            ++i;
        }
        return code;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.fBase.getImageData(), 0, 0);
        this.drawOverlays(this.fOverlays);
    }

    protected Point getSize() {
        return this.fSize;
    }
}

