/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.BacktrackException;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.ASTSemanticException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.Declarator;
import org.eclipse.cdt.internal.core.parser.IDeclaratorOwner;

public class DeclarationWrapper
implements IDeclaratorOwner {
    private boolean imaginary;
    private boolean complex;
    private boolean restrict;
    private int endOffset;
    private ITokenDuple name;
    private IASTSimpleTypeSpecifier.Type simpleType = IASTSimpleTypeSpecifier.Type.UNSPECIFIED;
    private boolean isSigned;
    private boolean isLong;
    private boolean isShort;
    private boolean isUnsigned;
    private final IASTTemplate templateDeclaration;
    private final IASTScope scope;
    private IASTTypeSpecifier typeSpecifier;
    private List declarators = new ArrayList();
    private boolean typeNamed = false;
    private boolean volatil = false;
    private boolean virtual = false;
    private boolean typedef = false;
    private boolean staticc = false;
    private boolean register = false;
    private boolean extern = false;
    private boolean explicit = false;
    private boolean constt = false;
    private int startingOffset = 0;
    private boolean auto = false;
    private boolean mutable = false;
    private boolean friend = false;
    private boolean inline = false;
    private int startingLine;
    private IASTFactory astFactory = null;
    private int endLine;

    public void setAuto(boolean bl) {
        this.auto = bl;
    }

    public IASTScope getScope() {
        return this.scope;
    }

    public DeclarationWrapper(IASTScope iASTScope, int n, int n2, IASTTemplate iASTTemplate) {
        this.scope = iASTScope;
        this.startingOffset = n;
        this.startingLine = n2;
        this.templateDeclaration = iASTTemplate;
    }

    public void setTypenamed(boolean bl) {
        this.typeNamed = bl;
    }

    public void setMutable(boolean bl) {
        this.mutable = bl;
    }

    public void setFriend(boolean bl) {
        this.friend = bl;
    }

    public void setInline(boolean bl) {
        this.inline = bl;
    }

    public void setRegister(boolean bl) {
        this.register = bl;
    }

    public void setStatic(boolean bl) {
        this.staticc = bl;
    }

    public void setTypedef(boolean bl) {
        this.typedef = bl;
    }

    public void setVirtual(boolean bl) {
        this.virtual = bl;
    }

    public void setVolatile(boolean bl) {
        this.volatil = bl;
    }

    public void setExtern(boolean bl) {
        this.extern = bl;
    }

    public void setExplicit(boolean bl) {
        this.explicit = bl;
    }

    public void setConst(boolean bl) {
        this.constt = bl;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public boolean isConst() {
        return this.constt;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isExtern() {
        return this.extern;
    }

    public boolean isFriend() {
        return this.friend;
    }

    public boolean isInline() {
        return this.inline;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isRegister() {
        return this.register;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getStartingLine() {
        return this.startingLine;
    }

    public boolean isStatic() {
        return this.staticc;
    }

    public boolean isTypedef() {
        return this.typedef;
    }

    public boolean isTypeNamed() {
        return this.typeNamed;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isVolatile() {
        return this.volatil;
    }

    public void addDeclarator(Declarator declarator) {
        this.declarators.add(declarator);
    }

    public Iterator getDeclarators() {
        return Collections.unmodifiableList(this.declarators).iterator();
    }

    public IASTTypeSpecifier getTypeSpecifier() {
        return this.typeSpecifier;
    }

    public void setTypeSpecifier(IASTTypeSpecifier iASTTypeSpecifier) {
        this.typeSpecifier = iASTTypeSpecifier;
    }

    public List createASTNodes(IASTFactory iASTFactory) throws ASTSemanticException, BacktrackException {
        this.astFactory = iASTFactory;
        Iterator iterator = this.declarators.iterator();
        ArrayList<IASTDeclaration> arrayList = new ArrayList<IASTDeclaration>();
        while (iterator.hasNext()) {
            arrayList.add(this.createASTNode((Declarator)iterator.next()));
        }
        return arrayList;
    }

    private IASTDeclaration createASTNode(Declarator declarator) throws ASTSemanticException, BacktrackException {
        boolean bl;
        boolean bl2 = this.getScope() instanceof IASTClassSpecifier;
        boolean bl3 = declarator.isFunction();
        boolean bl4 = bl = declarator.getOwnedDeclarator() != null;
        if (bl) {
            return this.createIndirectDeclaration(declarator);
        }
        if (this.isTypedef()) {
            return this.createTypedef(declarator, false);
        }
        if (bl2) {
            if (bl3) {
                return this.createMethodASTNode(declarator, false);
            }
            return this.createFieldASTNode(declarator, false);
        }
        if (bl3) {
            return this.createFunctionASTNode(declarator, false);
        }
        return this.createVariableASTNode(declarator, false);
    }

    private IASTDeclaration createIndirectDeclaration(Declarator declarator) throws BacktrackException, ASTSemanticException {
        if (declarator.getOwnedDeclarator().getOwnedDeclarator() == null) {
            String string;
            Declarator declarator2 = declarator.getOwnedDeclarator();
            Iterator iterator = declarator2.getPointerOperators().iterator();
            if (!iterator.hasNext()) {
                boolean bl;
                boolean bl2 = this.scope instanceof IASTClassSpecifier;
                boolean bl3 = bl = declarator.getParameters().size() != 0;
                if (this.isTypedef()) {
                    return this.createTypedef(declarator, true);
                }
                if (bl2) {
                    if (bl) {
                        return this.createMethodASTNode(declarator, true);
                    }
                    return this.createFieldASTNode(declarator, true);
                }
                if (bl) {
                    return this.createFunctionASTNode(declarator, true);
                }
                return this.createVariableASTNode(declarator, true);
            }
            List list = this.createParameterList(declarator.getParameters());
            IASTAbstractDeclaration iASTAbstractDeclaration = null;
            iASTAbstractDeclaration = this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), list, (ASTPointerOperator)iterator.next());
            String string2 = string = declarator2.getPointerOperatorNameDuple() != null ? String.valueOf(declarator2.getPointerOperatorNameDuple().toString()) + declarator2.getName() : declarator2.getName();
            if (this.typedef) {
                return this.astFactory.createTypedef(this.scope, string, iASTAbstractDeclaration, this.getStartingOffset(), this.getStartingLine(), declarator2.getNameStartOffset(), declarator2.getNameEndOffset(), declarator2.getNameLine());
            }
            return this.astFactory.createVariable(this.scope, string, this.auto, declarator2.getInitializerClause(), declarator2.getBitFieldExpression(), iASTAbstractDeclaration, this.mutable, this.extern, this.register, this.staticc, this.getStartingOffset(), this.getStartingLine(), declarator2.getNameStartOffset(), declarator2.getNameEndOffset(), declarator2.getNameLine(), declarator2.getConstructorExpression());
        }
        throw new BacktrackException();
    }

    private IASTTypedefDeclaration createTypedef(Declarator declarator, boolean bl) throws ASTSemanticException {
        return this.astFactory.createTypedef(this.scope, bl ? declarator.getOwnedDeclarator().getName() : declarator.getName(), this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine());
    }

    private IASTMethod createMethodASTNode(Declarator declarator, boolean bl) throws ASTSemanticException {
        return this.astFactory.createMethod(this.scope, bl ? declarator.getOwnedDeclarator().getNameDuple() : declarator.getNameDuple(), this.createParameterList(declarator.getParameters()), this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), declarator.getExceptionSpecification(), this.inline, this.friend, this.staticc, this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), this.templateDeclaration, declarator.isConst(), declarator.isVolatile(), this.virtual, this.explicit, declarator.isPureVirtual(), ((IASTClassSpecifier)this.scope).getCurrentVisibilityMode(), declarator.getConstructorMemberInitializers(), declarator.hasFunctionBody(), declarator.hasFunctionTryBlock(), declarator.isVarArgs());
    }

    private IASTFunction createFunctionASTNode(Declarator declarator, boolean bl) throws ASTSemanticException {
        return this.astFactory.createFunction(this.scope, bl ? declarator.getOwnedDeclarator().getNameDuple() : declarator.getNameDuple(), this.createParameterList(declarator.getParameters()), this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), declarator.getExceptionSpecification(), this.inline, this.friend, this.staticc, this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), this.templateDeclaration, declarator.isConst(), declarator.isVolatile(), this.virtual, this.explicit, declarator.isPureVirtual(), declarator.getConstructorMemberInitializers(), declarator.hasFunctionBody(), declarator.hasFunctionTryBlock(), declarator.isVarArgs());
    }

    private IASTField createFieldASTNode(Declarator declarator, boolean bl) throws ASTSemanticException {
        return this.astFactory.createField(this.scope, bl ? declarator.getOwnedDeclarator().getName() : declarator.getName(), this.auto, declarator.getInitializerClause(), declarator.getBitFieldExpression(), this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.mutable, this.extern, this.register, this.staticc, this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), declarator.getConstructorExpression(), ((IASTClassSpecifier)this.scope).getCurrentVisibilityMode());
    }

    private List createParameterList(List list) throws ASTSemanticException {
        ArrayList<IASTParameterDeclaration> arrayList = new ArrayList<IASTParameterDeclaration>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DeclarationWrapper declarationWrapper = (DeclarationWrapper)iterator.next();
            Iterator iterator2 = declarationWrapper.getDeclarators();
            while (iterator2.hasNext()) {
                Declarator declarator = (Declarator)iterator2.next();
                arrayList.add(this.astFactory.createParameterDeclaration(declarationWrapper.isConst(), declarationWrapper.isVolatile(), declarationWrapper.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null, declarator.getName() == null ? "" : declarator.getName(), declarator.getInitializerClause(), declarationWrapper.getStartingOffset(), this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), declarationWrapper.getEndOffset(), this.getEndLine()));
            }
        }
        return arrayList;
    }

    private IASTVariable createVariableASTNode(Declarator declarator, boolean bl) throws ASTSemanticException {
        return this.astFactory.createVariable(this.scope, bl ? declarator.getOwnedDeclarator().getName() : declarator.getName(), this.isAuto(), declarator.getInitializerClause(), declarator.getBitFieldExpression(), this.astFactory.createAbstractDeclaration(this.constt, this.volatil, this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.mutable, this.extern, this.register, this.staticc, this.getStartingOffset(), this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), declarator.getConstructorExpression());
    }

    public DeclarationWrapper getDeclarationWrapper() {
        return this;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public void setLong(boolean bl) {
        this.isLong = bl;
    }

    public void setShort(boolean bl) {
        this.isShort = bl;
    }

    public void setSigned(boolean bl) {
        this.isSigned = bl;
    }

    public void setUnsigned(boolean bl) {
        this.isUnsigned = bl;
    }

    public IASTSimpleTypeSpecifier.Type getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(IASTSimpleTypeSpecifier.Type type) {
        this.simpleType = type;
    }

    public void setTypeName(ITokenDuple iTokenDuple) {
        this.name = iTokenDuple;
    }

    public ITokenDuple getName() {
        return this.name;
    }

    public void setName(ITokenDuple iTokenDuple) {
        this.name = iTokenDuple;
    }

    public IASTTemplate getOwnerTemplate() {
        return this.templateDeclaration;
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endOffset = n;
        this.endLine = n2;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setRestrict(boolean bl) {
        this.restrict = bl;
    }

    public boolean isRestrict() {
        return this.restrict;
    }

    public void setImaginary(boolean bl) {
        this.imaginary = bl;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public boolean isImaginary() {
        return this.imaginary;
    }

    public void setComplex(boolean bl) {
        this.complex = bl;
    }
}

