/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.internal.core.parser.ContextualParser;
import org.eclipse.cdt.internal.core.parser.token.OffsetDuple;
import org.eclipse.cdt.internal.core.parser.token.TokenDuple;

public class SelectionParser
extends ContextualParser {
    private OffsetDuple offsetRange;
    private IToken firstTokenOfDuple = null;
    private IToken lastTokenOfDuple = null;

    protected void handleNewToken(IToken iToken) {
        if (iToken != null && this.scanner.isOnTopContext()) {
            this.log.traceLog("IToken provided w/offsets " + iToken.getOffset() + " & " + iToken.getEndOffset());
            if (iToken.getOffset() == this.offsetRange.getFloorOffset()) {
                this.log.traceLog("Offset Floor Hit w/token \"" + iToken.getImage() + "\"");
                this.firstTokenOfDuple = iToken;
            }
            if (iToken.getEndOffset() == this.offsetRange.getCeilingOffset()) {
                this.log.traceLog("Offset Ceiling Hit w/token \"" + iToken.getImage() + "\"");
                this.lastTokenOfDuple = iToken;
            }
        }
    }

    public SelectionParser(IScanner iScanner, ISourceElementRequestor iSourceElementRequestor, ParserLanguage parserLanguage, IParserLogService iParserLogService) {
        super(iScanner, iSourceElementRequestor, parserLanguage, iParserLogService);
    }

    public IASTNode parse(int n, int n2) {
        this.offsetRange = new OffsetDuple(n, n2);
        this.translationUnit();
        return this.reconcileTokenDuple();
    }

    protected IASTNode reconcileTokenDuple() throws ParseError {
        if (this.firstTokenOfDuple == null || this.lastTokenOfDuple == null) {
            throw new ParseError(ParseError.ParseErrorKind.OFFSET_RANGE_NOT_NAME);
        }
        if (this.getCompletionKind() == IASTCompletionNode.CompletionKind.UNREACHABLE_CODE) {
            throw new ParseError(ParseError.ParseErrorKind.OFFSETDUPLE_UNREACHABLE);
        }
        TokenDuple tokenDuple = new TokenDuple(this.firstTokenOfDuple, this.lastTokenOfDuple);
        return tokenDuple.lookup(this.astFactory, this.getCompletionScope());
    }

    public IASTCompletionNode parse(int n) {
        throw new ParseError(ParseError.ParseErrorKind.METHOD_NOT_IMPLEMENTED);
    }

    protected void checkEndOfFile() throws EndOfFileException {
        if (this.scanner.isOnTopContext() && this.lastTokenOfDuple != null && this.lastTokenOfDuple.getEndOffset() >= this.offsetRange.getCeilingOffset()) {
            throw new EndOfFileException();
        }
    }
}

