/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTExpressionEvaluationException;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTypeId;
import org.eclipse.cdt.internal.core.parser.ast.complete.ExpressionResult;

public class ASTExpression
implements IASTExpression {
    private final IASTExpression.Kind kind;
    private final IASTExpression lhs;
    private final IASTExpression rhs;
    private final IASTExpression thirdExpression;
    private final String literal;
    private final String idExpression;
    private ITokenDuple idExpressionDuple;
    private final IASTTypeId typeId;
    private final IASTExpression.IASTNewExpressionDescriptor newDescriptor;
    private final List references;
    private ExpressionResult resultType;

    public ASTExpression(IASTExpression.Kind kind, IASTExpression iASTExpression, IASTExpression iASTExpression2, IASTExpression iASTExpression3, IASTTypeId iASTTypeId, ITokenDuple iTokenDuple, String string, IASTExpression.IASTNewExpressionDescriptor iASTNewExpressionDescriptor, List list) {
        this.kind = kind;
        this.lhs = iASTExpression;
        this.rhs = iASTExpression2;
        this.thirdExpression = iASTExpression3;
        this.literal = string;
        this.typeId = iASTTypeId;
        this.newDescriptor = iASTNewExpressionDescriptor;
        this.references = list;
        this.idExpressionDuple = iTokenDuple;
        this.idExpression = this.idExpressionDuple == null ? "" : this.idExpressionDuple.toString();
    }

    public IASTExpression.Kind getExpressionKind() {
        return this.kind;
    }

    public IASTExpression getLHSExpression() {
        return this.lhs;
    }

    public IASTExpression getRHSExpression() {
        return this.rhs;
    }

    public IASTExpression getThirdExpression() {
        return this.thirdExpression;
    }

    public String getLiteralString() {
        return this.literal;
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public ITokenDuple getTypeIdTokenDuple() {
        if (this.typeId == null) {
            return null;
        }
        return ((ASTTypeId)this.typeId).getTokenDuple();
    }

    public IASTExpression.IASTNewExpressionDescriptor getNewExpressionDescriptor() {
        return this.newDescriptor;
    }

    public int evaluateExpression() throws ASTExpressionEvaluationException {
        throw new ASTExpressionEvaluationException();
    }

    public List getReferences() {
        return this.references;
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor) {
        try {
            this.reconcileReferences();
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {}
        if (!this.references.isEmpty()) {
            new ASTReferenceStore(this.references).processReferences(iSourceElementRequestor);
        }
        if (this.typeId != null) {
            this.typeId.acceptElement(iSourceElementRequestor);
        }
        if (this.lhs != null) {
            this.lhs.acceptElement(iSourceElementRequestor);
        }
        if (this.rhs != null) {
            this.rhs.acceptElement(iSourceElementRequestor);
        }
        if (this.thirdExpression != null) {
            this.thirdExpression.acceptElement(iSourceElementRequestor);
        }
        if (this.newDescriptor != null) {
            this.newDescriptor.acceptElement(iSourceElementRequestor);
        }
        try {
            this.purgeReferences();
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {}
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor) {
    }

    public ExpressionResult getResultType() {
        return this.resultType;
    }

    public void setResultType(ExpressionResult expressionResult) {
        this.resultType = expressionResult;
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public ITokenDuple getIdExpressionTokenDuple() {
        return this.idExpressionDuple;
    }

    public void reconcileReferences() throws ASTNotImplementedException {
        if (this.lhs != null) {
            this.lhs.reconcileReferences();
        }
        if (this.rhs != null) {
            this.rhs.reconcileReferences();
        }
        if (this.thirdExpression != null) {
            this.thirdExpression.reconcileReferences();
        }
        this.reconcileSubExpression((ASTExpression)this.lhs);
        this.reconcileSubExpression((ASTExpression)this.rhs);
        this.reconcileSubExpression((ASTExpression)this.thirdExpression);
    }

    protected void reconcileSubExpression(ASTExpression aSTExpression) {
        if (aSTExpression != null && aSTExpression.getReferences() != null) {
            Iterator iterator = aSTExpression.getReferences().iterator();
            while (iterator.hasNext()) {
                IASTReference iASTReference = (IASTReference)iterator.next();
                if (iASTReference == null || !this.references.contains(iASTReference)) continue;
                iterator.remove();
            }
        }
    }

    public void purgeReferences() throws ASTNotImplementedException {
        if (this.lhs != null) {
            this.lhs.purgeReferences();
        }
        if (this.rhs != null) {
            this.rhs.purgeReferences();
        }
        if (this.thirdExpression != null) {
            this.thirdExpression.purgeReferences();
        }
        this.purgeSubExpression((ASTExpression)this.lhs);
        this.purgeSubExpression((ASTExpression)this.rhs);
        this.purgeSubExpression((ASTExpression)this.thirdExpression);
    }

    protected void purgeSubExpression(ASTExpression aSTExpression) {
        if (aSTExpression != null && aSTExpression.getReferences() != null) {
            aSTExpression.getReferences().clear();
        }
    }
}

