/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IExtensibleSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class DerivableContainerSymbol
extends ContainerSymbol
implements IDerivableContainerSymbol {
    private LinkedList _constructors;
    private LinkedList _parentScopes;
    private LinkedList _friends;

    protected DerivableContainerSymbol(ParserSymbolTable parserSymbolTable, String string) {
        super(parserSymbolTable, string);
    }

    protected DerivableContainerSymbol(ParserSymbolTable parserSymbolTable, String string, ISymbolASTExtension iSymbolASTExtension) {
        super(parserSymbolTable, string, iSymbolASTExtension);
    }

    protected DerivableContainerSymbol(ParserSymbolTable parserSymbolTable, String string, TypeInfo.eType eType2) {
        super(parserSymbolTable, string, eType2);
    }

    public Object clone() {
        DerivableContainerSymbol derivableContainerSymbol = (DerivableContainerSymbol)super.clone();
        derivableContainerSymbol._parentScopes = this._parentScopes != null ? (LinkedList)this._parentScopes.clone() : null;
        derivableContainerSymbol._constructors = this._constructors != null ? (LinkedList)this._constructors.clone() : null;
        return derivableContainerSymbol;
    }

    public ISymbol instantiate(ITemplateSymbol iTemplateSymbol, Map map) throws ParserSymbolTableException {
        Object object;
        Object object2;
        if (!this.isTemplateMember()) {
            return null;
        }
        DerivableContainerSymbol derivableContainerSymbol = (DerivableContainerSymbol)super.instantiate(iTemplateSymbol, map);
        Iterator iterator = this.getParents().iterator();
        derivableContainerSymbol.getParents().clear();
        ParentWrapper parentWrapper = null;
        ParentWrapper parentWrapper2 = null;
        while (iterator.hasNext()) {
            parentWrapper = (ParentWrapper)iterator.next();
            parentWrapper2 = new ParentWrapper(parentWrapper.getParent(), parentWrapper.isVirtual(), parentWrapper.getAccess(), parentWrapper.getOffset(), parentWrapper.getReferences());
            object2 = parentWrapper2.getParent();
            if (object2 instanceof IDeferredTemplateInstance) {
                parentWrapper2.setParent(((IDeferredTemplateInstance)object2).instantiate(iTemplateSymbol, map));
            } else if (object2.isType(TypeInfo.t_templateParameter) && map.containsKey(object2)) {
                object = (TypeInfo)map.get(object2);
                parentWrapper2.setParent(((TypeInfo)object).getTypeSymbol());
            }
            derivableContainerSymbol.getParents().add(parentWrapper2);
        }
        object2 = this.getConstructors().iterator();
        derivableContainerSymbol.getConstructors().clear();
        object = null;
        while (object2.hasNext()) {
            object = (IParameterizedSymbol)object2.next();
            derivableContainerSymbol.getConstructors().add(object.instantiate(iTemplateSymbol, map));
        }
        return derivableContainerSymbol;
    }

    public void addSymbol(ISymbol iSymbol) throws ParserSymbolTableException {
        super.addSymbol(iSymbol);
        if (iSymbol instanceof IParameterizedSymbol) {
            this.addThis((IParameterizedSymbol)iSymbol);
        }
    }

    public void addParent(ISymbol iSymbol) {
        this.addParent(iSymbol, false, ASTAccessVisibility.PUBLIC, -1, null);
    }

    public void addParent(ISymbol iSymbol, boolean bl, ASTAccessVisibility aSTAccessVisibility, int n, List list) {
        if (this._parentScopes == null) {
            this._parentScopes = new LinkedList();
        }
        ParentWrapper parentWrapper = new ParentWrapper(iSymbol, bl, aSTAccessVisibility, n, list);
        this._parentScopes.add(parentWrapper);
        AddParentCommand addParentCommand = new AddParentCommand(this, parentWrapper);
        this.getSymbolTable().pushCommand(addParentCommand);
    }

    public List getParents() {
        if (this._parentScopes == null) {
            this._parentScopes = new LinkedList();
        }
        return this._parentScopes;
    }

    public boolean hasParents() {
        return this._parentScopes != null && !this._parentScopes.isEmpty();
    }

    public void addConstructor(IParameterizedSymbol iParameterizedSymbol) throws ParserSymbolTableException {
        if (!iParameterizedSymbol.isType(TypeInfo.t_constructor)) {
            throw new ParserSymbolTableException(1);
        }
        List list = this.getConstructors();
        if (list.size() != 0 && !ParserSymbolTable.isValidOverload(list, (ISymbol)iParameterizedSymbol)) {
            throw new ParserSymbolTableException(3);
        }
        list.add(iParameterizedSymbol);
        iParameterizedSymbol.setContainingSymbol(this);
        this.addThis(iParameterizedSymbol);
        this.getContents().add(iParameterizedSymbol);
        AddConstructorCommand addConstructorCommand = new AddConstructorCommand(iParameterizedSymbol, this);
        this.getSymbolTable().pushCommand(addConstructorCommand);
    }

    public void addCopyConstructor() throws ParserSymbolTableException {
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 32768, (ISymbol)this, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference, false, false), false);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol = null;
        try {
            iParameterizedSymbol = this.lookupConstructor(linkedList);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        if (iParameterizedSymbol == null) {
            iParameterizedSymbol = this.getSymbolTable().newParameterizedSymbol(this.getName(), TypeInfo.t_constructor);
            iParameterizedSymbol.addParameter(this, 32768, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference, false, false), false);
            this.addConstructor(iParameterizedSymbol);
        }
    }

    public IParameterizedSymbol lookupConstructor(List list) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData lookupData = new ParserSymbolTable.LookupData("", TypeInfo.t_constructor);
        lookupData.parameters = list;
        LinkedList linkedList = new LinkedList();
        if (!this.getConstructors().isEmpty()) {
            linkedList.addAll(this.getConstructors());
        }
        return ParserSymbolTable.resolveFunction(lookupData, linkedList);
    }

    public List getConstructors() {
        if (this._constructors == null) {
            this._constructors = new LinkedList();
        }
        return this._constructors;
    }

    private boolean addThis(IParameterizedSymbol iParameterizedSymbol) {
        if (this.getSymbolTable().getLanguage() != ParserLanguage.CPP) {
            return false;
        }
        TypeInfo typeInfo = iParameterizedSymbol.getTypeInfo();
        if (!typeInfo.isType(TypeInfo.t_function) && !typeInfo.isType(TypeInfo.t_constructor) || typeInfo.checkBit(128)) {
            return false;
        }
        if (iParameterizedSymbol.getContainingSymbol().isType(TypeInfo.t_class, TypeInfo.t_union)) {
            Object object;
            boolean bl = false;
            ParserSymbolTable.LookupData lookupData = new ParserSymbolTable.LookupData("this", TypeInfo.t_any);
            try {
                object = ParserSymbolTable.lookupInContained(lookupData, iParameterizedSymbol);
                bl = object.containsKey(lookupData.name);
            }
            catch (ParserSymbolTableException parserSymbolTableException) {
                return false;
            }
            if (!bl) {
                object = this.getSymbolTable().newSymbol("this", TypeInfo.t_type);
                object.setTypeSymbol(iParameterizedSymbol.getContainingSymbol());
                TypeInfo.PtrOp ptrOp = new TypeInfo.PtrOp();
                ptrOp.setType(TypeInfo.PtrOp.t_pointer);
                object.getTypeInfo().setBit(iParameterizedSymbol.getTypeInfo().checkBit(32768), 32768);
                object.getTypeInfo().setBit(iParameterizedSymbol.getTypeInfo().checkBit(65536), 65536);
                object.addPtrOperator(ptrOp);
                try {
                    iParameterizedSymbol.addSymbol((ISymbol)object);
                }
                catch (ParserSymbolTableException parserSymbolTableException) {
                    return false;
                }
            }
        }
        return true;
    }

    public void addFriend(ISymbol iSymbol) {
        IContainerSymbol iContainerSymbol = iSymbol.getContainingSymbol();
        if (iContainerSymbol == null) {
            IContainerSymbol iContainerSymbol2 = this.getContainingSymbol();
            while (iContainerSymbol2 != null && !iContainerSymbol2.isType(TypeInfo.t_namespace)) {
                iContainerSymbol2 = iContainerSymbol2.getContainingSymbol();
            }
            iSymbol.setIsInvisible(true);
            iSymbol.setIsForwardDeclaration(true);
            try {
                iContainerSymbol2.addSymbol(iSymbol);
            }
            catch (ParserSymbolTableException parserSymbolTableException) {}
        }
        this.getFriends().add(iSymbol);
    }

    public ISymbol lookupForFriendship(String string) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData lookupData = new ParserSymbolTable.LookupData(string, TypeInfo.t_any);
        IContainerSymbol iContainerSymbol = this.getContainingSymbol();
        if (iContainerSymbol != null && iContainerSymbol.isType(TypeInfo.t_namespace, TypeInfo.t_union)) {
            while (iContainerSymbol != null && iContainerSymbol.getType() != TypeInfo.t_namespace) {
                iContainerSymbol = iContainerSymbol.getContainingSymbol();
            }
        }
        lookupData.stopAt = iContainerSymbol;
        ParserSymbolTable.lookup(lookupData, this);
        return ParserSymbolTable.resolveAmbiguities(lookupData);
    }

    public IParameterizedSymbol lookupFunctionForFriendship(String string, List list) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData lookupData = new ParserSymbolTable.LookupData(string, TypeInfo.t_any);
        lookupData.parameters = list;
        IContainerSymbol iContainerSymbol = this.getContainingSymbol();
        if (iContainerSymbol != null && iContainerSymbol.isType(TypeInfo.t_namespace, TypeInfo.t_union)) {
            while (iContainerSymbol != null && iContainerSymbol.getType() != TypeInfo.t_namespace) {
                iContainerSymbol = iContainerSymbol.getContainingSymbol();
            }
        }
        lookupData.stopAt = iContainerSymbol;
        ParserSymbolTable.lookup(lookupData, this);
        return (IParameterizedSymbol)ParserSymbolTable.resolveAmbiguities(lookupData);
    }

    public List getFriends() {
        if (this._friends == null) {
            this._friends = new LinkedList();
        }
        return this._friends;
    }

    private static class AddParentCommand
    extends ParserSymbolTable.Command {
        private IDerivableContainerSymbol _decl;
        private ParentWrapper _wrapper;

        public AddParentCommand(IDerivableContainerSymbol iDerivableContainerSymbol, ParentWrapper parentWrapper) {
            this._decl = iDerivableContainerSymbol;
            this._wrapper = parentWrapper;
        }

        public void undoIt() {
            List list = this._decl.getParents();
            list.remove(this._wrapper);
        }
    }

    private static class AddConstructorCommand
    extends ParserSymbolTable.Command {
        private final IParameterizedSymbol _constructor;
        private final IDerivableContainerSymbol _context;

        AddConstructorCommand(IParameterizedSymbol iParameterizedSymbol, IDerivableContainerSymbol iDerivableContainerSymbol) {
            this._constructor = iParameterizedSymbol;
            this._context = iDerivableContainerSymbol;
        }

        public void undoIt() {
            List list = this._context.getConstructors();
            ListIterator listIterator = list.listIterator();
            int n = list.size();
            IParameterizedSymbol iParameterizedSymbol = null;
            int n2 = 0;
            while (n2 < n) {
                iParameterizedSymbol = (IParameterizedSymbol)listIterator.next();
                if (iParameterizedSymbol == this._constructor) {
                    listIterator.remove();
                    break;
                }
                ++n2;
            }
            ContainerSymbol.ContentsIterator contentsIterator = (ContainerSymbol.ContentsIterator)this._context.getContentsIterator();
            while (listIterator.hasNext()) {
                IExtensibleSymbol iExtensibleSymbol = (IExtensibleSymbol)listIterator.next();
                if (iExtensibleSymbol != this._constructor) continue;
                contentsIterator.removeSymbol();
                break;
            }
        }
    }

    public class ParentWrapper
    implements IDerivableContainerSymbol.IParentSymbol {
        private boolean isVirtual = false;
        protected ISymbol parent = null;
        private final ASTAccessVisibility access;
        private final int offset;
        private final List references;

        public ParentWrapper(ISymbol iSymbol, boolean bl, ASTAccessVisibility aSTAccessVisibility, int n, List list) {
            this.parent = iSymbol;
            this.isVirtual = bl;
            this.access = aSTAccessVisibility;
            this.offset = n;
            this.references = list;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public void setParent(ISymbol iSymbol) {
            this.parent = iSymbol;
        }

        public ISymbol getParent() {
            return this.parent;
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        public void setVirtual(boolean bl) {
            this.isVirtual = bl;
        }

        public ASTAccessVisibility getAccess() {
            return this.access;
        }

        public int getOffset() {
            return this.offset;
        }

        public List getReferences() {
            return this.references;
        }
    }
}

