/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.parser.IMacroDescriptor;

public class ObjectMacroDescriptor
implements IMacroDescriptor {
    private static final List EMPTY_LIST = new ArrayList();
    private final String fullSignature;
    private final String expansionSignature;
    private final String name;
    private final List tokenizedExpansion;

    public ObjectMacroDescriptor(String string, String string2) {
        this.name = string;
        this.expansionSignature = string2;
        this.fullSignature = "#define " + string + " " + string2;
        this.tokenizedExpansion = EMPTY_LIST;
    }

    public ObjectMacroDescriptor(String string, String string2, List list, String string3) {
        this.name = string;
        this.tokenizedExpansion = list;
        this.fullSignature = string2;
        this.expansionSignature = string3;
    }

    public IMacroDescriptor.MacroType getMacroType() {
        return IMacroDescriptor.MacroType.OBJECT_LIKE;
    }

    public List getParameters() {
        return EMPTY_LIST;
    }

    public List getTokenizedExpansion() {
        return this.tokenizedExpansion;
    }

    public String getName() {
        return this.name;
    }

    public String getCompleteSignature() {
        return this.fullSignature;
    }

    public boolean compatible(IMacroDescriptor iMacroDescriptor) {
        if (iMacroDescriptor.getName() == null) {
            return false;
        }
        if (iMacroDescriptor.getMacroType() != this.getMacroType()) {
            return false;
        }
        if (iMacroDescriptor.getTokenizedExpansion() == null) {
            return false;
        }
        if (!this.name.equals(iMacroDescriptor.getName())) {
            return false;
        }
        if (iMacroDescriptor.getTokenizedExpansion().size() != this.tokenizedExpansion.size()) {
            return false;
        }
        return iMacroDescriptor.getTokenizedExpansion().containsAll(this.tokenizedExpansion);
    }

    public String getExpansionSignature() {
        return this.expansionSignature;
    }
}

