/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LaunchUIPlugin
extends AbstractUIPlugin
implements IDebugEventSetListener {
    public static final String PLUGIN_ID = LaunchUIPlugin.getUniqueIdentifier();
    private static LaunchUIPlugin fgPlugin;
    private static Shell debugDialogShell;

    public LaunchUIPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        LaunchUIPlugin.setDefault(this);
    }

    private static void setDefault(LaunchUIPlugin launchUIPlugin) {
        fgPlugin = launchUIPlugin;
    }

    public static LaunchUIPlugin getDefault() {
        return fgPlugin;
    }

    public static Shell getShell() {
        if (LaunchUIPlugin.getActiveWorkbenchShell() != null) {
            return LaunchUIPlugin.getActiveWorkbenchShell();
        }
        if (debugDialogShell != null) {
            if (!debugDialogShell.isDisposed()) {
                return debugDialogShell;
            }
            debugDialogShell = null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = LaunchUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return iWorkbenchWindowArray[0].getShell();
    }

    public static void setDialogShell(Shell shell) {
        debugDialogShell = shell;
    }

    public static String getUniqueIdentifier() {
        if (LaunchUIPlugin.getDefault() == null) {
            return "org.eclipse.cdt.launch";
        }
        return LaunchUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static void log(IStatus iStatus) {
        LaunchUIPlugin.getDefault().getLog().log(iStatus);
    }

    public static void logErrorMessage(String string) {
        LaunchUIPlugin.log((IStatus)new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 4, string, null));
    }

    public static void log(Throwable throwable) {
        LaunchUIPlugin.log((IStatus)new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 4, throwable.getMessage(), throwable));
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return LaunchUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = LaunchUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = LaunchUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static void errorDialog(String string, IStatus iStatus) {
        LaunchUIPlugin.log(iStatus);
        Shell shell = LaunchUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)string, (IStatus)iStatus);
        }
    }

    public static void errorDialog(String string, Throwable throwable) {
        LaunchUIPlugin.log(throwable);
        Shell shell = LaunchUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 1, throwable.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)string, (IStatus)status);
        }
    }

    public void shutdown() throws CoreException {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.shutdown();
    }

    public void startup() throws CoreException {
        super.startup();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] debugEventArray) {
        int n = 0;
        while (n < debugEventArray.length) {
            Object object;
            if (debugEventArray[n].getKind() == 8 && (object = debugEventArray[n].getSource()) instanceof IProcess) {
                IProcess iProcess = (IProcess)object;
                ICProject iCProject = null;
                try {
                    iCProject = AbstractCLaunchDelegate.getCProject(iProcess.getLaunch().getLaunchConfiguration());
                }
                catch (CoreException coreException) {}
                if (iCProject != null) {
                    try {
                        iCProject.getProject().refreshLocal(2, null);
                    }
                    catch (CoreException coreException) {}
                }
            }
            ++n;
        }
    }
}

