/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.launch.internal.ui.AbstractCDebuggerTab;
import org.eclipse.cdt.launch.ui.ICDTLaunchHelpContextIds;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class CDebuggerTab
extends AbstractCDebuggerTab {
    protected Combo fDCombo;
    protected Button fStopInMain;
    protected Button fAttachButton;
    protected Button fRunButton;
    protected Button fVarBookKeeping;
    private final boolean DEFAULT_STOP_AT_MAIN = true;

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)ICDTLaunchHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_DEBBUGER_TAB);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout(2, false);
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText("Debugger:");
        this.fDCombo = new Combo(composite3, 12);
        this.fDCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                CDebuggerTab.this.updateComboFromSelection();
            }
        });
        Composite composite4 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout(2, true);
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout2);
        this.fRunButton = this.createRadioButton(composite4, "Run program in debugger.");
        this.fRunButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (CDebuggerTab.this.fRunButton.getSelection()) {
                    CDebuggerTab.this.fStopInMain.setEnabled(true);
                } else {
                    CDebuggerTab.this.fStopInMain.setEnabled(false);
                }
                CDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fAttachButton = this.createRadioButton(composite4, "Attach to running process.");
        this.fAttachButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite composite5 = new Composite(composite2, 0);
        gridLayout = new GridLayout(2, false);
        composite5.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        composite5.setLayoutData((Object)gridData);
        this.fStopInMain = new Button(composite5, 32);
        this.fStopInMain.setText("Stop at main() on startup.");
        this.fStopInMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fVarBookKeeping = new Button(composite5, 32);
        this.fVarBookKeeping.setText("Automatically track the values of variables.");
        this.fVarBookKeeping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Group group = new Group(composite2, 16);
        group.setText("Debugger Options");
        this.setDynamicTabHolder((Composite)group);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.marginHeight = 0;
        gridLayout3.marginWidth = 0;
        gridLayout3.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)gridLayout3);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.getDynamicTabHolder().setLayoutData((Object)gridData);
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration iLaunchConfiguration, String string) {
        String string2 = this.getPlatform(iLaunchConfiguration);
        String string3 = "native";
        ICElement iCElement = this.getContext(iLaunchConfiguration, string2);
        if (iCElement instanceof IBinary) {
            IBinary iBinary = (IBinary)iCElement;
            string3 = iBinary.getCPU();
        }
        this.fDCombo.removeAll();
        ICDebugConfiguration[] iCDebugConfigurationArray = CDebugCorePlugin.getDefault().getDebugConfigurations();
        Arrays.sort(iCDebugConfigurationArray, new Comparator(){

            public int compare(Object object, Object object2) {
                ICDebugConfiguration iCDebugConfiguration = (ICDebugConfiguration)object;
                ICDebugConfiguration iCDebugConfiguration2 = (ICDebugConfiguration)object2;
                return iCDebugConfiguration.getName().compareTo(iCDebugConfiguration2.getName());
            }
        });
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < iCDebugConfigurationArray.length) {
            if (iCDebugConfigurationArray[n3].supportsMode("run") || iCDebugConfigurationArray[n3].supportsMode("attach")) {
                String string4 = iCDebugConfigurationArray[n3].getPlatform();
                boolean bl = string2.equals(BootLoader.getOS());
                if ((string4.equalsIgnoreCase(string2) || bl && string4.equalsIgnoreCase("native")) && iCDebugConfigurationArray[n3].supportsCPU(string3)) {
                    this.fDCombo.add(iCDebugConfigurationArray[n3].getName());
                    this.fDCombo.setData(Integer.toString(n), (Object)iCDebugConfigurationArray[n3]);
                    if (n2 == -1 && string4.equalsIgnoreCase(string2) || string.equals(iCDebugConfigurationArray[n3].getID())) {
                        n2 = n;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        this.setInitializeDefault(string.equals(""));
        this.fDCombo.select(n2 == -1 ? 0 : n2);
        this.updateComboFromSelection();
        this.fDCombo.getParent().layout(true);
    }

    protected void updateComboFromSelection() {
        this.handleDebuggerChanged();
        ICDebugConfiguration iCDebugConfiguration = this.getConfigForCurrentDebugger();
        if (iCDebugConfiguration != null) {
            this.fRunButton.setEnabled(iCDebugConfiguration.supportsMode("run"));
            this.fRunButton.setSelection(false);
            this.fAttachButton.setEnabled(iCDebugConfiguration.supportsMode("attach"));
            this.fAttachButton.setSelection(false);
            try {
                String string = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                if (string.equals("run") && this.fRunButton.isEnabled()) {
                    this.fRunButton.setSelection(true);
                } else if (string.equals("attach") && this.fAttachButton.isEnabled()) {
                    this.fAttachButton.setSelection(true);
                }
                if (this.fRunButton.getSelection()) {
                    this.fStopInMain.setEnabled(true);
                } else {
                    this.fStopInMain.setEnabled(false);
                }
            }
            catch (CoreException coreException) {}
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        super.setDefaults(iLaunchConfigurationWorkingCopy);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        super.initializeFrom(iLaunchConfiguration);
        try {
            String string;
            String string2 = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "");
            if (this.getDebugConfig() == null || !this.getDebugConfig().getID().equals(string2)) {
                this.loadDebuggerComboBox(iLaunchConfiguration, string2);
            }
            if ((string = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run")).equals("run")) {
                this.fRunButton.setSelection(true);
                this.fAttachButton.setSelection(false);
            } else if (string.equals("attach")) {
                this.fAttachButton.setSelection(true);
                this.fRunButton.setSelection(false);
            }
            if (iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true)) {
                this.fStopInMain.setSelection(true);
            }
            if (!iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false)) {
                this.fVarBookKeeping.setSelection(true);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (this.isValid((ILaunchConfiguration)iLaunchConfigurationWorkingCopy)) {
            super.performApply(iLaunchConfigurationWorkingCopy);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", !this.fVarBookKeeping.getSelection());
            if (this.fAttachButton.getSelection()) {
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
            } else {
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", this.fStopInMain.getSelection());
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            }
        }
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        if (!this.validateDebuggerConfig(iLaunchConfiguration)) {
            this.setErrorMessage("No debugger available");
            return false;
        }
        if (!super.isValid(iLaunchConfiguration)) {
            return false;
        }
        if (!this.fRunButton.getSelection() && !this.fAttachButton.getSelection()) {
            this.setErrorMessage("Select a Debug mode.");
            return false;
        }
        return true;
    }

    private boolean validateDebuggerConfig(ILaunchConfiguration iLaunchConfiguration) {
        ICDebugConfiguration iCDebugConfiguration;
        String string = this.getPlatform(iLaunchConfiguration);
        ICElement iCElement = this.getContext(iLaunchConfiguration, null);
        String string2 = this.getPlatform(iLaunchConfiguration);
        String string3 = "native";
        if (iCElement != null && iCElement instanceof IBinary) {
            iCDebugConfiguration = (IBinary)iCElement;
            string3 = iCDebugConfiguration.getCPU();
        }
        if ((iCDebugConfiguration = this.getDebugConfig()) == null) {
            return false;
        }
        String string4 = iCDebugConfiguration.getPlatform();
        boolean bl = string.equals(string2);
        return (string4.equalsIgnoreCase(string2) || bl && string4.equalsIgnoreCase("native")) && iCDebugConfiguration.supportsCPU(string3);
    }

    protected ICDebugConfiguration getConfigForCurrentDebugger() {
        int n = this.fDCombo.getSelectionIndex();
        return (ICDebugConfiguration)this.fDCombo.getData(Integer.toString(n));
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }
}

